/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.collect.ImmutableSet;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.model.animation.IJointClip;
import net.minecraftforge.common.model.animation.JointClips;

public enum B3DClip implements IClip
{
    INSTANCE;


    @Override
    public IJointClip apply(IJoint joint) {
        if (!(joint instanceof B3DLoader.NodeJoint)) {
            return JointClips.IdentityJointClip.INSTANCE;
        }
        return new NodeClip(((B3DLoader.NodeJoint)joint).getNode());
    }

    @Override
    public Iterable<Event> pastEvents(float lastPollTime, float time) {
        return ImmutableSet.of();
    }

    protected static class NodeClip
    implements IJointClip {
        private final B3DModel.Node<?> node;

        public NodeClip(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public TransformationMatrix apply(float time) {
            TransformationMatrix endTr;
            TransformationMatrix ret = TransformationMatrix.func_227983_a_();
            if (this.node.getAnimation() == null) {
                return ret.compose(new TransformationMatrix(this.node.getPos(), this.node.getRot(), this.node.getScale(), null));
            }
            int start = Math.max(1, (int)Math.round(Math.floor(time)));
            int end = Math.min(start + 1, (int)Math.round(Math.ceil(time)));
            float progress = time - (float)Math.floor(time);
            B3DModel.Key keyStart = (B3DModel.Key)this.node.getAnimation().getKeys().get((Object)start, this.node);
            B3DModel.Key keyEnd = (B3DModel.Key)this.node.getAnimation().getKeys().get((Object)end, this.node);
            TransformationMatrix startTr = keyStart == null ? null : new TransformationMatrix(keyStart.getPos(), keyStart.getRot(), keyStart.getScale(), null);
            TransformationMatrix transformationMatrix = endTr = keyEnd == null ? null : new TransformationMatrix(keyEnd.getPos(), keyEnd.getRot(), keyEnd.getScale(), null);
            ret = keyStart == null ? (keyEnd == null ? ret.compose(new TransformationMatrix(this.node.getPos(), this.node.getRot(), this.node.getScale(), null)) : ret.compose(endTr)) : ((double)progress < 1.0E-5 || keyEnd == null ? ret.compose(startTr) : ret.compose(TransformationHelper.slerp(startTr, endTr, progress)));
            return ret;
        }
    }
}

