/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SlotArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.command.impl.ReplaceItemCommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class LootCommand {
    public static final SuggestionProvider<CommandSource> field_218904_a = (commandContext, suggestionsBuilder) -> {
        LootTableManager lootTableManager = ((CommandSource)commandContext.getSource()).func_197028_i().func_200249_aQ();
        return ISuggestionProvider.func_197014_a(lootTableManager.func_215304_a(), suggestionsBuilder);
    };
    private static final DynamicCommandExceptionType field_218905_b = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.drop.no_held_items", object));
    private static final DynamicCommandExceptionType field_218906_c = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.drop.no_loot_table", object));

    public static void func_218886_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)LootCommand.func_218868_a(Commands.func_197057_a("loot").requires(commandSource -> commandSource.func_197034_c(2)), (argumentBuilder, iTargetHandler) -> argumentBuilder.then(Commands.func_197057_a("fish").then(Commands.func_197056_a("loot_table", ResourceLocationArgument.func_197197_a()).suggests(field_218904_a).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("pos", BlockPosArgument.func_197276_a()).executes(commandContext -> LootCommand.func_218876_a((CommandContext<CommandSource>)commandContext, ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "loot_table"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), ItemStack.field_190927_a, iTargetHandler))).then(Commands.func_197056_a("tool", ItemArgument.func_197317_a()).executes(commandContext -> LootCommand.func_218876_a((CommandContext<CommandSource>)commandContext, ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "loot_table"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), ItemArgument.func_197316_a(commandContext, "tool").func_197320_a(1, false), iTargetHandler)))).then(Commands.func_197057_a("mainhand").executes(commandContext -> LootCommand.func_218876_a((CommandContext<CommandSource>)commandContext, ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "loot_table"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), LootCommand.func_218872_a((CommandSource)commandContext.getSource(), EquipmentSlotType.MAINHAND), iTargetHandler)))).then(Commands.func_197057_a("offhand").executes(commandContext -> LootCommand.func_218876_a((CommandContext<CommandSource>)commandContext, ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "loot_table"), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), LootCommand.func_218872_a((CommandSource)commandContext.getSource(), EquipmentSlotType.OFFHAND), iTargetHandler)))))).then(Commands.func_197057_a("loot").then(Commands.func_197056_a("loot_table", ResourceLocationArgument.func_197197_a()).suggests(field_218904_a).executes(commandContext -> LootCommand.func_218887_a((CommandContext<CommandSource>)commandContext, ResourceLocationArgument.func_197195_e((CommandContext<CommandSource>)commandContext, "loot_table"), iTargetHandler)))).then(Commands.func_197057_a("kill").then(Commands.func_197056_a("target", EntityArgument.func_197086_a()).executes(commandContext -> LootCommand.func_218869_a((CommandContext<CommandSource>)commandContext, EntityArgument.func_197088_a((CommandContext<CommandSource>)commandContext, "target"), iTargetHandler)))).then(Commands.func_197057_a("mine").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("pos", BlockPosArgument.func_197276_a()).executes(commandContext -> LootCommand.func_218879_a((CommandContext<CommandSource>)commandContext, BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), ItemStack.field_190927_a, iTargetHandler))).then(Commands.func_197056_a("tool", ItemArgument.func_197317_a()).executes(commandContext -> LootCommand.func_218879_a((CommandContext<CommandSource>)commandContext, BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), ItemArgument.func_197316_a(commandContext, "tool").func_197320_a(1, false), iTargetHandler)))).then(Commands.func_197057_a("mainhand").executes(commandContext -> LootCommand.func_218879_a((CommandContext<CommandSource>)commandContext, BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), LootCommand.func_218872_a((CommandSource)commandContext.getSource(), EquipmentSlotType.MAINHAND), iTargetHandler)))).then(Commands.func_197057_a("offhand").executes(commandContext -> LootCommand.func_218879_a((CommandContext<CommandSource>)commandContext, BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), LootCommand.func_218872_a((CommandSource)commandContext.getSource(), EquipmentSlotType.OFFHAND), iTargetHandler)))))));
    }

    private static <T extends ArgumentBuilder<CommandSource, T>> T func_218868_a(T t, ISourceArgumentBuilder iSourceArgumentBuilder) {
        return (T)t.then(((LiteralArgumentBuilder)Commands.func_197057_a("replace").then(Commands.func_197057_a("entity").then(Commands.func_197056_a("entities", EntityArgument.func_197093_b()).then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("slot", SlotArgument.func_197223_a()), (commandContext, list, iSuccessListener) -> LootCommand.func_218865_a(EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "entities"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), list.size(), list, iSuccessListener)).then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("count", IntegerArgumentType.integer((int)0)), (commandContext, list, iSuccessListener) -> LootCommand.func_218865_a(EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "entities"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count"), list, iSuccessListener))))))).then(Commands.func_197057_a("block").then(Commands.func_197056_a("targetPos", BlockPosArgument.func_197276_a()).then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("slot", SlotArgument.func_197223_a()), (commandContext, list, iSuccessListener) -> LootCommand.func_218894_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "targetPos"), SlotArgument.func_197221_a((CommandContext<CommandSource>)commandContext, "slot"), list.size(), list, iSuccessListener)).then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("count", IntegerArgumentType.integer((int)0)), (commandContext, list, iSuccessListener) -> LootCommand.func_218894_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "targetPos"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"slot"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count"), list, iSuccessListener))))))).then(Commands.func_197057_a("insert").then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("targetPos", BlockPosArgument.func_197276_a()), (commandContext, list, iSuccessListener) -> LootCommand.func_218900_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "targetPos"), list, iSuccessListener)))).then(Commands.func_197057_a("give").then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("players", EntityArgument.func_197094_d()), (commandContext, list, iSuccessListener) -> LootCommand.func_218859_a(EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "players"), list, iSuccessListener)))).then(Commands.func_197057_a("spawn").then(iSourceArgumentBuilder.construct((ArgumentBuilder<CommandSource, ?>)Commands.func_197056_a("targetPos", Vec3Argument.func_197301_a()), (commandContext, list, iSuccessListener) -> LootCommand.func_218881_a((CommandSource)commandContext.getSource(), Vec3Argument.func_197300_a((CommandContext<CommandSource>)commandContext, "targetPos"), list, iSuccessListener))));
    }

    private static IInventory func_218862_a(CommandSource commandSource, BlockPos blockPos) throws CommandSyntaxException {
        TileEntity tileEntity = commandSource.func_197023_e().func_175625_s(blockPos);
        if (!(tileEntity instanceof IInventory)) {
            throw ReplaceItemCommand.field_198608_a.create();
        }
        return (IInventory)((Object)tileEntity);
    }

    private static int func_218900_a(CommandSource commandSource, BlockPos blockPos, List<ItemStack> list, ISuccessListener iSuccessListener2) throws CommandSyntaxException {
        ISuccessListener iSuccessListener2;
        IInventory iInventory = LootCommand.func_218862_a(commandSource, blockPos);
        ArrayList \u26032 = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemStack : list) {
            if (!LootCommand.func_218890_a(iInventory, itemStack.func_77946_l())) continue;
            iInventory.func_70296_d();
            \u26032.add(itemStack);
        }
        iSuccessListener2.accept(\u26032);
        return \u26032.size();
    }

    private static boolean func_218890_a(IInventory iInventory, ItemStack itemStack) {
        boolean \u26034 = false;
        for (int i = 0; i < iInventory.func_70302_i_() && !itemStack.func_190926_b(); ++i) {
            ItemStack itemStack2 = iInventory.func_70301_a(i);
            if (!iInventory.func_94041_b(i, itemStack)) continue;
            if (itemStack2.func_190926_b()) {
                iInventory.func_70299_a(i, itemStack);
                \u26034 = true;
                break;
            }
            if (!LootCommand.func_218883_a(itemStack2, itemStack)) continue;
            int \u26032 = itemStack.func_77976_d() - itemStack2.func_190916_E();
            int \u26033 = Math.min(itemStack.func_190916_E(), \u26032);
            itemStack.func_190918_g(\u26033);
            itemStack2.func_190917_f(\u26033);
            \u26034 = true;
        }
        return \u26034;
    }

    private static int func_218894_a(CommandSource commandSource, BlockPos blockPos, int n, int n2, List<ItemStack> list, ISuccessListener iSuccessListener2) throws CommandSyntaxException {
        ISuccessListener iSuccessListener2;
        IInventory iInventory = LootCommand.func_218862_a(commandSource, blockPos);
        int \u26032 = iInventory.func_70302_i_();
        if (n < 0 || n >= \u26032) {
            throw ReplaceItemCommand.field_198609_b.create((Object)n);
        }
        ArrayList \u26033 = Lists.newArrayListWithCapacity((int)list.size());
        for (int i = 0; i < n2; ++i) {
            \u2603 = n + i;
            ItemStack itemStack = \u2603 = i < list.size() ? list.get(i) : ItemStack.field_190927_a;
            if (!iInventory.func_94041_b(\u2603, \u2603)) continue;
            iInventory.func_70299_a(\u2603, \u2603);
            \u26033.add(\u2603);
        }
        iSuccessListener2.accept(\u26033);
        return \u26033.size();
    }

    private static boolean func_218883_a(ItemStack itemStack, ItemStack itemStack2) {
        return itemStack.func_77973_b() == itemStack2.func_77973_b() && itemStack.func_77952_i() == itemStack2.func_77952_i() && itemStack.func_190916_E() <= itemStack.func_77976_d() && Objects.equals(itemStack.func_77978_p(), itemStack2.func_77978_p());
    }

    private static int func_218859_a(Collection<ServerPlayerEntity> collection, List<ItemStack> list, ISuccessListener iSuccessListener2) throws CommandSyntaxException {
        ISuccessListener iSuccessListener2;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (ItemStack itemStack : list) {
            for (ServerPlayerEntity serverPlayerEntity : collection) {
                if (!serverPlayerEntity.field_71071_by.func_70441_a(itemStack.func_77946_l())) continue;
                arrayList.add(itemStack);
            }
        }
        iSuccessListener2.accept(arrayList);
        return arrayList.size();
    }

    private static void func_218901_a(Entity entity, List<ItemStack> list, int n, int n2, List<ItemStack> list2) {
        for (int i = 0; i < n2; ++i) {
            ItemStack itemStack = \u2603 = i < list.size() ? list.get(i) : ItemStack.field_190927_a;
            if (!entity.func_174820_d(n + i, \u2603.func_77946_l())) continue;
            list2.add(\u2603);
        }
    }

    private static int func_218865_a(Collection<? extends Entity> collection, int n, int n2, List<ItemStack> list, ISuccessListener iSuccessListener2) throws CommandSyntaxException {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (Entity entity : collection) {
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)entity;
                serverPlayerEntity.field_71069_bz.func_75142_b();
                LootCommand.func_218901_a(entity, list, n, n2, arrayList);
                serverPlayerEntity.field_71069_bz.func_75142_b();
                continue;
            }
            LootCommand.func_218901_a(entity, list, n, n2, arrayList);
        }
        iSuccessListener2.accept(arrayList);
        return arrayList.size();
    }

    private static int func_218881_a(CommandSource commandSource, Vector3d vector3d, List<ItemStack> list, ISuccessListener iSuccessListener) throws CommandSyntaxException {
        ServerWorld serverWorld = commandSource.func_197023_e();
        list.forEach(itemStack -> {
            ItemEntity itemEntity = new ItemEntity(serverWorld, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c, itemStack.func_77946_l());
            itemEntity.func_174869_p();
            serverWorld.func_217376_c(itemEntity);
        });
        iSuccessListener.accept(list);
        return list.size();
    }

    private static void func_218875_a(CommandSource commandSource2, List<ItemStack> list) {
        if (list.size() == 1) {
            ItemStack itemStack = list.get(0);
            commandSource2.func_197030_a(new TranslationTextComponent("commands.drop.success.single", itemStack.func_190916_E(), itemStack.func_151000_E()), false);
        } else {
            CommandSource commandSource2;
            commandSource2.func_197030_a(new TranslationTextComponent("commands.drop.success.multiple", list.size()), false);
        }
    }

    private static void func_218860_a(CommandSource commandSource2, List<ItemStack> list, ResourceLocation resourceLocation) {
        if (list.size() == 1) {
            ItemStack itemStack = list.get(0);
            commandSource2.func_197030_a(new TranslationTextComponent("commands.drop.success.single_with_table", itemStack.func_190916_E(), itemStack.func_151000_E(), resourceLocation), false);
        } else {
            CommandSource commandSource2;
            commandSource2.func_197030_a(new TranslationTextComponent("commands.drop.success.multiple_with_table", list.size(), resourceLocation), false);
        }
    }

    private static ItemStack func_218872_a(CommandSource commandSource, EquipmentSlotType equipmentSlotType) throws CommandSyntaxException {
        Entity entity = commandSource.func_197027_g();
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).func_184582_a(equipmentSlotType);
        }
        throw field_218905_b.create((Object)entity.func_145748_c_());
    }

    private static int func_218879_a(CommandContext<CommandSource> commandContext, BlockPos blockPos, ItemStack itemStack, ITargetHandler iTargetHandler) throws CommandSyntaxException {
        CommandSource commandSource = (CommandSource)commandContext.getSource();
        ServerWorld \u26032 = commandSource.func_197023_e();
        BlockState \u26033 = \u26032.func_180495_p(blockPos);
        TileEntity \u26034 = \u26032.func_175625_s(blockPos);
        LootContext.Builder \u26035 = new LootContext.Builder(\u26032).func_216015_a(LootParameters.field_237457_g_, Vector3d.func_237489_a_(blockPos)).func_216015_a(LootParameters.field_216287_g, \u26033).func_216021_b(LootParameters.field_216288_h, \u26034).func_216021_b(LootParameters.field_216281_a, commandSource.func_197022_f()).func_216015_a(LootParameters.field_216289_i, itemStack);
        List<ItemStack> \u26036 = \u26033.func_215693_a(\u26035);
        return iTargetHandler.accept(commandContext, \u26036, list -> LootCommand.func_218860_a(commandSource, list, \u26033.func_177230_c().func_220068_i()));
    }

    private static int func_218869_a(CommandContext<CommandSource> commandContext, Entity entity, ITargetHandler iTargetHandler) throws CommandSyntaxException {
        if (!(entity instanceof LivingEntity)) {
            throw field_218906_c.create((Object)entity.func_145748_c_());
        }
        ResourceLocation resourceLocation = ((LivingEntity)entity).func_213346_cF();
        CommandSource \u26032 = (CommandSource)commandContext.getSource();
        LootContext.Builder \u26033 = new LootContext.Builder(\u26032.func_197023_e());
        Entity \u26034 = \u26032.func_197022_f();
        if (\u26034 instanceof PlayerEntity) {
            \u26033.func_216015_a(LootParameters.field_216282_b, (PlayerEntity)\u26034);
        }
        \u26033.func_216015_a(LootParameters.field_216283_c, DamageSource.field_76376_m);
        \u26033.func_216021_b(LootParameters.field_216285_e, \u26034);
        \u26033.func_216021_b(LootParameters.field_216284_d, \u26034);
        \u26033.func_216015_a(LootParameters.field_216281_a, entity);
        \u26033.func_216015_a(LootParameters.field_237457_g_, \u26032.func_197036_d());
        LootTable \u26035 = \u26032.func_197028_i().func_200249_aQ().func_186521_a(resourceLocation);
        List<ItemStack> \u26036 = \u26035.func_216113_a(\u26033.func_216022_a(LootParameterSets.field_216263_d));
        return iTargetHandler.accept(commandContext, \u26036, list -> LootCommand.func_218860_a(\u26032, list, resourceLocation));
    }

    private static int func_218887_a(CommandContext<CommandSource> commandContext, ResourceLocation resourceLocation, ITargetHandler iTargetHandler) throws CommandSyntaxException {
        CommandSource commandSource = (CommandSource)commandContext.getSource();
        LootContext.Builder \u26032 = new LootContext.Builder(commandSource.func_197023_e()).func_216021_b(LootParameters.field_216281_a, commandSource.func_197022_f()).func_216015_a(LootParameters.field_237457_g_, commandSource.func_197036_d());
        return LootCommand.func_218871_a(commandContext, resourceLocation, \u26032.func_216022_a(LootParameterSets.field_216261_b), iTargetHandler);
    }

    private static int func_218876_a(CommandContext<CommandSource> commandContext, ResourceLocation resourceLocation, BlockPos blockPos, ItemStack itemStack, ITargetHandler iTargetHandler) throws CommandSyntaxException {
        CommandSource commandSource = (CommandSource)commandContext.getSource();
        LootContext \u26032 = new LootContext.Builder(commandSource.func_197023_e()).func_216015_a(LootParameters.field_237457_g_, Vector3d.func_237489_a_(blockPos)).func_216015_a(LootParameters.field_216289_i, itemStack).func_216021_b(LootParameters.field_216281_a, commandSource.func_197022_f()).func_216022_a(LootParameterSets.field_216262_c);
        return LootCommand.func_218871_a(commandContext, resourceLocation, \u26032, iTargetHandler);
    }

    private static int func_218871_a(CommandContext<CommandSource> commandContext, ResourceLocation resourceLocation, LootContext lootContext, ITargetHandler iTargetHandler) throws CommandSyntaxException {
        CommandSource commandSource = (CommandSource)commandContext.getSource();
        LootTable \u26032 = commandSource.func_197028_i().func_200249_aQ().func_186521_a(resourceLocation);
        List<ItemStack> \u26033 = \u26032.func_216113_a(lootContext);
        return iTargetHandler.accept(commandContext, \u26033, list -> LootCommand.func_218875_a(commandSource, list));
    }

    @FunctionalInterface
    static interface ISourceArgumentBuilder {
        public ArgumentBuilder<CommandSource, ?> construct(ArgumentBuilder<CommandSource, ?> var1, ITargetHandler var2);
    }

    @FunctionalInterface
    static interface ITargetHandler {
        public int accept(CommandContext<CommandSource> var1, List<ItemStack> var2, ISuccessListener var3) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface ISuccessListener {
        public void accept(List<ItemStack> var1) throws CommandSyntaxException;
    }
}

