/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.server.ServerWorld;

public class InteractWithDoorTask
extends Task<LivingEntity> {
    @Nullable
    private PathPoint field_242292_b;
    private int field_242293_c;

    public InteractWithDoorTask() {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.field_220954_o, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT), MemoryModuleType.field_225462_q, (Object)((Object)MemoryModuleStatus.REGISTERED)));
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, LivingEntity livingEntity) {
        Path path = livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220954_o).get();
        if (path.func_242945_b() || path.func_75879_b()) {
            return false;
        }
        if (!Objects.equals(this.field_242292_b, path.func_237225_h_())) {
            this.field_242293_c = 20;
            return true;
        }
        if (this.field_242293_c > 0) {
            --this.field_242293_c;
        }
        return this.field_242293_c == 0;
    }

    @Override
    protected void func_212831_a_(ServerWorld serverWorld, LivingEntity livingEntity, long l) {
        BlockState blockState;
        Path path = livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220954_o).get();
        this.field_242292_b = path.func_237225_h_();
        PathPoint \u26032 = path.func_242950_i();
        PathPoint \u26033 = path.func_237225_h_();
        BlockPos \u26034 = \u26032.func_224759_a();
        BlockState \u26035 = serverWorld.func_180495_p(\u26034);
        if (\u26035.func_235714_a_(BlockTags.field_200152_g)) {
            Object object = (DoorBlock)\u26035.func_177230_c();
            if (!((DoorBlock)object).func_242664_h(\u26035)) {
                ((DoorBlock)object).func_242663_a(serverWorld, \u26035, \u26034, true);
            }
            this.func_242301_c(serverWorld, livingEntity, \u26034);
        }
        if ((blockState = serverWorld.func_180495_p((BlockPos)(object = \u26033.func_224759_a()))).func_235714_a_(BlockTags.field_200152_g) && !(\u2603 = (DoorBlock)blockState.func_177230_c()).func_242664_h(blockState)) {
            \u2603.func_242663_a(serverWorld, blockState, (BlockPos)object, true);
            this.func_242301_c(serverWorld, livingEntity, (BlockPos)object);
        }
        InteractWithDoorTask.func_242294_a(serverWorld, livingEntity, \u26032, \u26033);
    }

    public static void func_242294_a(ServerWorld serverWorld, LivingEntity livingEntity, @Nullable PathPoint pathPoint, @Nullable PathPoint pathPoint2) {
        Brain<Set<GlobalPos>> brain = livingEntity.func_213375_cj();
        if (brain.func_218191_a(MemoryModuleType.field_225462_q)) {
            Iterator<GlobalPos> iterator = brain.func_218207_c(MemoryModuleType.field_225462_q).get().iterator();
            while (iterator.hasNext()) {
                GlobalPos globalPos = iterator.next();
                BlockPos \u26032 = globalPos.func_218180_b();
                if (pathPoint != null && pathPoint.func_224759_a().equals(\u26032) || pathPoint2 != null && pathPoint2.func_224759_a().equals(\u26032)) continue;
                if (InteractWithDoorTask.func_242296_a(serverWorld, livingEntity, globalPos)) {
                    iterator.remove();
                    continue;
                }
                BlockState \u26033 = serverWorld.func_180495_p(\u26032);
                if (!\u26033.func_235714_a_(BlockTags.field_200152_g)) {
                    iterator.remove();
                    continue;
                }
                DoorBlock \u26034 = (DoorBlock)\u26033.func_177230_c();
                if (!\u26034.func_242664_h(\u26033)) {
                    iterator.remove();
                    continue;
                }
                if (InteractWithDoorTask.func_242295_a(serverWorld, livingEntity, \u26032)) {
                    iterator.remove();
                    continue;
                }
                \u26034.func_242663_a(serverWorld, \u26033, \u26032, false);
                iterator.remove();
            }
        }
    }

    private static boolean func_242295_a(ServerWorld serverWorld, LivingEntity livingEntity3, BlockPos blockPos) {
        Brain<List<LivingEntity>> brain = livingEntity3.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_220945_f)) {
            return false;
        }
        return brain.func_218207_c(MemoryModuleType.field_220945_f).get().stream().filter(livingEntity2 -> livingEntity2.func_200600_R() == livingEntity3.func_200600_R()).filter(livingEntity -> blockPos.func_218137_a(livingEntity.func_213303_ch(), 2.0)).anyMatch(livingEntity -> InteractWithDoorTask.func_242300_b(serverWorld, livingEntity, blockPos));
    }

    private static boolean func_242300_b(ServerWorld serverWorld, LivingEntity livingEntity, BlockPos blockPos) {
        if (!livingEntity.func_213375_cj().func_218191_a(MemoryModuleType.field_220954_o)) {
            return false;
        }
        Path path = livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220954_o).get();
        if (path.func_75879_b()) {
            return false;
        }
        PathPoint \u26032 = path.func_242950_i();
        if (\u26032 == null) {
            return false;
        }
        PathPoint \u26033 = path.func_237225_h_();
        return blockPos.equals(\u26032.func_224759_a()) || blockPos.equals(\u26033.func_224759_a());
    }

    private static boolean func_242296_a(ServerWorld serverWorld, LivingEntity livingEntity, GlobalPos globalPos) {
        return globalPos.func_239646_a_() != serverWorld.func_234923_W_() || !globalPos.func_218180_b().func_218137_a(livingEntity.func_213303_ch(), 2.0);
    }

    private void func_242301_c(ServerWorld serverWorld, LivingEntity livingEntity, BlockPos blockPos) {
        Brain<?> brain = livingEntity.func_213375_cj();
        GlobalPos \u26032 = GlobalPos.func_239648_a_(serverWorld.func_234923_W_(), blockPos);
        if (brain.func_218207_c(MemoryModuleType.field_225462_q).isPresent()) {
            brain.func_218207_c(MemoryModuleType.field_225462_q).get().add(\u26032);
        } else {
            brain.func_218205_a(MemoryModuleType.field_225462_q, Sets.newHashSet((Object[])new GlobalPos[]{\u26032}));
        }
    }
}

