/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager
extends JsonReloadListener {
    private static final Logger field_186525_a = LogManager.getLogger();
    private static final Gson field_186526_b = LootSerializers.func_237388_c_().create();
    private Map<ResourceLocation, LootTable> field_186527_c = ImmutableMap.of();
    private final LootPredicateManager field_227507_d_;

    public LootTableManager(LootPredicateManager lootPredicateManager) {
        super(field_186526_b, "loot_tables");
        this.field_227507_d_ = lootPredicateManager;
    }

    public LootTable func_186521_a(ResourceLocation resourceLocation) {
        return this.field_186527_c.getOrDefault(resourceLocation, LootTable.field_186464_a);
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonElement> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonElement \u26032 = map.remove(LootTables.field_186419_a);
        if (\u26032 != null) {
            field_186525_a.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.field_186419_a);
        }
        map.forEach((resourceLocation, jsonElement) -> {
            try {
                LootTable lootTable = (LootTable)field_186526_b.fromJson(jsonElement, LootTable.class);
                builder.put(resourceLocation, (Object)lootTable);
            }
            catch (Exception exception) {
                field_186525_a.error("Couldn't parse loot table {}", resourceLocation, (Object)exception);
            }
        });
        builder.put((Object)LootTables.field_186419_a, (Object)LootTable.field_186464_a);
        ImmutableMap \u26033 = builder.build();
        ValidationTracker \u26034 = new ValidationTracker(LootParameterSets.field_216266_g, this.field_227507_d_::func_227517_a_, arg_0 -> ((ImmutableMap)\u26033).get(arg_0));
        \u26033.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_(\u26034, resourceLocation, lootTable));
        \u26034.func_227527_a_().forEach((string, string2) -> field_186525_a.warn("Found validation problem in " + string + ": " + string2));
        this.field_186527_c = \u26033;
    }

    public static void func_227508_a_(ValidationTracker validationTracker, ResourceLocation resourceLocation, LootTable lootTable) {
        lootTable.func_227506_a_(validationTracker.func_227529_a_(lootTable.func_216122_a()).func_227531_a_("{" + resourceLocation + "}", resourceLocation));
    }

    public static JsonElement func_215301_a(LootTable lootTable) {
        return field_186526_b.toJsonTree((Object)lootTable);
    }

    public Set<ResourceLocation> func_215304_a() {
        return this.field_186527_c.keySet();
    }
}

