/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;

public class CopyNbt
extends LootFunction {
    private final Source field_215887_a;
    private final List<Operation> field_215888_c;
    private static final Function<Entity, INBT> field_215889_d = NBTPredicate::func_196981_b;
    private static final Function<TileEntity, INBT> field_215890_e = tileEntity -> tileEntity.func_189515_b(new CompoundNBT());

    private CopyNbt(ILootCondition[] iLootConditionArray, Source source, List<Operation> list) {
        super(iLootConditionArray);
        this.field_215887_a = source;
        this.field_215888_c = ImmutableList.copyOf(list);
    }

    @Override
    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237448_u_;
    }

    private static NBTPathArgument.NBTPath func_215880_b(String string) {
        try {
            return new NBTPathArgument().parse(new StringReader(string));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException("Failed to parse path " + string, commandSyntaxException);
        }
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(this.field_215887_a.field_216225_f);
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        INBT iNBT = this.field_215887_a.field_216226_g.apply(lootContext);
        if (iNBT != null) {
            this.field_215888_c.forEach(operation -> operation.func_216216_a(itemStack::func_196082_o, iNBT));
        }
        return itemStack;
    }

    public static Builder func_215881_a(Source source) {
        return new Builder(source);
    }

    static /* synthetic */ Function func_215884_b() {
        return field_215889_d;
    }

    static /* synthetic */ Function func_215883_c() {
        return field_215890_e;
    }

    public static class Serializer
    extends LootFunction.Serializer<CopyNbt> {
        @Override
        public void func_230424_a_(JsonObject jsonObject, CopyNbt copyNbt, JsonSerializationContext jsonSerializationContext) {
            super.func_230424_a_(jsonObject, copyNbt, jsonSerializationContext);
            jsonObject.addProperty("source", ((CopyNbt)copyNbt).field_215887_a.field_216224_e);
            JsonArray jsonArray = new JsonArray();
            copyNbt.field_215888_c.stream().map(Operation::func_216214_a).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            jsonObject.add("ops", (JsonElement)jsonArray);
        }

        @Override
        public CopyNbt func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray2) {
            ILootCondition[] iLootConditionArray2;
            Source source = Source.func_216223_a(JSONUtils.func_151200_h(jsonObject, "source"));
            ArrayList \u26032 = Lists.newArrayList();
            JsonArray \u26033 = JSONUtils.func_151214_t(jsonObject, "ops");
            for (JsonElement jsonElement : \u26033) {
                JsonObject jsonObject2 = JSONUtils.func_151210_l(jsonElement, "op");
                \u26032.add(Operation.func_216215_a(jsonObject2));
            }
            return new CopyNbt(iLootConditionArray2, source, \u26032);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    public static enum Source {
        THIS("this", LootParameters.field_216281_a, CopyNbt.func_215884_b()),
        KILLER("killer", LootParameters.field_216284_d, CopyNbt.func_215884_b()),
        KILLER_PLAYER("killer_player", LootParameters.field_216282_b, CopyNbt.func_215884_b()),
        BLOCK_ENTITY("block_entity", LootParameters.field_216288_h, CopyNbt.func_215883_c());

        public final String field_216224_e;
        public final LootParameter<?> field_216225_f;
        public final Function<LootContext, INBT> field_216226_g;

        private <T> Source(String string2, LootParameter<T> lootParameter, Function<? super T, INBT> function) {
            this.field_216224_e = string2;
            this.field_216225_f = lootParameter;
            this.field_216226_g = lootContext -> {
                Object t = lootContext.func_216031_c(lootParameter);
                return t != null ? (INBT)function.apply((Object)t) : null;
            };
        }

        public static Source func_216223_a(String string2) {
            String string2;
            for (Source source : Source.values()) {
                if (!source.field_216224_e.equals(string2)) continue;
                return source;
            }
            throw new IllegalArgumentException("Invalid tag source " + string2);
        }
    }

    public static enum Action {
        REPLACE("replace"){

            @Override
            public void func_216227_a(INBT iNBT, NBTPathArgument.NBTPath nBTPath, List<INBT> list) throws CommandSyntaxException {
                nBTPath.func_218076_b(iNBT, ((INBT)Iterables.getLast(list))::func_74737_b);
            }
        }
        ,
        APPEND("append"){

            @Override
            public void func_216227_a(INBT iNBT2, NBTPathArgument.NBTPath nBTPath, List<INBT> list) throws CommandSyntaxException {
                \u2603 = nBTPath.func_218073_a(iNBT2, ListNBT::new);
                \u2603.forEach(iNBT -> {
                    if (iNBT instanceof ListNBT) {
                        list.forEach(iNBT2 -> ((ListNBT)iNBT).add(iNBT2.func_74737_b()));
                    }
                });
            }
        }
        ,
        MERGE("merge"){

            @Override
            public void func_216227_a(INBT iNBT2, NBTPathArgument.NBTPath nBTPath, List<INBT> list) throws CommandSyntaxException {
                \u2603 = nBTPath.func_218073_a(iNBT2, CompoundNBT::new);
                \u2603.forEach(iNBT -> {
                    if (iNBT instanceof CompoundNBT) {
                        list.forEach(iNBT2 -> {
                            if (iNBT2 instanceof CompoundNBT) {
                                ((CompoundNBT)iNBT).func_197643_a((CompoundNBT)iNBT2);
                            }
                        });
                    }
                });
            }
        };

        private final String field_216230_d;

        public abstract void func_216227_a(INBT var1, NBTPathArgument.NBTPath var2, List<INBT> var3) throws CommandSyntaxException;

        private Action(String string2) {
            this.field_216230_d = string2;
        }

        public static Action func_216229_a(String string2) {
            String string2;
            for (Action action : Action.values()) {
                if (!action.field_216230_d.equals(string2)) continue;
                return action;
            }
            throw new IllegalArgumentException("Invalid merge strategy" + string2);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final Source field_216057_a;
        private final List<Operation> field_216058_b = Lists.newArrayList();

        private Builder(Source source) {
            this.field_216057_a = source;
        }

        public Builder func_216055_a(String string, String string2, Action action) {
            this.field_216058_b.add(new Operation(string, string2, action));
            return this;
        }

        public Builder func_216056_a(String string, String string2) {
            return this.func_216055_a(string, string2, Action.REPLACE);
        }

        @Override
        protected Builder func_212826_d_() {
            return this;
        }

        @Override
        public ILootFunction func_216052_b() {
            return new CopyNbt(this.func_216053_g(), this.field_216057_a, this.field_216058_b);
        }

        @Override
        protected /* synthetic */ LootFunction.Builder func_212826_d_() {
            return this.func_212826_d_();
        }
    }

    static class Operation {
        private final String field_216217_a;
        private final NBTPathArgument.NBTPath field_216218_b;
        private final String field_216219_c;
        private final NBTPathArgument.NBTPath field_216220_d;
        private final Action field_216221_e;

        private Operation(String string, String string2, Action action) {
            this.field_216217_a = string;
            this.field_216218_b = CopyNbt.func_215880_b(string);
            this.field_216219_c = string2;
            this.field_216220_d = CopyNbt.func_215880_b(string2);
            this.field_216221_e = action;
        }

        public void func_216216_a(Supplier<INBT> supplier, INBT iNBT) {
            try {
                List<INBT> list = this.field_216218_b.func_218071_a(iNBT);
                if (!list.isEmpty()) {
                    this.field_216221_e.func_216227_a(supplier.get(), this.field_216220_d, list);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }

        public JsonObject func_216214_a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("source", this.field_216217_a);
            jsonObject.addProperty("target", this.field_216219_c);
            jsonObject.addProperty("op", this.field_216221_e.field_216230_d);
            return jsonObject;
        }

        public static Operation func_216215_a(JsonObject jsonObject) {
            String string = JSONUtils.func_151200_h(jsonObject, "source");
            \u2603 = JSONUtils.func_151200_h(jsonObject, "target");
            Action \u26032 = Action.func_216229_a(JSONUtils.func_151200_h(jsonObject, "op"));
            return new Operation(string, \u2603, \u26032);
        }
    }
}

