/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.state.Property;
import net.minecraft.util.IStringSerializable;

public class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final ImmutableSet<T> field_177711_a;
    private final Map<String, T> field_177710_b = Maps.newHashMap();

    protected EnumProperty(String string, Class<T> clazz, Collection<T> collection) {
        super(string, clazz);
        this.field_177711_a = ImmutableSet.copyOf(collection);
        for (Enum enum_ : collection) {
            String string2 = ((IStringSerializable)((Object)enum_)).func_176610_l();
            if (this.field_177710_b.containsKey(string2)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + string2 + "'");
            }
            this.field_177710_b.put(string2, enum_);
        }
    }

    @Override
    public Collection<T> func_177700_c() {
        return this.field_177711_a;
    }

    @Override
    public Optional<T> func_185929_b(String string) {
        return Optional.ofNullable(this.field_177710_b.get(string));
    }

    @Override
    public String func_177702_a(T t) {
        return ((IStringSerializable)t).func_176610_l();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EnumProperty && super.equals(object)) {
            EnumProperty enumProperty = (EnumProperty)object;
            return this.field_177711_a.equals(enumProperty.field_177711_a) && this.field_177710_b.equals(enumProperty.field_177710_b);
        }
        return false;
    }

    @Override
    public int func_206906_c() {
        int n = super.func_206906_c();
        n = 31 * n + this.field_177711_a.hashCode();
        n = 31 * n + this.field_177710_b.hashCode();
        return n;
    }

    public static <T extends Enum<T>> EnumProperty<T> func_177709_a(String string, Class<T> clazz) {
        return EnumProperty.func_177708_a(string, clazz, Predicates.alwaysTrue());
    }

    public static <T extends Enum<T>> EnumProperty<T> func_177708_a(String string, Class<T> clazz, Predicate<T> predicate) {
        return EnumProperty.func_177707_a(string, clazz, Arrays.stream(clazz.getEnumConstants()).filter(predicate).collect(Collectors.toList()));
    }

    public static <T extends Enum<T>> EnumProperty<T> func_177706_a(String string, Class<T> clazz, T ... TArray) {
        return EnumProperty.func_177707_a(string, clazz, Lists.newArrayList((Object[])TArray));
    }

    public static <T extends Enum<T>> EnumProperty<T> func_177707_a(String string, Class<T> clazz, Collection<T> collection) {
        return new EnumProperty<T>(string, clazz, collection);
    }
}

