/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.base.Joiner;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextComponentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NBTTextComponent
extends TextComponent
implements ITargetedTextComponent {
    private static final Logger field_218681_e = LogManager.getLogger();
    protected final boolean field_218678_b;
    protected final String field_218679_c;
    @Nullable
    protected final NBTPathArgument.NBTPath field_218680_d;

    @Nullable
    private static NBTPathArgument.NBTPath func_218672_b(String string) {
        try {
            return new NBTPathArgument().parse(new StringReader(string));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public NBTTextComponent(String string, boolean bl) {
        this(string, NBTTextComponent.func_218672_b(string), bl);
    }

    protected NBTTextComponent(String string, @Nullable NBTPathArgument.NBTPath nBTPath, boolean bl) {
        this.field_218679_c = string;
        this.field_218680_d = nBTPath;
        this.field_218678_b = bl;
    }

    protected abstract Stream<CompoundNBT> func_218673_a(CommandSource var1) throws CommandSyntaxException;

    public String func_218676_i() {
        return this.field_218679_c;
    }

    public boolean func_218677_j() {
        return this.field_218678_b;
    }

    @Override
    public IFormattableTextComponent func_230535_a_(@Nullable CommandSource commandSource, @Nullable net.minecraft.entity.Entity entity, int n) throws CommandSyntaxException {
        if (commandSource == null || this.field_218680_d == null) {
            return new StringTextComponent("");
        }
        Stream<String> stream = this.func_218673_a(commandSource).flatMap(compoundNBT -> {
            try {
                return this.field_218680_d.func_218071_a((INBT)compoundNBT).stream();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return Stream.empty();
            }
        }).map(INBT::func_150285_a_);
        if (this.field_218678_b) {
            return stream.flatMap(string -> {
                try {
                    IFormattableTextComponent iFormattableTextComponent = ITextComponent.Serializer.func_240643_a_(string);
                    return Stream.of(TextComponentUtils.func_240645_a_(commandSource, iFormattableTextComponent, entity, n));
                }
                catch (Exception exception) {
                    field_218681_e.warn("Failed to parse component: " + string, (Throwable)exception);
                    return Stream.of(new IFormattableTextComponent[0]);
                }
            }).reduce((iFormattableTextComponent, iFormattableTextComponent2) -> iFormattableTextComponent.func_240702_b_(", ").func_230529_a_((ITextComponent)iFormattableTextComponent2)).orElse(new StringTextComponent(""));
        }
        return new StringTextComponent(Joiner.on((String)", ").join(stream.iterator()));
    }

    public static class Storage
    extends NBTTextComponent {
        private final ResourceLocation field_229725_e_;

        public Storage(String string, boolean bl, ResourceLocation resourceLocation) {
            super(string, bl);
            this.field_229725_e_ = resourceLocation;
        }

        public Storage(String string, @Nullable NBTPathArgument.NBTPath nBTPath, boolean bl, ResourceLocation resourceLocation) {
            super(string, nBTPath, bl);
            this.field_229725_e_ = resourceLocation;
        }

        public ResourceLocation func_229726_k_() {
            return this.field_229725_e_;
        }

        @Override
        public Storage func_230531_f_() {
            return new Storage(this.field_218679_c, this.field_218680_d, this.field_218678_b, this.field_229725_e_);
        }

        @Override
        protected Stream<CompoundNBT> func_218673_a(CommandSource commandSource) {
            CompoundNBT compoundNBT = commandSource.func_197028_i().func_229735_aN_().func_227488_a_(this.field_229725_e_);
            return Stream.of(compoundNBT);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Storage) {
                Storage storage = (Storage)object;
                return Objects.equals(this.field_229725_e_, storage.field_229725_e_) && Objects.equals(this.field_218679_c, storage.field_218679_c) && super.equals(object);
            }
            return false;
        }

        @Override
        public String toString() {
            return "StorageNbtComponent{id='" + this.field_229725_e_ + '\'' + "path='" + this.field_218679_c + '\'' + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
        }

        @Override
        public /* synthetic */ TextComponent func_230531_f_() {
            return this.func_230531_f_();
        }

        @Override
        public /* synthetic */ IFormattableTextComponent func_230531_f_() {
            return this.func_230531_f_();
        }
    }

    public static class Block
    extends NBTTextComponent {
        private final String field_218684_e;
        @Nullable
        private final ILocationArgument field_218685_f;

        public Block(String string, boolean bl, String string2) {
            super(string, bl);
            this.field_218684_e = string2;
            this.field_218685_f = this.func_218682_b(this.field_218684_e);
        }

        @Nullable
        private ILocationArgument func_218682_b(String string) {
            try {
                return BlockPosArgument.func_197276_a().parse(new StringReader(string));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return null;
            }
        }

        private Block(String string, @Nullable NBTPathArgument.NBTPath nBTPath, boolean bl, String string2, @Nullable ILocationArgument iLocationArgument) {
            super(string, nBTPath, bl);
            this.field_218684_e = string2;
            this.field_218685_f = iLocationArgument;
        }

        @Nullable
        public String func_218683_k() {
            return this.field_218684_e;
        }

        @Override
        public Block func_230531_f_() {
            return new Block(this.field_218679_c, this.field_218680_d, this.field_218678_b, this.field_218684_e, this.field_218685_f);
        }

        @Override
        protected Stream<CompoundNBT> func_218673_a(CommandSource commandSource) {
            if (this.field_218685_f != null && (\u2603 = commandSource.func_197023_e()).func_195588_v(\u2603 = this.field_218685_f.func_197280_c(commandSource)) && (\u2603 = \u2603.func_175625_s(\u2603)) != null) {
                return Stream.of(\u2603.func_189515_b(new CompoundNBT()));
            }
            return Stream.empty();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Block) {
                Block block = (Block)object;
                return Objects.equals(this.field_218684_e, block.field_218684_e) && Objects.equals(this.field_218679_c, block.field_218679_c) && super.equals(object);
            }
            return false;
        }

        @Override
        public String toString() {
            return "BlockPosArgument{pos='" + this.field_218684_e + '\'' + "path='" + this.field_218679_c + '\'' + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
        }

        @Override
        public /* synthetic */ TextComponent func_230531_f_() {
            return this.func_230531_f_();
        }

        @Override
        public /* synthetic */ IFormattableTextComponent func_230531_f_() {
            return this.func_230531_f_();
        }
    }

    public static class Entity
    extends NBTTextComponent {
        private final String field_218688_e;
        @Nullable
        private final EntitySelector field_218689_f;

        public Entity(String string, boolean bl, String string2) {
            super(string, bl);
            this.field_218688_e = string2;
            this.field_218689_f = Entity.func_218686_b(string2);
        }

        @Nullable
        private static EntitySelector func_218686_b(String string) {
            try {
                EntitySelectorParser entitySelectorParser = new EntitySelectorParser(new StringReader(string));
                return entitySelectorParser.func_201345_m();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return null;
            }
        }

        private Entity(String string, @Nullable NBTPathArgument.NBTPath nBTPath, boolean bl, String string2, @Nullable EntitySelector entitySelector) {
            super(string, nBTPath, bl);
            this.field_218688_e = string2;
            this.field_218689_f = entitySelector;
        }

        public String func_218687_k() {
            return this.field_218688_e;
        }

        @Override
        public Entity func_230531_f_() {
            return new Entity(this.field_218679_c, this.field_218680_d, this.field_218678_b, this.field_218688_e, this.field_218689_f);
        }

        @Override
        protected Stream<CompoundNBT> func_218673_a(CommandSource commandSource) throws CommandSyntaxException {
            if (this.field_218689_f != null) {
                List<? extends net.minecraft.entity.Entity> list = this.field_218689_f.func_197341_b(commandSource);
                return list.stream().map(NBTPredicate::func_196981_b);
            }
            return Stream.empty();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                return Objects.equals(this.field_218688_e, entity.field_218688_e) && Objects.equals(this.field_218679_c, entity.field_218679_c) && super.equals(object);
            }
            return false;
        }

        @Override
        public String toString() {
            return "EntityNbtComponent{selector='" + this.field_218688_e + '\'' + "path='" + this.field_218679_c + '\'' + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
        }

        @Override
        public /* synthetic */ TextComponent func_230531_f_() {
            return this.func_230531_f_();
        }

        @Override
        public /* synthetic */ IFormattableTextComponent func_230531_f_() {
            return this.func_230531_f_();
        }
    }
}

