/*
 * Decompiled with CFR 0.152.
 */
package com.otg.presetpacker.dregora;

import com.otg.presetpacker.dregora.ClientOutdatedPresetScreen;
import com.otg.presetpacker.dregora.PresetUnpackUtil;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dregora")
@Mod.EventBusSubscriber
public class PresetPackerForge {
    private static PresetUnpackUtil util;

    public PresetPackerForge() {
        Logger logger = LogManager.getLogger((String)"dregora");
        try {
            String presetFolderPath = new File(".").getCanonicalPath() + File.separator + "config" + File.separator + "OpenTerrainGenerator" + File.separator + "Presets" + File.separator;
            logger.log(Level.INFO, "Starting extraction of Dregora");
            JarFile jarFile = new JarFile(ModList.get().getModFileById("dregora").getFile().getFilePath().toFile());
            boolean isServer = ForgeConfig.CLIENT == null;
            util = new PresetUnpackUtil();
            int filesWritten = util.extractPreset(jarFile, presetFolderPath, isServer);
            jarFile.close();
            if (filesWritten > 0) {
                logger.log(Level.INFO, "Preset Dregora extracted, wrote " + filesWritten + " files");
            } else {
                logger.log(Level.INFO, "Preset Dregora was already up to date, skipped");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onGuiOpen(GuiOpenEvent evt) {
        if (evt.getGui() instanceof MainMenuScreen && !PresetPackerForge.util.PRESET_NAME.isEmpty()) {
            evt.setGui((Screen)new ClientOutdatedPresetScreen((ITextComponent)new StringTextComponent("Preset Update"), PresetPackerForge.util.PRESET_NAME.remove(0), PresetPackerForge.util.OLD_MAJOR_VERSION.remove(0), PresetPackerForge.util.NEW_MAJOR_VERSION.remove(0), PresetPackerForge.util.PRESET_PATH.remove(0)));
        }
    }
}

