/*
 * Decompiled with CFR 0.152.
 */
package com.otg.presetpacker.dregora;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PresetUnpackUtil {
    public List<String> PRESET_NAME = new ArrayList<String>();
    public List<Integer> NEW_MAJOR_VERSION = new ArrayList<Integer>();
    public List<Integer> OLD_MAJOR_VERSION = new ArrayList<Integer>();
    public List<Path> PRESET_PATH = new ArrayList<Path>();

    public int extractPreset(JarFile jarFile, String presetFolderPath, boolean isDedicatedServer) throws IOException {
        String presetName;
        JarEntry jarEntry;
        Enumeration<JarEntry> entries = jarFile.entries();
        HashMap srcWorldFilesInJar = new HashMap();
        int filesWritten = 0;
        while (entries.hasMoreElements()) {
            jarEntry = entries.nextElement();
            if (!jarEntry.getName().contains("WorldConfig.ini")) continue;
            presetName = jarEntry.getName().split("/")[1];
            int[] newVersion = PresetUnpackUtil.getVersions(new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry))));
            File oldInstallDir = new File(presetFolderPath + presetName);
            if (oldInstallDir.exists()) {
                int[] installedVersion = PresetUnpackUtil.getVersions(new BufferedReader(new FileReader(presetFolderPath + presetName + File.separator + "WorldConfig.ini")));
                if (newVersion[1] <= installedVersion[1] && newVersion[0] <= installedVersion[0]) continue;
                if (newVersion[0] > installedVersion[0]) {
                    if (isDedicatedServer) {
                        System.out.print("\u001b[33m");
                        System.out.println("\u001b[33m############# UPDATE SKIPPED #############");
                        System.out.println("\u001b[33mFailed to update OTG preset " + presetName + " in " + oldInstallDir.getAbsolutePath() + " but it's too old to be updated.");
                        System.out.println("\u001b[33mUpdating may lead to errors and seams for existing worlds using this preset.");
                        System.out.println("\u001b[33mTo force update, delete " + oldInstallDir.getAbsolutePath() + ". Always back up your world save files before updating.");
                        System.out.print("\u001b[0m");
                        continue;
                    }
                    if (oldInstallDir.toPath().resolve(".REPLACE_ME").toFile().exists()) {
                        oldInstallDir.toPath().resolve(".REPLACE_ME").toFile().delete();
                    } else {
                        if (oldInstallDir.toPath().resolve(".DENY_PRESET_UPDATE").toFile().exists()) continue;
                        this.PRESET_NAME.add(presetName);
                        this.NEW_MAJOR_VERSION.add(newVersion[0]);
                        this.OLD_MAJOR_VERSION.add(installedVersion[0]);
                        this.PRESET_PATH.add(oldInstallDir.toPath());
                        continue;
                    }
                }
            }
            srcWorldFilesInJar.put(presetName, new ArrayList());
        }
        entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            jarEntry = entries.nextElement();
            if (!jarEntry.getName().startsWith("Presets/") || jarEntry.getName().equalsIgnoreCase("presets/") || !srcWorldFilesInJar.containsKey(presetName = jarEntry.getName().split("/")[1])) continue;
            ((ArrayList)srcWorldFilesInJar.get(presetName)).add(jarEntry);
        }
        Path presetInstallPath = new File(presetFolderPath).toPath().getParent();
        for (String key : srcWorldFilesInJar.keySet()) {
            for (JarEntry entry : (ArrayList)srcWorldFilesInJar.get(key)) {
                File f = presetInstallPath.resolve(entry.getName()).toFile();
                if (entry.isDirectory()) {
                    f.mkdirs();
                } else {
                    int i;
                    f.createNewFile();
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] byteArray = new byte[4096];
                    InputStream is = jarFile.getInputStream(entry);
                    while ((i = is.read(byteArray)) > 0) {
                        fos.write(byteArray, 0, i);
                    }
                    is.close();
                    fos.close();
                }
                ++filesWritten;
            }
        }
        return filesWritten;
    }

    private static int[] getVersions(BufferedReader reader) throws IOException {
        String line;
        int[] arr = new int[]{0, 0};
        while ((line = reader.readLine()) != null) {
            if (line.contains("MajorVersion:")) {
                arr[0] = Integer.parseInt(line.split(":")[1].trim());
            }
            if (!line.contains("MinorVersion:")) continue;
            arr[1] = Integer.parseInt(line.split(":")[1].trim());
        }
        return arr;
    }
}

