/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

import com.pg85.otg.config.PluginConfig;
import com.pg85.otg.config.biome.BiomeConfig;
import com.pg85.otg.config.biome.BiomeResourcesManager;
import com.pg85.otg.config.io.FileSettingsReader;
import com.pg85.otg.config.io.FileSettingsWriter;
import com.pg85.otg.config.standard.WorldStandardValues;
import com.pg85.otg.config.world.WorldConfig;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IPluginConfig;
import com.pg85.otg.presets.LocalPresetLoader;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public abstract class OTGEngine {
    protected final LocalPresetLoader presetLoader;
    protected final ILogger logger;
    private final IModLoadedChecker modLoadedChecker;
    private final Path otgRootFolder;
    private final Path globalObjectsFolder;
    protected PluginConfig pluginConfig;
    protected BiomeResourcesManager biomeResourcesManager;
    private CustomObjectResourcesManager customObjectResourcesManager;
    private CustomObjectManager customObjectManager;

    protected OTGEngine(ILogger logger, Path otgRootFolder, IModLoadedChecker modLoadedChecker, LocalPresetLoader presetLoader) {
        this.logger = logger;
        this.otgRootFolder = otgRootFolder;
        this.globalObjectsFolder = otgRootFolder.resolve("GlobalObjects");
        this.presetLoader = presetLoader;
        this.modLoadedChecker = modLoadedChecker;
    }

    public abstract File getJarFile();

    public void onStart() {
        File globalObjectsDir;
        File dimensionConfigsDir;
        File pluginConfigFile = Paths.get(this.getOTGRootFolder().toString(), "OTG.ini").toFile();
        this.pluginConfig = new PluginConfig(FileSettingsReader.read("OTG.ini", pluginConfigFile, null), this.biomeResourcesManager, this.logger);
        this.logger.init(this.pluginConfig.getLogLevel().getLevel(), this.pluginConfig.logCustomObjects(), this.pluginConfig.logStructurePlotting(), this.pluginConfig.logConfigs(), this.pluginConfig.logBiomeRegistry(), this.pluginConfig.logPerformance(), this.pluginConfig.logDecoration(), this.pluginConfig.logMobs(), this.pluginConfig.logPresets());
        FileSettingsWriter.writeToFile(this.pluginConfig.getSettingsAsMap(), pluginConfigFile, this.pluginConfig.getSettingsMode(), this.logger);
        File presetsDir = Paths.get(this.getOTGRootFolder().toString(), "Presets").toFile();
        if (!presetsDir.exists()) {
            presetsDir.mkdirs();
        }
        if (!(dimensionConfigsDir = Paths.get(this.getOTGRootFolder().toString(), "DimensionConfigs").toFile()).exists()) {
            dimensionConfigsDir.mkdirs();
        }
        if (!(globalObjectsDir = this.globalObjectsFolder.toFile()).exists()) {
            globalObjectsDir.mkdirs();
        }
        this.unpackDefaultPresetAndExamples(presetsDir);
        this.customObjectResourcesManager = new CustomObjectResourcesManager();
        this.customObjectManager = new CustomObjectManager(this.getPluginConfig().getDeveloperModeEnabled(), this.logger, this.otgRootFolder, this.getPresetsDirectory(), this.customObjectResourcesManager);
        HashMap configFunctions = new HashMap();
        configFunctions.putAll(WorldConfig.CONFIG_FUNCTIONS);
        configFunctions.putAll(BiomeConfig.RESOURCE_QUEUE_RESOURCES);
        this.biomeResourcesManager = new BiomeResourcesManager(configFunctions);
        this.presetLoader.loadPresetsFromDisk(this.biomeResourcesManager, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackDefaultPresetAndExamples(File presetsDir) {
        ZipFile jarFile = null;
        try {
            File jarFileLocation = this.getJarFile();
            if (jarFileLocation == null || !jarFileLocation.exists()) {
                this.logger.log(LogLevel.WARN, LogCategory.MAIN, "Could not find root jar file, skipping default preset and example dimension configs unpack (copy them manually from the resources folder for development).");
            } else {
                File wc;
                jarFile = new JarFile(jarFileLocation);
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                if (new File(presetsDir.getPath() + File.separator + "Default").exists() && (wc = new File(presetsDir.getPath() + File.separator + "Default" + File.separator + "WorldConfig.ini")).exists()) {
                    BufferedReader reader = new BufferedReader(new FileReader(wc));
                    int oldMajorVer = this.parseMajorVersion(reader);
                    int oldMinorVer = this.parseMinorVersion(reader);
                    int newMajorVer = 0;
                    int newMinorVer = 0;
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (!jarEntry.getName().contains("Default/WorldConfig.ini")) continue;
                        reader = new BufferedReader(new BufferedReader(new InputStreamReader(((JarFile)jarFile).getInputStream(jarEntry))));
                        newMajorVer = this.parseMajorVersion(reader);
                        newMinorVer = this.parseMinorVersion(reader);
                    }
                    if (newMajorVer < oldMajorVer || newMajorVer == oldMajorVer && newMinorVer <= oldMinorVer) {
                        return;
                    }
                }
                String rootDir = this.getOTGRootFolder().toString();
                String defaultPresetPath = "resources/Presets/Default/";
                String dimensionConfigsPath = "resources/DimensionConfigs/";
                entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    int i;
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(dimensionConfigsPath) && !entry.getName().startsWith(defaultPresetPath)) continue;
                    File file = new File(rootDir + File.separator + entry.getName().substring(10));
                    if (entry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    file.createNewFile();
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] byteArray = new byte[4096];
                    InputStream is = ((JarFile)jarFile).getInputStream(entry);
                    while ((i = is.read(byteArray)) > 0) {
                        fos.write(byteArray, 0, i);
                    }
                    is.close();
                    fos.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private int parseMajorVersion(BufferedReader reader) throws IOException {
        return this.parseVersion(reader, WorldStandardValues.MAJOR_VERSION.getName());
    }

    private int parseMinorVersion(BufferedReader reader) throws IOException {
        return this.parseVersion(reader, WorldStandardValues.MINOR_VERSION.getName());
    }

    private int parseVersion(BufferedReader reader, String name) throws IOException {
        String line;
        int version = -1;
        while ((line = reader.readLine()) != null && !line.contains(name)) {
        }
        if (line != null) {
            String v = line.split(":")[1];
            v = v.trim();
            version = Integer.parseInt(v);
        }
        return version;
    }

    public void onShutdown() {
        this.customObjectManager.shutdown();
    }

    public BiomeResourcesManager getBiomeResourceManager() {
        return this.biomeResourcesManager;
    }

    public CustomObjectResourcesManager getCustomObjectResourcesManager() {
        return this.customObjectResourcesManager;
    }

    public CustomObjectManager getCustomObjectManager() {
        return this.customObjectManager;
    }

    public LocalPresetLoader getPresetLoader() {
        return this.presetLoader;
    }

    public IModLoadedChecker getModLoadedChecker() {
        return this.modLoadedChecker;
    }

    public IPluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public Path getOTGRootFolder() {
        return this.otgRootFolder;
    }

    public Path getGlobalObjectsFolder() {
        return this.globalObjectsFolder;
    }

    public Path getPresetsDirectory() {
        return Paths.get(this.getOTGRootFolder().toString(), "Presets");
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public CustomStructureCache createCustomStructureCache(String presetFolderName, Path worldSavepath, long worldSeed, boolean isBo4Enabled) {
        return new CustomStructureCache(presetFolderName, worldSavepath, worldSeed, isBo4Enabled, this.getOTGRootFolder(), this.getLogger(), this.getCustomObjectManager(), this.getPresetLoader().getMaterialReader(presetFolderName), this.getCustomObjectResourcesManager(), null);
    }
}

