/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config;

import com.pg85.otg.config.io.IConfigFunctionProvider;
import com.pg85.otg.config.io.SettingsMap;
import com.pg85.otg.config.io.SimpleSettingsMap;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.minecraft.BiomeRegistryNames;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class ConfigFile {
    protected final String configName;

    protected ConfigFile(String configName) {
        this.configName = configName;
    }

    public SettingsMap getSettingsAsMap() {
        SimpleSettingsMap settingsMap = new SimpleSettingsMap(this.configName);
        this.writeConfigSettings(settingsMap);
        return settingsMap;
    }

    protected abstract void writeConfigSettings(SettingsMap var1);

    protected abstract void readConfigSettings(SettingsMap var1, IConfigFunctionProvider var2, ILogger var3, IMaterialReader var4, String var5);

    protected abstract void validateAndCorrectSettings(Path var1, ILogger var2);

    protected abstract void renameOldSettings(SettingsMap var1, ILogger var2, IMaterialReader var3);

    protected final int higherThanOrEqualTo(int currentValue, int minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected final double higherThan(double currentValue, double minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected final int lowerThanOrEqualTo(int currentValue, int maximumValue) {
        if (currentValue > maximumValue) {
            return maximumValue;
        }
        return currentValue;
    }

    protected ArrayList<String> filterBiomes(List<String> biomes, ArrayList<String> customBiomes) {
        ArrayList<String> output = new ArrayList<String>();
        for (String key : biomes) {
            if (customBiomes.contains(key = key.trim())) {
                output.add(key);
                continue;
            }
            if (!BiomeRegistryNames.Contain(key)) continue;
            output.add(key);
        }
        return output;
    }

    public String getName() {
        return this.configName;
    }
}

