/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;

public abstract class ConfigFunction<T> {
    protected final void assureSize(int size, List<String> args) throws InvalidConfigException {
        if (args.size() < size) {
            throw new InvalidConfigException("Too few arguments supplied");
        }
    }

    protected final String makeMaterials(MaterialSet materials) {
        return "," + materials.toString();
    }

    public abstract String toString();

    protected final double readDouble(String string, double minValue, double maxValue) throws InvalidConfigException {
        return StringHelper.readDouble(string, minValue, maxValue);
    }

    protected final int readInt(String string, int minValue, int maxValue) throws InvalidConfigException {
        return StringHelper.readInt(string, minValue, maxValue);
    }

    protected final LocalMaterialData readMaterial(String string, IMaterialReader materialReader) throws InvalidConfigException {
        LocalMaterialData material = materialReader.readMaterial(string);
        return material;
    }

    protected final MaterialSet readMaterials(List<String> strings, int start, IMaterialReader materialReader) throws InvalidConfigException {
        MaterialSet materials = new MaterialSet();
        for (int i = start; i < strings.size(); ++i) {
            materials.parseAndAdd(strings.get(i), materialReader);
        }
        return materials;
    }

    protected final double readRarity(String string) throws InvalidConfigException {
        return StringHelper.readDouble(string, 1.0E-6, 100.0);
    }
}

