/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.biome;

import com.pg85.otg.config.ConfigFile;
import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.resource.CustomStructureResource;
import com.pg85.otg.customobject.resource.SaplingResource;
import com.pg85.otg.gen.surface.SurfaceGenerator;
import com.pg85.otg.interfaces.IBiome;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IBiomeResourceLocation;
import com.pg85.otg.interfaces.ICustomStructureGen;
import com.pg85.otg.interfaces.ISaplingSpawner;
import com.pg85.otg.interfaces.ISurfaceGeneratorNoiseProvider;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.biome.ColorSet;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.biome.WeightedMobSpawnGroup;
import com.pg85.otg.util.gen.ChunkBuffer;
import com.pg85.otg.util.gen.GeneratingChunk;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.minecraft.SaplingType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class BiomeConfigBase
extends ConfigFile
implements IBiomeConfig {
    private IBiomeResourceLocation registryKey;
    private int otgBiomeId;
    protected SettingsContainer settings = new SettingsContainer();

    protected BiomeConfigBase(String configName) {
        super(configName);
    }

    public List<ConfigFunction<IBiomeConfig>> getResourceQueue() {
        return this.settings.resourceQueue;
    }

    @Override
    public void setRegistryKey(IBiomeResourceLocation registryKey) {
        this.registryKey = registryKey;
    }

    @Override
    public IBiomeResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    @Override
    public void setOTGBiomeId(int id) {
        this.otgBiomeId = id;
    }

    @Override
    public int getOTGBiomeId() {
        return this.otgBiomeId;
    }

    @Override
    public LocalMaterialData getSurfaceBlockAtHeight(ISurfaceGeneratorNoiseProvider noiseProvider, int x, int y, int z) {
        return this.settings.surfaceAndGroundControl.getSurfaceBlockAtHeight(noiseProvider, this, x, y, z);
    }

    @Override
    public LocalMaterialData getGroundBlockAtHeight(ISurfaceGeneratorNoiseProvider noiseProvider, int x, int y, int z) {
        return this.settings.surfaceAndGroundControl.getGroundBlockAtHeight(noiseProvider, this, x, y, z);
    }

    @Override
    public LocalMaterialData getDefaultGroundBlock() {
        return this.settings.groundBlock;
    }

    @Override
    public LocalMaterialData getDefaultStoneBlock() {
        return this.settings.stoneBlock;
    }

    @Override
    public LocalMaterialData getDefaultWaterBlock() {
        return this.settings.waterBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReplaceBlocks() {
        if (!this.settings.replacedBlocksInited) {
            BiomeConfigBase biomeConfigBase = this;
            synchronized (biomeConfigBase) {
                if (!this.settings.replacedBlocksInited) {
                    this.settings.replacedBlocks.init(this.settings.useWorldWaterLevel ? this.settings.worldConfig.getCooledLavaBlock() : this.settings.cooledLavaBlock, this.settings.useWorldWaterLevel ? this.settings.worldConfig.getIceBlock() : this.settings.iceBlock, this.settings.packedIceBlock, this.settings.snowBlock, this.settings.useWorldWaterLevel ? this.settings.worldConfig.getWaterBlock() : this.settings.waterBlock, this.settings.stoneBlock, this.settings.groundBlock, this.settings.surfaceBlock, this.settings.underWaterSurfaceBlock, this.settings.worldConfig.getDefaultBedrockBlock(), this.settings.sandStoneBlock, this.settings.redSandStoneBlock);
                }
                this.settings.replacedBlocksInited = true;
            }
        }
    }

    @Override
    public LocalMaterialData getSurfaceBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesSurface) {
            return this.settings.surfaceBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.surfaceBlock;
    }

    @Override
    public LocalMaterialData getUnderWaterSurfaceBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesUnderWaterSurface) {
            return this.settings.underWaterSurfaceBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.underWaterSurfaceBlock;
    }

    @Override
    public LocalMaterialData getGroundBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesGround) {
            return this.settings.groundBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.groundBlock;
    }

    @Override
    public LocalMaterialData getStoneBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesStone) {
            return this.settings.stoneBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.stoneBlock;
    }

    @Override
    public LocalMaterialData getBedrockBlockReplaced(int y) {
        return this.settings.worldConfig.getBedrockBlockReplaced(this.getReplaceBlocks(), y);
    }

    @Override
    public LocalMaterialData getWaterBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesWater) {
            return this.settings.waterBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.waterBlock;
    }

    @Override
    public LocalMaterialData getSandStoneBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesSandStone) {
            return this.settings.sandStoneBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.sandStoneBlock;
    }

    @Override
    public LocalMaterialData getIceBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesIce) {
            return this.settings.iceBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.iceBlock;
    }

    @Override
    public LocalMaterialData getPackedIceBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesPackedIce) {
            return this.settings.packedIceBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.packedIceBlock;
    }

    @Override
    public LocalMaterialData getSnowBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesSnow) {
            return this.settings.snowBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.snowBlock;
    }

    @Override
    public LocalMaterialData getCooledLavaBlockReplaced(int y) {
        if (this.getReplaceBlocks().replacesCooledLava) {
            return this.settings.cooledLavaBlock.parseWithBiomeAndHeight(this.settings.worldConfig.getBiomeConfigsHaveReplacement(), this.getReplaceBlocks(), y);
        }
        return this.settings.cooledLavaBlock;
    }

    @Override
    public boolean hasReplaceBlocksSettings() {
        return this.settings.replacedBlocks.hasReplaceSettings();
    }

    @Override
    public ReplaceBlockMatrix getReplaceBlocks() {
        this.initReplaceBlocks();
        return this.settings.replacedBlocks;
    }

    @Override
    public List<List<String>> getCustomStructureNames() {
        ArrayList<List<String>> customStructureNamesByGen = new ArrayList<List<String>>();
        for (CustomStructureResource structureGens : this.settings.customStructures) {
            ArrayList<String> customStructureNames = new ArrayList<String>();
            for (String objectName : structureGens.objectNames) {
                customStructureNames.add(objectName);
            }
            customStructureNamesByGen.add(customStructureNames);
        }
        return customStructureNamesByGen;
    }

    @Override
    public List<ICustomStructureGen> getCustomStructures() {
        return new ArrayList<ICustomStructureGen>(this.settings.customStructures);
    }

    @Override
    public ICustomStructureGen getStructureGen() {
        return this.settings.structureGen;
    }

    @Override
    public void setStructureGen(ICustomStructureGen customStructureGen) {
        this.settings.structureGen = customStructureGen;
    }

    @Override
    public String getName() {
        return this.configName;
    }

    @Override
    public boolean getIsTemplateForBiome() {
        return this.settings.isTemplateForBiome;
    }

    @Override
    public String getBiomeCategory() {
        return this.settings.biomeCategory;
    }

    @Override
    public float getBiomeTemperature() {
        return this.settings.biomeTemperature;
    }

    @Override
    public boolean useFrozenOceanTemperature() {
        return this.settings.useFrozenOceanTemperature;
    }

    @Override
    public float getBiomeHeight() {
        return this.settings.biomeHeight;
    }

    @Override
    public float getBiomeVolatility() {
        return this.settings.biomeVolatility;
    }

    @Override
    public double getVolatility1() {
        return this.settings.volatility1;
    }

    @Override
    public double getVolatility2() {
        return this.settings.volatility2;
    }

    @Override
    public int getBiomeColor() {
        return this.settings.biomeColor;
    }

    @Override
    public List<String> getBiomeDictTags() {
        return this.settings.biomeDictTags;
    }

    @Override
    public float getBiomeWetness() {
        return this.settings.biomeWetness;
    }

    @Override
    public int getCHCSmoothRadius() {
        return this.settings.CHCSmoothRadius;
    }

    @Override
    public int getSkyColor() {
        return this.settings.skyColor;
    }

    @Override
    public int getFogColor() {
        return this.settings.fogColor;
    }

    @Override
    public float getFogDensity() {
        return this.settings.fogDensity;
    }

    @Override
    public int getWaterFogColor() {
        return this.settings.waterFogColor;
    }

    @Override
    public int getFoliageColor() {
        return this.settings.foliageColor;
    }

    @Override
    public ColorSet getFoliageColorControl() {
        return this.settings.foliageColorControl;
    }

    @Override
    public int getGrassColor() {
        return this.settings.grassColor;
    }

    @Override
    public ColorSet getGrassColorControl() {
        return this.settings.grassColorControl;
    }

    @Override
    public SettingsEnums.GrassColorModifier getGrassColorModifier() {
        return this.settings.grassColorModifier;
    }

    @Override
    public int getWaterColor() {
        return this.settings.waterColor;
    }

    @Override
    public ColorSet getWaterColorControl() {
        return this.settings.waterColorControl;
    }

    @Override
    public String getParticleType() {
        return this.settings.particleType;
    }

    @Override
    public float getParticleProbability() {
        return this.settings.particleProbability;
    }

    @Override
    public String getMusic() {
        return this.settings.music;
    }

    @Override
    public int getMusicMinDelay() {
        return this.settings.musicMinDelay;
    }

    @Override
    public int getMusicMaxDelay() {
        return this.settings.musicMaxDelay;
    }

    @Override
    public boolean isReplaceCurrentMusic() {
        return this.settings.replaceCurrentMusic;
    }

    @Override
    public String getAmbientSound() {
        return this.settings.ambientSound;
    }

    @Override
    public String getMoodSound() {
        return this.settings.moodSound;
    }

    @Override
    public int getMoodSoundDelay() {
        return this.settings.moodSoundDelay;
    }

    @Override
    public int getMoodSearchRange() {
        return this.settings.moodSearchRange;
    }

    @Override
    public double getMoodOffset() {
        return this.settings.moodOffset;
    }

    @Override
    public String getAdditionsSound() {
        return this.settings.additionsSound;
    }

    @Override
    public double getAdditionsTickChance() {
        return this.settings.additionsTickChance;
    }

    @Override
    public SettingsEnums.VillageType getVillageType() {
        return this.settings.villageType;
    }

    @Override
    public int getVillageSize() {
        return this.settings.villageSize;
    }

    @Override
    public SettingsEnums.MineshaftType getMineShaftType() {
        return this.settings.mineshaftType;
    }

    @Override
    public float getMineShaftProbability() {
        return this.settings.mineshaftProbability;
    }

    @Override
    public SettingsEnums.OceanRuinsType getOceanRuinsType() {
        return this.settings.oceanRuinsType;
    }

    @Override
    public float getOceanRuinsLargeProbability() {
        return this.settings.oceanRuinsLargeProbability;
    }

    @Override
    public float getOceanRuinsClusterProbability() {
        return this.settings.oceanRuinsClusterProbability;
    }

    @Override
    public boolean getBuriedTreasureEnabled() {
        return this.settings.buriedTreasureEnabled;
    }

    @Override
    public float getBuriedTreasureProbability() {
        return this.settings.buriedTreasureProbability;
    }

    @Override
    public boolean getPillagerOutpostEnabled() {
        return this.settings.pillagerOutpostEnabled;
    }

    @Override
    public int getPillagerOutPostSize() {
        return this.settings.pillagerOutpostSize;
    }

    @Override
    public boolean getBastionRemnantEnabled() {
        return this.settings.bastionRemnantEnabled;
    }

    @Override
    public int getBastionRemnantSize() {
        return this.settings.bastionRemnantSize;
    }

    @Override
    public SettingsEnums.RareBuildingType getRareBuildingType() {
        return this.settings.rareBuildingType;
    }

    @Override
    public SettingsEnums.RuinedPortalType getRuinedPortalType() {
        return this.settings.ruinedPortalType;
    }

    @Override
    public boolean getWoodlandMansionsEnabled() {
        return this.settings.woodLandMansionsEnabled;
    }

    @Override
    public boolean getNetherFortressesEnabled() {
        return this.settings.netherFortressesEnabled;
    }

    @Override
    public boolean getShipWreckEnabled() {
        return this.settings.shipWreckEnabled;
    }

    @Override
    public boolean getShipWreckBeachedEnabled() {
        return this.settings.shipWreckBeachedEnabled;
    }

    @Override
    public boolean getNetherFossilEnabled() {
        return this.settings.netherFossilEnabled;
    }

    @Override
    public boolean getEndCityEnabled() {
        return this.settings.endCityEnabled;
    }

    @Override
    public boolean getStrongholdsEnabled() {
        return this.settings.strongholdsEnabled;
    }

    @Override
    public boolean getOceanMonumentsEnabled() {
        return this.settings.oceanMonumentsEnabled;
    }

    @Override
    public String getInheritMobsBiomeName() {
        return this.settings.inheritMobsBiomeName;
    }

    @Override
    public List<WeightedMobSpawnGroup> getAmbientCreatures() {
        return this.settings.spawnAmbientCreaturesMerged;
    }

    @Override
    public List<WeightedMobSpawnGroup> getCreatures() {
        return this.settings.spawnCreaturesMerged;
    }

    @Override
    public List<WeightedMobSpawnGroup> getMonsters() {
        return this.settings.spawnMonstersMerged;
    }

    @Override
    public List<WeightedMobSpawnGroup> getWaterCreatures() {
        return this.settings.spawnWaterCreaturesMerged;
    }

    @Override
    public List<WeightedMobSpawnGroup> getWaterAmbientCreatures() {
        return this.settings.spawnWaterAmbientCreaturesMerged;
    }

    @Override
    public List<WeightedMobSpawnGroup> getMiscCreatures() {
        return this.settings.spawnMiscCreaturesMerged;
    }

    @Override
    public int getBiomeRarity() {
        return this.settings.biomeRarity;
    }

    @Override
    public int getBiomeSize() {
        return this.settings.biomeSize;
    }

    @Override
    public double getVolatilityWeight1() {
        return this.settings.volatilityWeight1;
    }

    @Override
    public double getVolatilityWeight2() {
        return this.settings.volatilityWeight2;
    }

    @Override
    public double getMaxAverageDepth() {
        return this.settings.maxAverageDepth;
    }

    @Override
    public double getMaxAverageHeight() {
        return this.settings.maxAverageHeight;
    }

    @Override
    public double getCHCData(int y) {
        return this.settings.chcData[y];
    }

    @Override
    public int getSmoothRadius() {
        return this.settings.smoothRadius;
    }

    @Override
    public int getWaterLevelMax() {
        return this.settings.waterLevelMax;
    }

    @Override
    public int getWaterLevelMin() {
        return this.settings.waterLevelMin;
    }

    @Override
    public boolean biomeConfigsHaveReplacement() {
        return this.settings.worldConfig.getBiomeConfigsHaveReplacement();
    }

    @Override
    public double getFractureHorizontal() {
        return this.settings.worldConfig.getFractureHorizontal();
    }

    @Override
    public double getFractureVertical() {
        return this.settings.worldConfig.getFractureVertical();
    }

    @Override
    public boolean isFlatBedrock() {
        return this.settings.worldConfig.getIsFlatBedrock();
    }

    @Override
    public boolean isCeilingBedrock() {
        return this.settings.worldConfig.getIsCeilingBedrock();
    }

    @Override
    public boolean isBedrockDisabled() {
        return this.settings.worldConfig.getBedrockDisabled();
    }

    @Override
    public boolean isRemoveSurfaceStone() {
        return this.settings.worldConfig.getRemoveSurfaceStone();
    }

    @Override
    public boolean disableBiomeHeight() {
        return this.settings.disableBiomeHeight;
    }

    @Override
    public boolean isIsleBiome() {
        return this.settings.isleInBiome != null && this.settings.isleInBiome.size() > 0 && this.settings.worldConfig.getIsleBiomes().contains(this.getName());
    }

    @Override
    public boolean isBorderBiome() {
        return this.settings.biomeIsBorder != null && this.settings.biomeIsBorder.size() > 0 && this.settings.worldConfig.getBorderBiomes().contains(this.getName());
    }

    @Override
    public List<String> getIsleInBiomes() {
        return this.settings.isleInBiome;
    }

    @Override
    public List<String> getBorderInBiomes() {
        return this.settings.biomeIsBorder;
    }

    @Override
    public List<String> getOnlyBorderNearBiomes() {
        return this.settings.onlyBorderNear;
    }

    @Override
    public List<String> getNotBorderNearBiomes() {
        return this.settings.notBorderNear;
    }

    @Override
    public int getBiomeSizeWhenIsle() {
        return this.settings.biomeSizeWhenIsle;
    }

    @Override
    public int getBiomeRarityWhenIsle() {
        return this.settings.biomeRarityWhenIsle;
    }

    @Override
    public int getBiomeSizeWhenBorder() {
        return this.settings.biomeSizeWhenBorder;
    }

    @Override
    public String getRiverBiome() {
        return this.settings.riverBiome;
    }

    @Override
    public int getSnowHeight(float temp) {
        float snowTemp = 0.15f;
        if (temp <= snowTemp) {
            float maxColdTemp = -0.115f;
            float maxThickness = 7.0f;
            if (temp < maxColdTemp) {
                return (int)maxThickness;
            }
            float range = Math.abs(maxColdTemp - snowTemp);
            float fraction = Math.abs(maxColdTemp - temp);
            return (int)Math.floor((1.0f - fraction / range) * maxThickness);
        }
        return 0;
    }

    @Override
    public void doSurfaceAndGroundControl(long worldSeed, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, int x, int z, IBiome biome) {
        this.settings.surfaceAndGroundControl.spawn(worldSeed, generatingChunk, chunkBuffer, biome, x, z);
    }

    @Override
    public ISaplingSpawner getSaplingGen(SaplingType type) {
        SaplingResource gen = this.settings.saplingGrowers.get((Object)type);
        if (gen == null && type.growsTree()) {
            gen = this.settings.saplingGrowers.get((Object)SaplingType.All);
        }
        return gen;
    }

    @Override
    public ISaplingSpawner getCustomSaplingGen(LocalMaterialData materialData, boolean wideTrunk) {
        ISaplingSpawner spawner;
        if (wideTrunk && (spawner = (ISaplingSpawner)this.settings.customBigSaplingGrowers.get(materialData)) != null) {
            return spawner;
        }
        return this.settings.customSaplingGrowers.get(materialData);
    }

    class SettingsContainer {
        protected boolean replacedBlocksInited = false;
        protected IWorldConfig worldConfig;
        protected boolean isTemplateForBiome;
        protected SettingsEnums.TemplateBiomeType templateBiomeType;
        protected String biomeCategory;
        protected List<String> biomeDictTags;
        protected int biomeSize;
        protected int biomeRarity;
        protected int biomeColor;
        protected List<String> isleInBiome;
        protected int biomeSizeWhenIsle;
        protected int biomeRarityWhenIsle;
        protected List<String> biomeIsBorder;
        protected List<String> onlyBorderNear;
        protected List<String> notBorderNear;
        protected int biomeSizeWhenBorder;
        protected float biomeHeight;
        protected float biomeVolatility;
        protected int smoothRadius;
        protected int CHCSmoothRadius;
        protected double maxAverageHeight;
        protected double maxAverageDepth;
        protected double volatility1;
        protected double volatility2;
        protected double volatilityWeight1;
        protected double volatilityWeight2;
        protected boolean disableBiomeHeight;
        protected double[] chcData;
        protected String riverBiome;
        protected LocalMaterialData stoneBlock;
        protected LocalMaterialData surfaceBlock;
        protected LocalMaterialData underWaterSurfaceBlock;
        protected LocalMaterialData groundBlock;
        protected LocalMaterialData sandStoneBlock;
        protected LocalMaterialData redSandStoneBlock;
        protected SurfaceGenerator surfaceAndGroundControl;
        protected ReplaceBlockMatrix replacedBlocks;
        protected boolean useWorldWaterLevel;
        protected int waterLevelMax;
        protected int waterLevelMin;
        protected LocalMaterialData waterBlock;
        protected LocalMaterialData iceBlock;
        protected LocalMaterialData packedIceBlock;
        protected LocalMaterialData snowBlock;
        protected LocalMaterialData cooledLavaBlock;
        protected float biomeTemperature;
        protected boolean useFrozenOceanTemperature;
        protected float biomeWetness;
        protected int grassColor;
        protected ColorSet grassColorControl;
        protected SettingsEnums.GrassColorModifier grassColorModifier;
        protected int foliageColor;
        protected ColorSet foliageColorControl;
        protected int skyColor;
        protected int waterColor;
        protected ColorSet waterColorControl;
        protected int fogColor;
        protected float fogDensity;
        protected int waterFogColor;
        protected String particleType;
        protected float particleProbability;
        protected String music;
        protected int musicMinDelay;
        protected int musicMaxDelay;
        protected boolean replaceCurrentMusic;
        protected String ambientSound;
        protected String moodSound;
        protected int moodSoundDelay;
        protected int moodSearchRange;
        protected double moodOffset;
        protected String additionsSound;
        protected double additionsTickChance;
        protected List<CustomStructureResource> customStructures = new ArrayList<CustomStructureResource>();
        private ICustomStructureGen structureGen;
        protected boolean strongholdsEnabled;
        protected boolean oceanMonumentsEnabled;
        protected boolean woodLandMansionsEnabled;
        protected boolean netherFortressesEnabled;
        protected int villageSize;
        protected SettingsEnums.VillageType villageType;
        protected SettingsEnums.RareBuildingType rareBuildingType;
        protected SettingsEnums.MineshaftType mineshaftType = SettingsEnums.MineshaftType.normal;
        protected boolean buriedTreasureEnabled;
        protected boolean shipWreckEnabled;
        protected boolean shipWreckBeachedEnabled;
        protected boolean pillagerOutpostEnabled;
        protected boolean bastionRemnantEnabled;
        protected boolean netherFossilEnabled;
        protected boolean endCityEnabled;
        protected float mineshaftProbability;
        protected SettingsEnums.RuinedPortalType ruinedPortalType;
        protected SettingsEnums.OceanRuinsType oceanRuinsType;
        protected float oceanRuinsLargeProbability;
        protected float oceanRuinsClusterProbability;
        protected float buriedTreasureProbability;
        protected int pillagerOutpostSize;
        protected int bastionRemnantSize;
        protected List<WeightedMobSpawnGroup> spawnMonstersMerged = new ArrayList<WeightedMobSpawnGroup>();
        protected List<WeightedMobSpawnGroup> spawnCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        protected List<WeightedMobSpawnGroup> spawnWaterCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        protected List<WeightedMobSpawnGroup> spawnAmbientCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        protected List<WeightedMobSpawnGroup> spawnWaterAmbientCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        protected List<WeightedMobSpawnGroup> spawnMiscCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        protected String inheritMobsBiomeName;
        protected List<ConfigFunction<IBiomeConfig>> resourceQueue = new ArrayList<ConfigFunction<IBiomeConfig>>();
        protected Map<SaplingType, SaplingResource> saplingGrowers = new EnumMap<SaplingType, SaplingResource>(SaplingType.class);
        protected Map<LocalMaterialData, SaplingResource> customSaplingGrowers = new HashMap<LocalMaterialData, SaplingResource>();
        protected Map<LocalMaterialData, SaplingResource> customBigSaplingGrowers = new HashMap<LocalMaterialData, SaplingResource>();

        SettingsContainer() {
        }
    }
}

