/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.biome;

import com.pg85.otg.config.io.FileSettingsReader;
import com.pg85.otg.config.io.SettingsMap;
import com.pg85.otg.config.standard.BiomeStandardValues;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.biome.WeightedMobSpawnGroup;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.EntityCategory;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BiomeConfigFinder {
    public Map<String, BiomeConfigStub> findBiomes(List<String> worldBiomes, int worldHeightScale, Collection<Path> directories, ILogger logger, IMaterialReader materialReader) {
        HashMap<String, BiomeConfigStub> biomeConfigsStore = new HashMap<String, BiomeConfigStub>();
        for (Path directoryPath : directories) {
            File directory = directoryPath.toFile();
            if (!directory.exists()) continue;
            this.loadBiomesFromDirectory(worldBiomes, worldHeightScale, biomeConfigsStore, directory, logger, materialReader);
        }
        return biomeConfigsStore;
    }

    private void loadBiomesFromDirectory(List<String> worldBiomes, int worldHeightScale, Map<String, BiomeConfigStub> biomeConfigsStore, File directory, ILogger logger, IMaterialReader materialReader) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.loadBiomesFromDirectory(worldBiomes, worldHeightScale, biomeConfigsStore, file, logger, materialReader);
                continue;
            }
            String biomeName = this.toBiomeName(file);
            if (biomeName == null) continue;
            File renamedFile = this.renameBiomeFile(file, biomeName, logger);
            SettingsMap settings = FileSettingsReader.read(biomeName, renamedFile, logger);
            BiomeConfigStub biomeConfigStub = new BiomeConfigStub(settings, file.toPath(), biomeName, logger, materialReader);
            biomeConfigsStore.put(biomeName, biomeConfigStub);
        }
    }

    private File renameBiomeFile(File toRename, String biomeName, ILogger logger) {
        String preferredFileName = this.toFileName(biomeName);
        if (toRename.getName().equalsIgnoreCase(preferredFileName)) {
            return toRename;
        }
        File newFile = new File(toRename.getParentFile(), preferredFileName);
        if (toRename.renameTo(newFile)) {
            return newFile;
        }
        if (logger.getLogCategoryEnabled(LogCategory.CONFIGS)) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Failed to rename biome file {0} to {1}", toRename.getAbsolutePath(), newFile.getAbsolutePath()));
        }
        return toRename;
    }

    private String toBiomeName(File file) {
        String fileName = file.getName();
        for (String extension : BiomeStandardValues.BiomeConfigExtensions) {
            if (!fileName.endsWith(extension)) continue;
            String biomeName = fileName.substring(0, fileName.lastIndexOf(extension));
            return biomeName;
        }
        return null;
    }

    private String toFileName(String biomeName) {
        return biomeName + ".bc";
    }

    public final class BiomeConfigStub {
        private final SettingsMap settings;
        private final Path file;
        private final String biomeName;
        public boolean inheritMobsBiomeNameProcessed = false;
        private List<WeightedMobSpawnGroup> spawnMonsters = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnCreatures = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnWaterCreatures = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnWaterAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnMiscCreatures = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnMonstersMerged = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnWaterCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnAmbientCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnWaterAmbientCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();
        private List<WeightedMobSpawnGroup> spawnMiscCreaturesMerged = new ArrayList<WeightedMobSpawnGroup>();

        private BiomeConfigStub(SettingsMap settings, Path file, String biomeName, ILogger logger, IMaterialReader materialReader) {
            this.settings = settings;
            this.file = file;
            this.biomeName = biomeName;
            if (settings.hasSetting(BiomeStandardValues.SPAWN_MONSTERS)) {
                this.spawnMonsters = settings.getSetting(BiomeStandardValues.SPAWN_MONSTERS, null, logger, materialReader);
                if (this.spawnMonsters == null) {
                    this.spawnMonsters = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnMonsters = BiomeStandardValues.SPAWN_MONSTERS.getDefaultValue();
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_CREATURES)) {
                this.spawnCreatures = settings.getSetting(BiomeStandardValues.SPAWN_CREATURES, new ArrayList(), logger, materialReader);
                if (this.spawnCreatures == null) {
                    this.spawnCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnCreatures = BiomeStandardValues.SPAWN_CREATURES.getDefaultValue();
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_WATER_CREATURES)) {
                this.spawnWaterCreatures = settings.getSetting(BiomeStandardValues.SPAWN_WATER_CREATURES, new ArrayList(), logger, materialReader);
                if (this.spawnWaterCreatures == null) {
                    this.spawnWaterCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnWaterCreatures = BiomeStandardValues.SPAWN_WATER_CREATURES.getDefaultValue();
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_AMBIENT_CREATURES)) {
                this.spawnAmbientCreatures = settings.getSetting(BiomeStandardValues.SPAWN_AMBIENT_CREATURES, new ArrayList(), logger, materialReader);
                if (this.spawnAmbientCreatures == null) {
                    this.spawnAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnAmbientCreatures = BiomeStandardValues.SPAWN_AMBIENT_CREATURES.getDefaultValue();
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_WATER_AMBIENT_CREATURES)) {
                this.spawnWaterAmbientCreatures = settings.getSetting(BiomeStandardValues.SPAWN_WATER_AMBIENT_CREATURES, new ArrayList(), logger, materialReader);
                if (this.spawnWaterAmbientCreatures == null) {
                    this.spawnWaterAmbientCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnWaterAmbientCreatures = BiomeStandardValues.SPAWN_WATER_AMBIENT_CREATURES.getDefaultValue();
            }
            if (settings.hasSetting(BiomeStandardValues.SPAWN_MISC_CREATURES)) {
                this.spawnMiscCreatures = settings.getSetting(BiomeStandardValues.SPAWN_MISC_CREATURES, new ArrayList(), logger, materialReader);
                if (this.spawnMiscCreatures == null) {
                    this.spawnMiscCreatures = new ArrayList<WeightedMobSpawnGroup>();
                }
            } else {
                this.spawnMiscCreatures = BiomeStandardValues.SPAWN_MISC_CREATURES.getDefaultValue();
            }
            this.spawnMonstersMerged.addAll(this.spawnMonsters);
            this.spawnCreaturesMerged.addAll(this.spawnCreatures);
            this.spawnWaterCreaturesMerged.addAll(this.spawnWaterCreatures);
            this.spawnAmbientCreaturesMerged.addAll(this.spawnAmbientCreatures);
            this.spawnWaterAmbientCreaturesMerged.addAll(this.spawnWaterAmbientCreatures);
            this.spawnMiscCreaturesMerged.addAll(this.spawnMiscCreatures);
        }

        public void mergeMobs(BiomeConfigStub parent) {
            this.mergeMobs(parent.spawnMonstersMerged, EntityCategory.MONSTER);
            this.mergeMobs(parent.spawnCreaturesMerged, EntityCategory.CREATURE);
            this.mergeMobs(parent.spawnAmbientCreaturesMerged, EntityCategory.AMBIENT_CREATURE);
            this.mergeMobs(parent.spawnWaterCreaturesMerged, EntityCategory.WATER_CREATURE);
            this.mergeMobs(parent.spawnWaterAmbientCreaturesMerged, EntityCategory.WATER_AMBIENT);
            this.mergeMobs(parent.spawnMiscCreaturesMerged, EntityCategory.MISC);
            this.inheritMobsBiomeNameProcessed = true;
        }

        public void mergeMobs(List<WeightedMobSpawnGroup> parentSpawnableMonsterList, EntityCategory entityCategory) {
            List<WeightedMobSpawnGroup> childSpawnableMonsterList = null;
            switch (entityCategory) {
                case MONSTER: {
                    childSpawnableMonsterList = this.spawnMonstersMerged;
                    break;
                }
                case CREATURE: {
                    childSpawnableMonsterList = this.spawnCreaturesMerged;
                    break;
                }
                case AMBIENT_CREATURE: {
                    childSpawnableMonsterList = this.spawnAmbientCreaturesMerged;
                    break;
                }
                case WATER_CREATURE: {
                    childSpawnableMonsterList = this.spawnWaterCreaturesMerged;
                    break;
                }
                case WATER_AMBIENT: {
                    childSpawnableMonsterList = this.spawnWaterAmbientCreaturesMerged;
                    break;
                }
                case MISC: {
                    childSpawnableMonsterList = this.spawnMiscCreaturesMerged;
                }
            }
            ArrayList<WeightedMobSpawnGroup> newSpawnableMobsList = new ArrayList<WeightedMobSpawnGroup>();
            newSpawnableMobsList.addAll(childSpawnableMonsterList);
            if (parentSpawnableMonsterList != null) {
                for (WeightedMobSpawnGroup weightedMobSpawnGroupParent : parentSpawnableMonsterList) {
                    boolean bFound = false;
                    for (WeightedMobSpawnGroup weightedMobSpawnGroupChild : childSpawnableMonsterList) {
                        String compareFrom = weightedMobSpawnGroupChild.getMob().toLowerCase().trim();
                        String compareTo = weightedMobSpawnGroupParent.getMob().toLowerCase().trim();
                        if (compareFrom.startsWith("minecraft:")) {
                            if (!compareTo.contains(":")) {
                                compareFrom = compareFrom.replace("minecraft:", "");
                            }
                        } else if (compareTo.startsWith("minecraft:")) {
                            compareTo = compareTo.replace("minecraft:", "");
                        }
                        if (!compareFrom.equals(compareTo)) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    newSpawnableMobsList.add(weightedMobSpawnGroupParent);
                }
            }
            switch (entityCategory) {
                case MONSTER: {
                    this.spawnMonstersMerged = newSpawnableMobsList;
                    break;
                }
                case CREATURE: {
                    this.spawnCreaturesMerged = newSpawnableMobsList;
                    break;
                }
                case AMBIENT_CREATURE: {
                    this.spawnAmbientCreaturesMerged = newSpawnableMobsList;
                    break;
                }
                case WATER_CREATURE: {
                    this.spawnWaterCreaturesMerged = newSpawnableMobsList;
                    break;
                }
                case WATER_AMBIENT: {
                    this.spawnWaterAmbientCreaturesMerged = newSpawnableMobsList;
                    break;
                }
                case MISC: {
                    this.spawnMiscCreaturesMerged = newSpawnableMobsList;
                    break;
                }
            }
        }

        public Path getPath() {
            return this.file;
        }

        public SettingsMap getSettings() {
            return this.settings;
        }

        public String getBiomeName() {
            return this.biomeName;
        }

        public Collection<? extends WeightedMobSpawnGroup> getSpawner(EntityCategory entityCategory) {
            switch (entityCategory) {
                case MONSTER: {
                    return this.spawnMonsters;
                }
                case CREATURE: {
                    return this.spawnCreatures;
                }
                case AMBIENT_CREATURE: {
                    return this.spawnAmbientCreatures;
                }
                case WATER_CREATURE: {
                    return this.spawnWaterCreatures;
                }
                case WATER_AMBIENT: {
                    return this.spawnWaterAmbientCreatures;
                }
                case MISC: {
                    return this.spawnMiscCreatures;
                }
            }
            return null;
        }

        public Collection<? extends WeightedMobSpawnGroup> getSpawnerMerged(EntityCategory entityCategory) {
            switch (entityCategory) {
                case MONSTER: {
                    return this.spawnMonstersMerged;
                }
                case CREATURE: {
                    return this.spawnCreaturesMerged;
                }
                case AMBIENT_CREATURE: {
                    return this.spawnAmbientCreaturesMerged;
                }
                case WATER_CREATURE: {
                    return this.spawnWaterCreaturesMerged;
                }
                case WATER_AMBIENT: {
                    return this.spawnWaterAmbientCreaturesMerged;
                }
                case MISC: {
                    return this.spawnMiscCreaturesMerged;
                }
            }
            return null;
        }
    }
}

