/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.biome;

import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.BiomeRegistryNames;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BiomeGroup
extends ConfigFunction<IWorldConfig> {
    private int groupId;
    private String name;
    private int groupRarity;
    private int generationDepth = 0;
    private double minTemp = 0.0;
    private double maxTemp = 0.0;
    private final List<String> biomes = new ArrayList<String>();

    public BiomeGroup(IWorldConfig config, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(4, args);
        this.name = args.get(0);
        this.generationDepth = this.readInt(args.get(1), 0, config.getGenerationDepth());
        this.groupRarity = this.readInt(args.get(2), 1, Integer.MAX_VALUE);
        try {
            this.minTemp = this.readDouble(args.get(args.size() - 2), -2.147483648E9, 2.147483647E9);
            this.maxTemp = this.readDouble(args.get(args.size() - 1), -2.147483648E9, 2.147483647E9);
            args = args.subList(0, args.size() - 2);
        }
        catch (InvalidConfigException ex) {
            this.minTemp = 0.0;
            this.maxTemp = 0.0;
        }
        for (String biome : this.readBiomes(args, 3)) {
            this.biomes.add(biome);
        }
    }

    public BiomeGroup(IWorldConfig config, String groupName, int size, int rarity, List<String> biomes) {
        this.name = groupName;
        this.generationDepth = size;
        this.groupRarity = rarity;
        this.minTemp = 0.0;
        this.maxTemp = 0.0;
        for (String biome : biomes) {
            this.biomes.add(biome);
        }
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public boolean temperatureAllowed(float baseTemperature) {
        if (this.minTemp != 0.0 || this.maxTemp != 0.0) {
            return Math.floor(baseTemperature * 100.0f) >= Math.floor(this.minTemp * 100.0) && Math.floor(baseTemperature * 100.0f) <= Math.floor(this.maxTemp * 100.0);
        }
        return true;
    }

    @Override
    public String toString() {
        return "BiomeGroup(" + this.name + ", " + this.generationDepth + ", " + this.groupRarity + ", " + StringHelper.join(this.biomes, ", ") + (this.minTemp == 0.0 ? "" : ", " + this.minTemp) + (this.maxTemp == 0.0 ? "" : ", " + this.maxTemp) + ")";
    }

    private List<String> readBiomes(List<String> strings, int start) throws InvalidConfigException {
        return new ArrayList<String>(strings.subList(start, strings.size()));
    }

    public String getName() {
        return this.name;
    }

    void filterBiomes(ArrayList<String> customBiomeNames, ILogger logger) {
        Iterator<String> it = this.biomes.iterator();
        while (it.hasNext()) {
            String biomeName = it.next();
            if (biomeName != null && biomeName.trim().length() > 0) {
                if (BiomeRegistryNames.Contain(biomeName) || customBiomeNames.contains(biomeName) || biomeName.contains(":") || biomeName.toLowerCase().startsWith("mod.") || biomeName.toLowerCase().startsWith("category.") || biomeName.toLowerCase().startsWith("modcategory.") || biomeName.toLowerCase().startsWith("mccategory.") || biomeName.toLowerCase().startsWith("tag.") || biomeName.toLowerCase().startsWith("modtag.") || biomeName.toLowerCase().startsWith("mctag.")) continue;
                if (logger.getLogCategoryEnabled(LogCategory.CONFIGS)) {
                    logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Invalid biome name {0} in biome group {1}", biomeName, this.name));
                }
            }
            it.remove();
        }
    }

    public boolean containsBiome(String name) {
        return this.biomes.contains(name);
    }

    void setGroupId(int groupId) {
        if (groupId > 127) {
            throw new IllegalArgumentException("Tried to set group id to " + groupId + ", max allowed is " + 127);
        }
        this.groupId = groupId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getGroupRarity() {
        return this.groupRarity;
    }

    public int getGenerationDepth() {
        return this.generationDepth;
    }

    boolean hasNoBiomes() {
        return this.biomes.isEmpty();
    }
}

