/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.biome;

import com.pg85.otg.config.biome.BiomeGroup;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BiomeGroupManager {
    static final int MAX_BIOME_GROUP_COUNT = 127;
    private int cumulativeGroupRarity = 0;
    private Map<String, BiomeGroup> nameToGroup = new LinkedHashMap<String, BiomeGroup>(4);
    private Map<Integer, BiomeGroup> idToGroup = new LinkedHashMap<Integer, BiomeGroup>(4);
    private HashMap<Integer, TreeMap<Integer, BiomeGroup>> cachedGroupDepthMaps = new HashMap();

    public void registerGroup(BiomeGroup newGroup, ILogger logger) {
        if (this.isRoomForMoreGroups()) {
            BiomeGroup existingWithSameName = this.nameToGroup.get(newGroup.getName());
            if (existingWithSameName != null) {
                if (logger.getLogCategoryEnabled(LogCategory.CONFIGS)) {
                    logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Two biome groups have the same name \"{0}\". Removing the second one.", newGroup.getName()));
                }
            } else {
                int newGroupId = this.getNextGroupId();
                newGroup.setGroupId(newGroupId);
                this.nameToGroup.put(newGroup.getName(), newGroup);
                this.idToGroup.put(newGroupId, newGroup);
            }
        } else if (logger.getLogCategoryEnabled(LogCategory.CONFIGS)) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Biome group \"{0}\" could not be added. Max biome group count reached.", newGroup.getName()));
        }
    }

    private int getNextGroupId() {
        return this.getGroupCount() + 1;
    }

    private boolean isRoomForMoreGroups() {
        return this.getNextGroupId() < 127;
    }

    public BiomeGroup getGroupById(int groupId) {
        return this.idToGroup.get(groupId);
    }

    public BiomeGroup getGroupByName(String name) {
        return this.nameToGroup.get(name);
    }

    public Collection<BiomeGroup> getGroups() {
        return this.idToGroup.values();
    }

    public int getGroupCount() {
        return this.idToGroup.size();
    }

    public SortedMap<Integer, BiomeGroup> getGroupDepthMap(int depth) {
        TreeMap<Integer, BiomeGroup> map = this.cachedGroupDepthMaps.get(new Integer(depth));
        if (map != null) {
            return map;
        }
        map = new TreeMap();
        this.cumulativeGroupRarity = 0;
        for (BiomeGroup group : this.getGroups()) {
            if (group.getGenerationDepth() != depth) continue;
            this.cumulativeGroupRarity += group.getGroupRarity();
            map.put(this.cumulativeGroupRarity, group);
        }
        if (this.cumulativeGroupRarity < map.size() * 100) {
            map.put(map.size() * 100, null);
        }
        this.cachedGroupDepthMaps.put(new Integer(depth), map);
        return map;
    }

    public boolean isGroupDepthMapEmpty(int depth) {
        for (BiomeGroup group : this.getGroups()) {
            if (group.getGenerationDepth() != depth) continue;
            return false;
        }
        return true;
    }

    public static int getMaxRarityFromPossibles(Map<Integer, ?> map) {
        Integer[] totalRarity = map.keySet().toArray(new Integer[map.size()]);
        return totalRarity[totalRarity.length - 1];
    }

    public void filterBiomes(ArrayList<String> customBiomeNames, ILogger logger) {
        Iterator<BiomeGroup> it = this.idToGroup.values().iterator();
        while (it.hasNext()) {
            BiomeGroup group = it.next();
            group.filterBiomes(customBiomeNames, logger);
            if (!group.hasNoBiomes()) continue;
            it.remove();
        }
    }
}

