/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.biome;

import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.config.ErroredFunction;
import com.pg85.otg.config.io.IConfigFunctionProvider;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BiomeResourcesManager
implements IConfigFunctionProvider {
    private Map<String, Class<? extends ConfigFunction<?>>> configFunctions = new HashMap();

    public BiomeResourcesManager(Map<String, Class<? extends ConfigFunction<?>>> configFunctions) {
        for (Map.Entry<String, Class<ConfigFunction<?>>> resource : configFunctions.entrySet()) {
            this.registerConfigFunction(resource.getKey(), resource.getValue());
        }
    }

    private void registerConfigFunction(String name, Class<? extends ConfigFunction<?>> value) {
        this.configFunctions.put(name.toLowerCase(), value);
    }

    @Override
    public <T> ConfigFunction<T> getConfigFunction(String name, T holder, List<String> args, ILogger logger, IMaterialReader materialReader) {
        Class<ConfigFunction<?>> clazz = this.configFunctions.get(name.toLowerCase());
        if (clazz == null) {
            return new ErroredFunction(name, args, "Resource type " + name + " not found");
        }
        try {
            Constructor<ConfigFunction<?>> constructor = null;
            if (holder instanceof IBiomeConfig) {
                constructor = clazz.getConstructor(IBiomeConfig.class, List.class, ILogger.class, IMaterialReader.class);
            } else if (holder instanceof IWorldConfig) {
                constructor = clazz.getConstructor(IWorldConfig.class, List.class, ILogger.class, IMaterialReader.class);
            }
            return constructor.newInstance(holder, args, logger, materialReader);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            return new ErroredFunction(name, args, "Resource type " + name + " had invalid parameters and could not be parsed, error: " + cause);
        }
    }
}

