/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.biome;

import com.pg85.otg.config.ConfigFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldConfig;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.BiomeRegistryNames;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class TemplateBiome
extends ConfigFunction<IWorldConfig> {
    private String name;
    private double minTemp;
    private double maxTemp;
    private final List<String> tags = new ArrayList<String>();

    public TemplateBiome(IWorldConfig config, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(2, args);
        this.name = args.get(0);
        try {
            this.minTemp = this.readDouble(args.get(args.size() - 2), -2.147483648E9, 2.147483647E9);
            this.maxTemp = this.readDouble(args.get(args.size() - 1), -2.147483648E9, 2.147483647E9);
            args = args.subList(0, args.size() - 2);
        }
        catch (InvalidConfigException ex) {
            this.minTemp = 0.0;
            this.maxTemp = 0.0;
        }
        for (String biome : this.readTags(args, 1)) {
            this.tags.add(biome);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean temperatureAllowed(float baseTemperature) {
        if (this.minTemp != 0.0 || this.maxTemp != 0.0) {
            return Math.floor(baseTemperature * 100.0f) >= Math.floor(this.minTemp * 100.0) && Math.floor(baseTemperature * 100.0f) <= Math.floor(this.maxTemp * 100.0);
        }
        return true;
    }

    @Override
    public String toString() {
        return "TemplateBiome(" + this.name + ", " + StringHelper.join(this.tags, ", ") + (this.minTemp == 0.0 ? "" : ", " + this.minTemp) + (this.maxTemp == 0.0 ? "" : ", " + this.maxTemp) + ")";
    }

    private List<String> readTags(List<String> strings, int start) throws InvalidConfigException {
        return new ArrayList<String>(strings.subList(start, strings.size()));
    }

    public String getName() {
        return this.name;
    }

    void filterBiomes(ArrayList<String> customBiomeNames, ILogger logger) {
        Iterator<String> it = this.tags.iterator();
        while (it.hasNext()) {
            String biomeName = it.next();
            if (biomeName != null && biomeName.trim().length() > 0) {
                if (BiomeRegistryNames.Contain(biomeName) || customBiomeNames.contains(biomeName) || biomeName.contains(":") || biomeName.toLowerCase().startsWith("mod.") || biomeName.toLowerCase().startsWith("category.") || biomeName.toLowerCase().startsWith("modcategory.") || biomeName.toLowerCase().startsWith("mccategory.") || biomeName.toLowerCase().startsWith("tag.") || biomeName.toLowerCase().startsWith("modtag.") || biomeName.toLowerCase().startsWith("mctag.")) continue;
                if (logger.getLogCategoryEnabled(LogCategory.CONFIGS)) {
                    logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Invalid tag name {0} in TemplateBiome() {1}", biomeName, this.name));
                }
            }
            it.remove();
        }
    }
}

