/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.io;

import com.pg85.otg.config.io.RawSettingValue;
import com.pg85.otg.config.io.SettingsMap;
import com.pg85.otg.config.io.SimpleSettingsMap;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FileSettingsReader {
    public static SettingsMap read(String configName, File file, ILogger logger) {
        SimpleSettingsMap settingsMap = new SimpleSettingsMap(configName);
        new FileSettingsReader().readIntoMap(settingsMap, file, logger);
        return settingsMap;
    }

    private void readIntoMap(SettingsMap settings, BufferedReader fileContents) throws IOException {
        String thisLine;
        int lineNumber = 0;
        while ((thisLine = fileContents.readLine()) != null) {
            ++lineNumber;
            if (thisLine.trim().isEmpty() || thisLine.startsWith("#") || thisLine.startsWith("<")) continue;
            if (thisLine.contains(":") || thisLine.toLowerCase().contains("(")) {
                if (thisLine.contains("(") && (!thisLine.contains(":") || thisLine.indexOf(40) < thisLine.indexOf(58))) {
                    String configFunction = thisLine.trim();
                    settings.addRawSetting(RawSettingValue.create(RawSettingValue.ValueType.FUNCTION, configFunction).withLineNumber(lineNumber));
                    continue;
                }
                settings.addRawSetting(RawSettingValue.create(RawSettingValue.ValueType.PLAIN_SETTING, thisLine.trim()).withLineNumber(lineNumber));
                continue;
            }
            if (!thisLine.contains("=")) continue;
            String modifiedLine = thisLine.replaceFirst("=", ":").trim();
            settings.addRawSetting(RawSettingValue.create(RawSettingValue.ValueType.PLAIN_SETTING, modifiedLine).withLineNumber(lineNumber));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIntoMap(SettingsMap settings, File file, ILogger logger) {
        BufferedReader settingsReader = null;
        if (!file.exists()) {
            return;
        }
        try {
            settingsReader = new BufferedReader(new FileReader(file));
            this.readIntoMap(settings, settingsReader);
        }
        catch (IOException e) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, String.format("Could not read file, exception: ", e.getStackTrace()));
        }
        finally {
            if (settingsReader != null) {
                try {
                    settingsReader.close();
                }
                catch (IOException localIOException2) {
                    logger.log(LogLevel.ERROR, LogCategory.CONFIGS, String.format("Could not close file, exception: ", localIOException2.getStackTrace()));
                }
            }
        }
    }
}

