/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;

class BooleanSetting
extends Setting<Boolean> {
    private final boolean defaultValue;

    BooleanSetting(String name, boolean defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public Boolean getDefaultValue(IMaterialReader materialReader) {
        return this.defaultValue;
    }

    @Override
    public Boolean read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new InvalidConfigException(string + " is not a boolean");
    }
}

