/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;

class ColorSetting
extends Setting<Integer> {
    private int defaultValue;

    ColorSetting(String name, String defaultValue) {
        super(name);
        this.defaultValue = Integer.decode(defaultValue);
    }

    @Override
    public Integer getDefaultValue(IMaterialReader materialReader) {
        return this.defaultValue;
    }

    @Override
    public Integer read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        try {
            Integer integer = Integer.decode(string);
            if (integer > 0xFFFFFF || integer < 0) {
                throw new InvalidConfigException("Color must have 6 hexadecimal digits");
            }
            return integer;
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Invalid color " + string);
        }
    }

    @Override
    public String write(Integer value) {
        return "#" + Integer.toHexString(value | 0x1000000).substring(1).toUpperCase();
    }
}

