/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;

public class DoubleArraySetting
extends Setting<double[]> {
    public DoubleArraySetting(String name) {
        super(name);
    }

    @Override
    public double[] getDefaultValue(IMaterialReader materialReader) {
        return new double[0];
    }

    @Override
    public double[] read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        if (string.isEmpty()) {
            return new double[0];
        }
        String[] split = StringHelper.readCommaSeperatedString(string);
        double[] values = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            values[i] = StringHelper.readDouble(split[i], -1.7976931348623157E308, Double.MAX_VALUE);
        }
        return values;
    }

    @Override
    public String write(double[] values) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(values[i]);
        }
        return builder.toString();
    }
}

