/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;

class DoubleSetting
extends Setting<Double> {
    private final double defaultValue;
    private final double minValue;
    private final double maxValue;

    DoubleSetting(String name, double defaultValue, double minValue, double maxValue) {
        super(name);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Double getDefaultValue(IMaterialReader materialReader) {
        return this.defaultValue;
    }

    @Override
    public Double read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        return StringHelper.readDouble(string, this.minValue, this.maxValue);
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }
}

