/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;

class EnumSetting<T extends Enum<T>>
extends Setting<T> {
    private final T defaultValue;
    private final T[] enumValues;

    public EnumSetting(String name, T defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
        this.enumValues = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
    }

    @Override
    public T getDefaultValue(IMaterialReader materialReader) {
        return this.defaultValue;
    }

    @Override
    public T read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        for (T enumValue : this.enumValues) {
            if (!((Enum)enumValue).name().equalsIgnoreCase(string)) continue;
            return enumValue;
        }
        throw new InvalidConfigException(string + " is not an acceptable value");
    }
}

