/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.util.ArrayList;

public class MaterialListSetting
extends Setting<ArrayList<LocalMaterialData>> {
    private final String[] defaultValue;
    private boolean processedMaterials;
    private ArrayList<LocalMaterialData> defaultMaterials;

    public MaterialListSetting(String name, String[] defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public ArrayList<LocalMaterialData> getDefaultValue(IMaterialReader materialReader) {
        if (!this.processedMaterials) {
            this.processedMaterials = true;
            ArrayList<LocalMaterialData> materials = new ArrayList<LocalMaterialData>();
            for (String defaultMaterial : this.defaultValue) {
                LocalMaterialData material = null;
                try {
                    material = materialReader.readMaterial(defaultMaterial);
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
                if (material == null) continue;
                materials.add(material);
            }
            this.defaultMaterials = materials;
        }
        return this.defaultMaterials;
    }

    @Override
    public ArrayList<LocalMaterialData> read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        String[] materialNames = string.split(",(?![^\\(\\[]*[\\]\\)])");
        ArrayList<LocalMaterialData> materials = new ArrayList<LocalMaterialData>();
        for (String materialName : materialNames) {
            LocalMaterialData material = materialReader.readMaterial(materialName.trim());
            materials.add(material);
        }
        return materials;
    }

    @Override
    public String write(ArrayList<LocalMaterialData> value) {
        return StringHelper.join(value, ", ");
    }
}

