/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.MaterialSet;

class MaterialSetSetting
extends Setting<MaterialSet> {
    private final String[] defaultValues;

    public MaterialSetSetting(String name, String ... defaultValues) {
        super(name);
        this.defaultValues = defaultValues;
    }

    @Override
    public MaterialSet getDefaultValue(IMaterialReader materialReader) {
        try {
            MaterialSet blocks = new MaterialSet();
            for (String blockName : this.defaultValues) {
                blocks.parseAndAdd(blockName, materialReader);
            }
            return blocks;
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public MaterialSet read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        MaterialSet blocks = new MaterialSet();
        for (String blockName : StringHelper.readCommaSeperatedString(string)) {
            blocks.parseAndAdd(blockName, materialReader);
        }
        return blocks;
    }
}

