/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.settingType;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.materials.LocalMaterialData;

public class MaterialSetting
extends Setting<LocalMaterialData> {
    private final String defaultValue;
    private boolean processedMaterial = false;
    private LocalMaterialData defaultMaterial;

    public MaterialSetting(String name, String defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
    }

    @Override
    public LocalMaterialData getDefaultValue(IMaterialReader materialReader) {
        if (!this.processedMaterial) {
            this.processedMaterial = true;
            try {
                this.defaultMaterial = materialReader.readMaterial(this.defaultValue);
            }
            catch (InvalidConfigException e) {
                e.printStackTrace();
            }
        }
        return this.defaultMaterial;
    }

    @Override
    public LocalMaterialData read(String string, IMaterialReader materialReader) throws InvalidConfigException {
        return materialReader.readMaterial(string);
    }
}

