/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.config.standard;

import com.pg85.otg.config.settingType.DoubleArraySetting;
import com.pg85.otg.config.settingType.MaterialSetting;
import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.config.settingType.Settings;
import com.pg85.otg.config.standard.WorldStandardValues;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.util.biome.ColorSet;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.biome.WeightedMobSpawnGroup;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BiomeStandardValues
extends Settings {
    public static final Collection<String> BiomeConfigExtensions = Arrays.asList("BiomeConfig.ini", ".biome", ".bc", ".bc.ini", ".biome.ini");
    public static final Setting<Boolean> USE_WORLD_WATER_LEVEL = BiomeStandardValues.booleanSetting("UseWorldWaterLevel", true);
    public static final Setting<Boolean> DISABLE_BIOME_HEIGHT = BiomeStandardValues.booleanSetting("DisableBiomeHeight", false);
    public static final Setting<Boolean> STRONGHOLDS_ENABLED = BiomeStandardValues.booleanSetting("StrongholdsEnabled", true);
    public static final Setting<Boolean> NETHER_FORTRESSES_ENABLED = BiomeStandardValues.booleanSetting("NetherFortressesEnabled", false);
    public static final Setting<Boolean> OCEAN_MONUMENTS_ENABLED = BiomeStandardValues.booleanSetting("OceanMonumentsEnabled", false);
    public static final Setting<Boolean> WOODLAND_MANSIONS_ENABLED = BiomeStandardValues.booleanSetting("WoodlandMansionsEnabled", false);
    public static final Setting<Boolean> BURIED_TREASURE_ENABLED = BiomeStandardValues.booleanSetting("BuriedTreasureEnabled", false);
    public static final Setting<Boolean> SHIP_WRECK_ENABLED = BiomeStandardValues.booleanSetting("ShipWreckEnabled", false);
    public static final Setting<Boolean> SHIP_WRECK_BEACHED_ENABLED = BiomeStandardValues.booleanSetting("ShipWreckBeachedEnabled", false);
    public static final Setting<Boolean> PILLAGER_OUTPOST_ENABLED = BiomeStandardValues.booleanSetting("PillagerOutpostEnabled", false);
    public static final Setting<Boolean> BASTION_REMNANT_ENABLED = BiomeStandardValues.booleanSetting("BastionRemnantEnabled", false);
    public static final Setting<Boolean> NETHER_FOSSIL_ENABLED = BiomeStandardValues.booleanSetting("NetherFossilEnabled", false);
    public static final Setting<Boolean> END_CITY_ENABLED = BiomeStandardValues.booleanSetting("EndCityEnabled", false);
    public static final Setting<Boolean> REPLACE_CURRENT_MUSIC = BiomeStandardValues.booleanSetting("ReplaceCurrentMusic", false);
    public static final Setting<Boolean> USE_FROZEN_OCEAN_TEMPERATURE = BiomeStandardValues.booleanSetting("UseFrozenOceanTemperature", false);
    public static final Setting<Boolean> TEMPLATE_FOR_BIOME = BiomeStandardValues.booleanSetting("TemplateForBiome", false);
    public static final Setting<String> RIVER_BIOME = BiomeStandardValues.stringSetting("RiverBiome", "River");
    public static final Setting<String> INHERIT_MOBS_BIOME_NAME = BiomeStandardValues.stringSetting("InheritMobsBiomeName", "");
    public static final Setting<String> PARTICLE_TYPE = BiomeStandardValues.stringSetting("ParticleType", "");
    public static final Setting<String> MUSIC = BiomeStandardValues.stringSetting("Music", "");
    public static final Setting<String> AMBIENT_SOUND = BiomeStandardValues.stringSetting("AmbientSound", "");
    public static final Setting<String> MOOD_SOUND = BiomeStandardValues.stringSetting("MoodSound", "minecraft:ambient.cave");
    public static final Setting<String> ADDITIONS_SOUND = BiomeStandardValues.stringSetting("AdditionsSound", "");
    public static final Setting<String> BIOME_CATEGORY = BiomeStandardValues.stringSetting("BiomeCategory", "plains");
    public static final Setting<String> LEGACY_GRASS_COLOR2 = BiomeStandardValues.stringSetting("GrassColor2", "#FFFFFF");
    public static final Setting<String> LEGACY_FOLIAGE_COLOR2 = BiomeStandardValues.stringSetting("FoliageColor2", "#FFFFFF");
    public static final Setting<Integer> BIOME_SIZE = BiomeStandardValues.intSetting("BiomeSize", 4, 0, 20);
    public static final Setting<Integer> BIOME_SIZE_WHEN_ISLE = BiomeStandardValues.intSetting("BiomeSizeWhenIsle", 6, 0, 20);
    public static final Setting<Integer> BIOME_SIZE_WHEN_BORDER = BiomeStandardValues.intSetting("BiomeSizeWhenBorder", 8, 0, 20);
    public static final Setting<Integer> BIOME_RARITY = BiomeStandardValues.intSetting("BiomeRarity", 100, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> BIOME_RARITY_WHEN_ISLE = BiomeStandardValues.intSetting("BiomeRarityWhenIsle", 97, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> SMOOTH_RADIUS = BiomeStandardValues.intSetting("SmoothRadius", 2, 0, 32);
    public static final Setting<Integer> CUSTOM_HEIGHT_CONTROL_SMOOTH_RADIUS = BiomeStandardValues.intSetting("CustomHeightControlSmoothRadius", 2, 0, 32);
    public static final Setting<Integer> WATER_LEVEL_MAX = WorldStandardValues.WATER_LEVEL_MAX;
    public static final Setting<Integer> WATER_LEVEL_MIN = WorldStandardValues.WATER_LEVEL_MIN;
    public static final Setting<Integer> VILLAGE_SIZE = BiomeStandardValues.intSetting("VillageSize", 6, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> PILLAGER_OUTPOST_SIZE = BiomeStandardValues.intSetting("PillagerOutpostSize", 7, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> BASTION_REMNANT_SIZE = BiomeStandardValues.intSetting("BastionRemnantSize", 6, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> MUSIC_MIN_DELAY = BiomeStandardValues.intSetting("MusicMinDelay", 0, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> MUSIC_MAX_DELAY = BiomeStandardValues.intSetting("MusicMaxDelay", 0, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> MOOD_SOUND_DELAY = BiomeStandardValues.intSetting("MoodSoundDelay", 6000, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> MOOD_SEARCH_RANGE = BiomeStandardValues.intSetting("MoodSearchRange", 8, 0, Integer.MAX_VALUE);
    public static final Setting<Integer> BIOME_COLOR = BiomeStandardValues.colorSetting("BiomeColor", "#FFFFFF");
    public static final Setting<Integer> SKY_COLOR = BiomeStandardValues.colorSetting("SkyColor", "#7BA5FF");
    public static final Setting<Integer> WATER_COLOR = BiomeStandardValues.colorSetting("WaterColor", "#FFFFFF");
    public static final Setting<Integer> GRASS_COLOR = BiomeStandardValues.colorSetting("GrassColor", "#FFFFFF");
    public static final Setting<Integer> FOLIAGE_COLOR = BiomeStandardValues.colorSetting("FoliageColor", "#FFFFFF");
    public static final Setting<Integer> FOG_COLOR = BiomeStandardValues.colorSetting("FogColor", "#000000");
    public static final Setting<Integer> WATER_FOG_COLOR = BiomeStandardValues.colorSetting("WaterFogColor", "#000000");
    public static final Setting<List<String>> BIOME_DICT_TAGS = BiomeStandardValues.stringListSetting("BiomeDictTags", "");
    public static final Setting<List<String>> ISLE_IN_BIOME = BiomeStandardValues.stringListSetting("IsleInBiome", "Ocean");
    public static final Setting<List<String>> BIOME_IS_BORDER = BiomeStandardValues.stringListSetting("BiomeIsBorder", new String[0]);
    public static final Setting<List<String>> ONLY_BORDER_NEAR = BiomeStandardValues.stringListSetting("OnlyBorderNear", new String[0]);
    public static final Setting<List<String>> NOT_BORDER_NEAR = BiomeStandardValues.stringListSetting("NotBorderNear", new String[0]);
    public static final Setting<Double> VOLATILITY_1 = BiomeStandardValues.doubleSetting("Volatility1", 0.0, -1000.0, 1000.0);
    public static final Setting<Double> VOLATILITY_2 = BiomeStandardValues.doubleSetting("Volatility2", 0.0, -1000.0, 1000.0);
    public static final Setting<Double> VOLATILITY_WEIGHT_1 = BiomeStandardValues.doubleSetting("VolatilityWeight1", 0.5, -1000.0, 1000.0);
    public static final Setting<Double> VOLATILITY_WEIGHT_2 = BiomeStandardValues.doubleSetting("VolatilityWeight2", 0.45, -1000.0, 1000.0);
    public static final Setting<Double> MAX_AVERAGE_HEIGHT = BiomeStandardValues.doubleSetting("MaxAverageHeight", 0.0, -1000.0, 1000.0);
    public static final Setting<Double> MAX_AVERAGE_DEPTH = BiomeStandardValues.doubleSetting("MaxAverageDepth", 0.0, -1000.0, 1000.0);
    public static final Setting<Double> MOOD_OFFSET = BiomeStandardValues.doubleSetting("MoodOffset", 2.0, 0.0, Double.MAX_VALUE);
    public static final Setting<Double> ADDITIONS_TICK_CHANCE = BiomeStandardValues.doubleSetting("AdditionsTickChance", 0.0, 0.0, Double.MAX_VALUE);
    public static final Setting<LocalMaterialData> STONE_BLOCK = new MaterialSetting("StoneBlock", LocalMaterials.STONE_NAME);
    public static final Setting<LocalMaterialData> SURFACE_BLOCK = new MaterialSetting("SurfaceBlock", LocalMaterials.GRASS_NAME);
    public static final Setting<LocalMaterialData> UNDER_WATER_SURFACE_BLOCK = new MaterialSetting("UnderWaterSurfaceBlock", "");
    public static final Setting<LocalMaterialData> GROUND_BLOCK = new MaterialSetting("GroundBlock", LocalMaterials.DIRT_NAME);
    public static final Setting<LocalMaterialData> COOLED_LAVA_BLOCK = WorldStandardValues.COOLED_LAVA_BLOCK;
    public static final Setting<LocalMaterialData> WATER_BLOCK = WorldStandardValues.WATER_BLOCK;
    public static final Setting<LocalMaterialData> ICE_BLOCK = WorldStandardValues.ICE_BLOCK;
    public static final Setting<LocalMaterialData> PACKED_ICE_BLOCK = new MaterialSetting("PackedIceBlock", LocalMaterials.PACKED_ICE_NAME);
    public static final Setting<LocalMaterialData> SNOW_BLOCK = new MaterialSetting("SnowBlock", LocalMaterials.SNOW_BLOCK_NAME);
    public static final Setting<double[]> CUSTOM_HEIGHT_CONTROL = new DoubleArraySetting("CustomHeightControl");
    public static final Setting<Float> BIOME_TEMPERATURE = BiomeStandardValues.floatSetting("BiomeTemperature", 0.5f, 0.0f, 2.0f);
    public static final Setting<Float> BIOME_WETNESS = BiomeStandardValues.floatSetting("BiomeWetness", 0.5f, 0.0f, 1.0f);
    public static final Setting<Float> BIOME_HEIGHT = BiomeStandardValues.floatSetting("BiomeHeight", 0.1f, -10.0f, 10.0f);
    public static final Setting<Float> BIOME_VOLATILITY = BiomeStandardValues.floatSetting("BiomeVolatility", 0.3f, -1000.0f, 1000.0f);
    public static final Setting<Float> MINESHAFT_PROBABILITY = BiomeStandardValues.floatSetting("MineshaftProbability", 0.004f, 0.0f, 1.0f);
    public static final Setting<Float> OCEAN_RUINS_LARGE_PROBABILITY = BiomeStandardValues.floatSetting("OceanRuinsLargeProbability", 0.3f, 0.0f, 1.0f);
    public static final Setting<Float> OCEAN_RUINS_CLUSTER_PROBABILITY = BiomeStandardValues.floatSetting("OceanRuinsClusterProbability", 0.9f, 0.0f, 1.0f);
    public static final Setting<Float> BURIED_TREASURE_PROBABILITY = BiomeStandardValues.floatSetting("BuriedTreasureProbability", 0.01f, 0.0f, 1.0f);
    public static final Setting<Float> PARTICLE_PROBABILITY = BiomeStandardValues.floatSetting("ParticleProbability", 0.0f, 0.0f, 1.0f);
    public static final Setting<Float> FOG_DENSITY = BiomeStandardValues.floatSetting("FogDensity", 0.0f, 0.0f, 1.0f);
    public static final Setting<List<WeightedMobSpawnGroup>> SPAWN_MONSTERS = BiomeStandardValues.mobGroupListSetting("SpawnMonsters");
    public static final Setting<List<WeightedMobSpawnGroup>> SPAWN_CREATURES = BiomeStandardValues.mobGroupListSetting("SpawnCreatures");
    public static final Setting<List<WeightedMobSpawnGroup>> SPAWN_WATER_CREATURES = BiomeStandardValues.mobGroupListSetting("SpawnWaterCreatures");
    public static final Setting<List<WeightedMobSpawnGroup>> SPAWN_AMBIENT_CREATURES = BiomeStandardValues.mobGroupListSetting("SpawnAmbientCreatures");
    public static final Setting<List<WeightedMobSpawnGroup>> SPAWN_WATER_AMBIENT_CREATURES = BiomeStandardValues.mobGroupListSetting("SpawnWaterAmbientCreatures");
    public static final Setting<List<WeightedMobSpawnGroup>> SPAWN_MISC_CREATURES = BiomeStandardValues.mobGroupListSetting("SpawnMiscCreatures");
    public static final Setting<ColorSet> GRASS_COLOR_CONTROL = BiomeStandardValues.colorSetSetting("GrassColorControl");
    public static final Setting<ColorSet> FOLIAGE_COLOR_CONTROL = BiomeStandardValues.colorSetSetting("FoliageColorControl");
    public static final Setting<ColorSet> WATER_COLOR_CONTROL = BiomeStandardValues.colorSetSetting("WaterColorControl");
    public static final Setting<SettingsEnums.VillageType> VILLAGE_TYPE = BiomeStandardValues.enumSetting("VillageType", SettingsEnums.VillageType.disabled);
    public static final Setting<SettingsEnums.MineshaftType> MINESHAFT_TYPE = BiomeStandardValues.enumSetting("MineshaftType", SettingsEnums.MineshaftType.normal);
    public static final Setting<SettingsEnums.RareBuildingType> RARE_BUILDING_TYPE = BiomeStandardValues.enumSetting("RareBuildingType", SettingsEnums.RareBuildingType.disabled);
    public static final Setting<SettingsEnums.RuinedPortalType> RUINED_PORTAL_TYPE = BiomeStandardValues.enumSetting("RuinedPortalType", SettingsEnums.RuinedPortalType.disabled);
    public static final Setting<SettingsEnums.OceanRuinsType> OCEAN_RUINS_TYPE = BiomeStandardValues.enumSetting("OceanRuinsType", SettingsEnums.OceanRuinsType.disabled);
    public static final Setting<SettingsEnums.GrassColorModifier> GRASS_COLOR_MODIFIER = BiomeStandardValues.enumSetting("GrassColorModifier", SettingsEnums.GrassColorModifier.None);
    public static final Setting<SettingsEnums.TemplateBiomeType> TEMPLATE_BIOME_TYPE = BiomeStandardValues.enumSetting("TemplateBiomeType", SettingsEnums.TemplateBiomeType.Overworld);
    public static final Setting<ReplaceBlockMatrix> REPLACED_BLOCKS = BiomeStandardValues.replacedBlocksSetting("ReplacedBlocks");
    public static final Object[] SURFACE_AND_GROUND_CONTROL = new Object[0];
}

