/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectLoader;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.TreeObject;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.TreeType;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class CustomObjectCollection {
    private Object indexingFilesLock = new Object();
    private ArrayList<CustomObject> objectsGlobalObjects = new ArrayList();
    private HashMap<String, CustomObject> objectsByNameGlobalObjects = new HashMap();
    private ArrayList<String> objectsNotFoundGlobalObjects = new ArrayList();
    private HashMap<String, ArrayList<CustomObject>> objectsPerPreset = new HashMap();
    private HashMap<String, HashMap<String, CustomObject>> objectsByNamePerPreset = new HashMap();
    private HashMap<String, ArrayList<String>> objectsNotFoundPerPreset = new HashMap();
    private HashMap<String, File> customObjectFilesGlobalObjects = null;
    private HashMap<String, File> globalTemplates = null;
    private HashMap<String, HashMap<String, File>> customObjectFilesPerPreset = new HashMap();
    private HashMap<String, HashMap<String, File>> boTemplateFilesPerPreset = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomObject loadObject(File file, String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            CustomObject object2 = null;
            if (file.isFile()) {
                String fileName = file.getName();
                int index = fileName.lastIndexOf(46);
                if (index != -1) {
                    String objectType = fileName.substring(index + 1, fileName.length());
                    String objectName = fileName.substring(0, index);
                    CustomObjectLoader loader = customObjectManager.getObjectLoaders().get(objectType.toLowerCase());
                    if (loader != null) {
                        ArrayList<CustomObject> presetObjects;
                        object2 = loader.loadFromFile(objectName, file, logger);
                        if (presetFolderName != null) {
                            presetObjects = this.objectsPerPreset.get(presetFolderName);
                            if (presetObjects == null) {
                                presetObjects = new ArrayList();
                                this.objectsPerPreset.put(presetFolderName, presetObjects);
                            }
                            presetObjects.add(object2);
                        } else {
                            this.objectsGlobalObjects.add(object2);
                        }
                        if (!object2.onEnable(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker) || !object2.loadChecks(modLoadedChecker)) {
                            this.removeLoadedObject(presetFolderName, object2);
                            loader = customObjectManager.getObjectLoaders().get("bo4");
                            if (loader != null) {
                                object2 = loader.loadFromFile(objectName, file, logger);
                                if (presetFolderName != null) {
                                    presetObjects = this.objectsPerPreset.get(presetFolderName);
                                    if (presetObjects == null) {
                                        presetObjects = new ArrayList();
                                        this.objectsPerPreset.put(presetFolderName, presetObjects);
                                    }
                                    presetObjects.add(object2);
                                } else {
                                    this.objectsGlobalObjects.add(object2);
                                }
                                if (!object2.onEnable(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker) || !object2.loadChecks(modLoadedChecker)) {
                                    this.removeLoadedObject(presetFolderName, object2);
                                    return null;
                                }
                            }
                        }
                    }
                }
            } else {
                logger.log(LogLevel.FATAL, LogCategory.CUSTOM_OBJECTS, "Given path does not exist: " + file.getAbsolutePath());
                throw new RuntimeException("Given path does not exist: " + file.getAbsolutePath());
            }
            return object2;
        }
    }

    private void removeLoadedObject(String presetFolderName, CustomObject object) {
        if (presetFolderName != null) {
            HashMap<String, CustomObject> presetObjectsByName = this.objectsByNamePerPreset.get(presetFolderName);
            if (presetObjectsByName != null) {
                presetObjectsByName.remove(object.getName());
                if (presetObjectsByName.size() == 0) {
                    this.objectsByNamePerPreset.remove(presetFolderName, presetObjectsByName);
                }
            }
            ArrayList<CustomObject> worldObjects = this.objectsPerPreset.get(presetFolderName);
            worldObjects.remove(object);
            if (worldObjects.size() == 0) {
                this.objectsPerPreset.remove(presetFolderName, worldObjects);
            }
        } else {
            this.objectsGlobalObjects.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoadedGlobalObject(CustomObject object) {
        Object object2 = this.indexingFilesLock;
        synchronized (object2) {
            String name = object.getName();
            if (!this.objectsByNameGlobalObjects.containsKey(name.toLowerCase())) {
                this.objectsByNameGlobalObjects.put(name.toLowerCase(), object);
                this.objectsGlobalObjects.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addGlobalObjectFile(String name, File file) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            if (this.customObjectFilesGlobalObjects != null && !this.customObjectFilesGlobalObjects.containsKey(name.toLowerCase())) {
                this.customObjectFilesGlobalObjects.put(name.toLowerCase(), file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadCustomObjectFiles() {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            this.objectsGlobalObjects.clear();
            this.objectsByNameGlobalObjects.clear();
            this.objectsNotFoundGlobalObjects.clear();
            this.objectsPerPreset.clear();
            this.objectsByNamePerPreset.clear();
            this.objectsNotFoundPerPreset.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadCustomObjectFiles() {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            this.objectsGlobalObjects.clear();
            this.objectsByNameGlobalObjects.clear();
            this.objectsNotFoundGlobalObjects.clear();
            this.objectsPerPreset.clear();
            this.objectsByNamePerPreset.clear();
            this.objectsNotFoundPerPreset.clear();
            this.customObjectFilesGlobalObjects = null;
            this.globalTemplates = null;
            this.customObjectFilesPerPreset.clear();
            this.boTemplateFilesPerPreset.clear();
        }
    }

    public ArrayList<String> getAllBONamesForPreset(String presetFolderName, ILogger logger, Path otgRootPath) {
        HashMap<String, File> files = this.customObjectFilesPerPreset.get(presetFolderName);
        if (files == null) {
            this.indexPresetObjectsFolder(presetFolderName, logger, otgRootPath);
            files = this.customObjectFilesPerPreset.get(presetFolderName);
        }
        return files == null ? null : new ArrayList(files.values().stream().map(a -> a.getName().substring(0, a.getName().lastIndexOf("."))).collect(Collectors.toList()));
    }

    public ArrayList<String> getTemplatesForPreset(String presetFolderName, ILogger logger, Path otgRootPath) {
        HashMap<String, File> files = this.boTemplateFilesPerPreset.get(presetFolderName);
        if (files == null) {
            this.indexPresetObjectsFolder(presetFolderName, logger, otgRootPath);
            files = this.customObjectFilesPerPreset.get(presetFolderName);
        }
        return files == null ? null : new ArrayList(files.values().stream().map(a -> a.getName().substring(0, a.getName().lastIndexOf("."))).collect(Collectors.toList()));
    }

    public File getTemplateFileForPreset(String presetFolderName, String templateName, ILogger logger, Path otgRootPath) {
        HashMap<String, File> files = this.boTemplateFilesPerPreset.get(presetFolderName);
        if (files == null) {
            this.indexPresetObjectsFolder(presetFolderName, logger, otgRootPath);
            files = this.customObjectFilesPerPreset.get(presetFolderName);
        }
        return files == null ? null : files.get(templateName.toLowerCase());
    }

    public ArrayList<String> getGlobalObjectNames(ILogger logger, Path otgRootPath) {
        if (this.customObjectFilesGlobalObjects == null) {
            this.indexGlobalObjectsFolder(logger, otgRootPath);
        }
        return this.customObjectFilesGlobalObjects == null ? null : new ArrayList<String>(this.customObjectFilesGlobalObjects.keySet());
    }

    public ArrayList<String> getGlobalTemplates(ILogger logger, Path otgRootPath) {
        if (this.globalTemplates == null) {
            this.indexGlobalObjectsFolder(logger, otgRootPath);
        }
        return this.globalTemplates == null ? null : new ArrayList<String>(this.globalTemplates.keySet());
    }

    public void addObjectToPreset(String presetFolderName, String objectName, File boFile, CustomObject object) {
        HashMap<String, File> customObjectFiles;
        HashMap<String, CustomObject> objectsByName = this.objectsByNamePerPreset.get(presetFolderName);
        if (objectsByName != null) {
            objectsByName.put(objectName.toLowerCase(), object);
        }
        if ((customObjectFiles = this.customObjectFilesPerPreset.get(presetFolderName)) != null) {
            customObjectFiles.put(objectName.toLowerCase(), boFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomObject getObjectByName(String name, String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            return this.getObjectByName(name, presetFolderName, true, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexGlobalObjectsFolder(ILogger logger, Path otgRootFolder) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            if (this.customObjectFilesGlobalObjects == null) {
                if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    logger.log(LogLevel.INFO, LogCategory.CUSTOM_OBJECTS, "Indexing GlobalObjects folder.");
                }
                this.customObjectFilesGlobalObjects = new HashMap();
                this.globalTemplates = new HashMap();
                if (new File(otgRootFolder + File.separator + "GlobalObjects").exists()) {
                    this.indexAllCustomObjectFilesInDir(new File(otgRootFolder + File.separator + "GlobalObjects"), this.customObjectFilesGlobalObjects, this.globalTemplates, logger);
                }
                for (TreeType type : TreeType.values()) {
                    this.addLoadedGlobalObject(new TreeObject(type));
                }
                if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    logger.log(LogLevel.INFO, LogCategory.CUSTOM_OBJECTS, "GlobalObjects folder indexed.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexPresetObjectsFolder(String presetFolderName, ILogger logger, Path otgRootFolder) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            if (presetFolderName != null && !this.customObjectFilesPerPreset.containsKey(presetFolderName)) {
                if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    logger.log(LogLevel.INFO, LogCategory.CUSTOM_OBJECTS, "Indexing Objects folder for preset " + presetFolderName);
                }
                HashMap<String, File> presetCustomObjectFiles = new HashMap<String, File>();
                this.customObjectFilesPerPreset.put(presetFolderName, presetCustomObjectFiles);
                HashMap<String, File> templateFiles = new HashMap<String, File>();
                this.boTemplateFilesPerPreset.put(presetFolderName, templateFiles);
                if (presetFolderName != null) {
                    String objectsFolderName;
                    String string = new File(otgRootFolder + File.separator + "Presets" + File.separator + presetFolderName + File.separator + "Objects").exists() ? "Objects" : (objectsFolderName = new File(otgRootFolder + File.separator + "Presets" + File.separator + presetFolderName + File.separator + "WorldObjects").exists() ? "WorldObjects" : null);
                    if (objectsFolderName != null) {
                        this.indexAllCustomObjectFilesInDir(new File(otgRootFolder + File.separator + "Presets" + File.separator + presetFolderName + File.separator + objectsFolderName), presetCustomObjectFiles, templateFiles, logger);
                    }
                }
                if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                    logger.log(LogLevel.INFO, LogCategory.CUSTOM_OBJECTS, "Objects folder for preset " + presetFolderName + " indexed.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomObject getObjectByName(String name, String presetFolderName, boolean searchGlobalObjects, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        Object object = this.indexingFilesLock;
        synchronized (object) {
            ArrayList<String> presetObjectsNotFoundByName;
            HashMap<String, CustomObject> presetObjectsByName;
            CustomObject object2 = null;
            if (presetFolderName != null && (presetObjectsByName = this.objectsByNamePerPreset.get(presetFolderName)) != null) {
                object2 = presetObjectsByName.get(name.toLowerCase());
            }
            boolean bSearchedPresetObjects = false;
            if (object2 == null && presetFolderName != null && (presetObjectsNotFoundByName = this.objectsNotFoundPerPreset.get(presetFolderName)) != null && presetObjectsNotFoundByName.contains(name)) {
                bSearchedPresetObjects = true;
            }
            if (object2 == null && searchGlobalObjects && (presetFolderName == null || bSearchedPresetObjects)) {
                object2 = this.objectsByNameGlobalObjects.get(name.toLowerCase());
            }
            if (object2 != null) {
                return object2;
            }
            boolean bSearchedGlobalObjects = false;
            if (this.objectsNotFoundGlobalObjects != null && this.objectsNotFoundGlobalObjects.contains(name)) {
                bSearchedGlobalObjects = true;
            }
            if (!(searchGlobalObjects && !bSearchedGlobalObjects || presetFolderName != null && !bSearchedPresetObjects)) {
                return null;
            }
            this.indexGlobalObjectsFolder(logger, otgRootFolder);
            this.indexPresetObjectsFolder(presetFolderName, logger, otgRootFolder);
            if (presetFolderName != null && !bSearchedPresetObjects) {
                File searchForFile;
                HashMap<String, File> presetCustomObjectFiles = this.customObjectFilesPerPreset.get(presetFolderName);
                if (presetCustomObjectFiles != null && (searchForFile = presetCustomObjectFiles.get(name.toLowerCase())) != null) {
                    object2 = this.loadObject(searchForFile, presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                    if (object2 != null) {
                        HashMap<String, CustomObject> presetObjectsByName2 = this.objectsByNamePerPreset.get(presetFolderName);
                        if (presetObjectsByName2 == null) {
                            presetObjectsByName2 = new HashMap();
                            this.objectsByNamePerPreset.put(presetFolderName, presetObjectsByName2);
                        }
                        presetObjectsByName2.put(name.toLowerCase(), object2);
                        return object2;
                    }
                    if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not load BO2/BO3, it likely contains errors: " + searchForFile);
                    }
                    return null;
                }
                ArrayList<String> presetObjectsNotFound = this.objectsNotFoundPerPreset.get(presetFolderName);
                if (presetObjectsNotFound == null) {
                    presetObjectsNotFound = new ArrayList();
                    this.objectsNotFoundPerPreset.put(presetFolderName, presetObjectsNotFound);
                }
                presetObjectsNotFound.add(name);
            }
            if (searchGlobalObjects && !bSearchedGlobalObjects) {
                object2 = this.objectsByNameGlobalObjects.get(name.toLowerCase());
                if (object2 != null) {
                    return object2;
                }
                File searchForFile = this.customObjectFilesGlobalObjects.get(name.toLowerCase());
                if (searchForFile != null) {
                    object2 = this.loadObject(searchForFile, presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
                    if (object2 != null) {
                        this.objectsByNameGlobalObjects.put(name.toLowerCase(), object2);
                        return object2;
                    }
                    if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not load BO2/BO3, it probably contains errors: " + searchForFile);
                    }
                    return null;
                }
                this.objectsNotFoundGlobalObjects.add(name);
            }
            if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not find BO2/BO3 " + name + " in GlobalObjects " + (presetFolderName != null ? "and Objects" : "") + " directory " + (presetFolderName != null ? "for preset " + presetFolderName : "") + ".");
            }
            return null;
        }
    }

    private void indexAllCustomObjectFilesInDir(File searchDir, HashMap<String, File> customObjectFiles, HashMap<String, File> templateFiles, ILogger logger) {
        if (searchDir.exists()) {
            if (searchDir.isDirectory()) {
                for (File fileInDir : searchDir.listFiles()) {
                    String fileExtension;
                    if (fileInDir.isDirectory()) {
                        this.indexAllCustomObjectFilesInDir(fileInDir, customObjectFiles, templateFiles, logger);
                        continue;
                    }
                    String name = fileInDir.getName().contains(".") ? fileInDir.getName().substring(0, fileInDir.getName().lastIndexOf(".")) : fileInDir.getName();
                    String string = fileExtension = fileInDir.getName().contains(".") ? fileInDir.getName().substring(fileInDir.getName().lastIndexOf(".")).toLowerCase() : null;
                    if (fileExtension != null && (fileExtension.equals(".bo4data") || fileExtension.equals(".bo4") || fileExtension.equals(".bo3") || fileExtension.equals(".bo2"))) {
                        if (fileExtension.equals(".bo4data") || !customObjectFiles.containsKey(name.toLowerCase())) {
                            customObjectFiles.put(name.toLowerCase(), fileInDir);
                            continue;
                        }
                        if (!logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) continue;
                        logger.log(LogLevel.WARN, LogCategory.CUSTOM_OBJECTS, "Duplicate file found: " + name + ".");
                        continue;
                    }
                    if (fileExtension == null || !fileExtension.equals(".bo3template")) continue;
                    templateFiles.put(name.toLowerCase(), fileInDir);
                }
            } else {
                String fileExtension;
                String name = searchDir.getName().contains(".") ? searchDir.getName().substring(0, searchDir.getName().lastIndexOf(".")) : searchDir.getName();
                String string = fileExtension = searchDir.getName().contains(".") ? searchDir.getName().substring(searchDir.getName().lastIndexOf(".")).toLowerCase() : null;
                if (fileExtension != null && (fileExtension.equals(".bo4data") || fileExtension.equals(".bo4") || fileExtension.equals(".bo3") || fileExtension.equals(".bo2"))) {
                    if (fileExtension.endsWith(".bo4data") || !customObjectFiles.containsKey(name.toLowerCase())) {
                        customObjectFiles.put(name.toLowerCase(), searchDir);
                    } else if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        logger.log(LogLevel.WARN, LogCategory.CUSTOM_OBJECTS, "Duplicate file found: " + searchDir.getName() + ".");
                    }
                } else if (fileExtension != null && fileExtension.matches(".+\\.bo[34]template")) {
                    templateFiles.put(name.toLowerCase(), searchDir);
                }
            }
        }
    }
}

