/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectCollection;
import com.pg85.otg.customobject.CustomObjectLoader;
import com.pg85.otg.customobject.bo2.BO2Loader;
import com.pg85.otg.customobject.bo3.BO3Loader;
import com.pg85.otg.customobject.bo4.BO4Loader;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.interfaces.ICustomObjectManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CustomObjectManager
implements ICustomObjectManager {
    private final Map<String, CustomObjectLoader> loaders = new HashMap<String, CustomObjectLoader>();
    private final CustomObjectCollection globalCustomObjects;

    public CustomObjectManager(boolean developerMode, final ILogger logger, final Path otgRootFolder, final Path otgPresetsFolder, CustomObjectResourcesManager manager) {
        this.registerCustomObjectLoader("bo2", new BO2Loader());
        this.registerCustomObjectLoader("bo3", new BO3Loader(manager));
        this.registerCustomObjectLoader("bo4", new BO4Loader(manager));
        this.registerCustomObjectLoader("bo4data", new BO4Loader(manager));
        this.globalCustomObjects = new CustomObjectCollection();
        if (!developerMode) {
            new Thread(){

                @Override
                public void run() {
                    CustomObjectManager.this.globalCustomObjects.indexGlobalObjectsFolder(logger, otgRootFolder);
                    for (File file : otgPresetsFolder.toFile().listFiles()) {
                        if (!file.isDirectory()) continue;
                        String presetFolderName = file.getName();
                        CustomObjectManager.this.globalCustomObjects.indexPresetObjectsFolder(presetFolderName, logger, otgRootFolder);
                    }
                    if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        logger.log(LogLevel.INFO, LogCategory.CUSTOM_OBJECTS, "All CustomObject files indexed.");
                    }
                }
            }.start();
        }
    }

    public void reloadCustomObjectFiles() {
        this.globalCustomObjects.reloadCustomObjectFiles();
    }

    private void registerCustomObjectLoader(String extension, CustomObjectLoader loader) {
        this.loaders.put(extension.toLowerCase(), loader);
    }

    public void registerGlobalObject(CustomObject object) {
        this.globalCustomObjects.addLoadedGlobalObject(object);
    }

    public void registerGlobalObject(CustomObject object, File file) {
        this.globalCustomObjects.addGlobalObjectFile(object.getName(), file);
        this.registerGlobalObject(object);
    }

    public CustomObjectCollection getGlobalObjects() {
        return this.globalCustomObjects;
    }

    public Map<String, CustomObjectLoader> getObjectLoaders() {
        return Collections.unmodifiableMap(this.loaders);
    }

    public void shutdown() {
        for (CustomObjectLoader loader : this.loaders.values()) {
            loader.onShutdown();
        }
        this.loaders.clear();
    }
}

