/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.minecraft.TreeType;
import java.nio.file.Path;
import java.util.Random;

class TreeObject
implements CustomObject {
    private TreeType type;
    private int minHeight = 0;
    private int maxHeight = 255;

    TreeObject(TreeType type) {
        this.type = type;
    }

    @Override
    public boolean onEnable(String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        return true;
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public boolean canSpawnAsTree() {
        return true;
    }

    @Override
    public boolean process(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random) {
        int z;
        int x = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterX() + random.nextInt(16);
        int y = worldGenRegion.getHighestBlockAboveYAt(x, z = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterZ() + random.nextInt(16));
        if (y < this.minHeight || y > this.maxHeight) {
            return false;
        }
        return this.spawnForced(structureCache, worldGenRegion, random, Rotation.NORTH, x, y, z, false);
    }

    @Override
    public boolean spawnFromSapling(IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z) {
        return worldGenRegion.placeTree(this.type, random, x, y, z);
    }

    @Override
    public boolean spawnForced(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z, boolean allowReplaceBlocks) {
        return worldGenRegion.placeTree(this.type, random, x, y, z);
    }

    @Override
    public boolean spawnAsTree(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, int x, int z, int minY, int maxY) {
        int y = worldGenRegion.getHighestBlockAboveYAt(x, z);
        Rotation rotation = Rotation.getRandomRotation(random);
        if (!(minY == -1 && maxY == -1 || y >= minY && y <= maxY)) {
            return false;
        }
        if (y < this.minHeight || y > this.maxHeight) {
            return false;
        }
        return this.spawnForced(structureCache, worldGenRegion, random, rotation, x, y, z, true);
    }

    @Override
    public boolean canRotateRandomly() {
        return false;
    }

    @Override
    public boolean loadChecks(IModLoadedChecker modLoadedChecker) {
        return true;
    }

    @Override
    public boolean doReplaceBlocks() {
        return false;
    }
}

