/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo2;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo2.BO2Settings;
import com.pg85.otg.customobject.bo2.ObjectCoordinate;
import com.pg85.otg.customobject.bo3.BO3Config;
import com.pg85.otg.customobject.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.config.CustomObjectConfigFile;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.FileSettingsReaderBO4;
import com.pg85.otg.customobject.config.io.SettingsReaderBO4;
import com.pg85.otg.customobject.config.io.SettingsWriterBO4;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.customobject.util.BoundingBox;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.ICustomObjectManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.LocalMaterials;
import com.pg85.otg.util.materials.MaterialSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class BO2
extends CustomObjectConfigFile
implements CustomObject {
    private ObjectCoordinate[][] data = new ObjectCoordinate[4][];
    private boolean isEnabled = false;
    public MaterialSet spawnOnBlockType;
    private MaterialSet collisionBlockType;
    private boolean spawnWater;
    private boolean spawnLava;
    public boolean spawnAboveGround;
    public boolean spawnUnderGround;
    private boolean spawnSunlight;
    private boolean spawnDarkness;
    private boolean randomRotation;
    private boolean dig;
    private boolean tree;
    private boolean branch;
    private boolean needsFoundation;
    private boolean doReplaceBlocks;
    private int rarity;
    public double collisionPercentage;
    public int spawnElevationMin;
    public int spawnElevationMax;

    BO2(SettingsReaderBO4 reader) {
        super(reader);
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.tree;
    }

    @Override
    public boolean doReplaceBlocks() {
        return this.doReplaceBlocks;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.randomRotation;
    }

    @Override
    public boolean spawnFromSapling(IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z) {
        ObjectCoordinate[] data = this.data[rotation.getRotationId()];
        ArrayList<ObjectCoordinate> blocksToSpawn = new ArrayList<ObjectCoordinate>();
        for (ObjectCoordinate point : data) {
            LocalMaterialData material = worldGenRegion.getMaterial(x + point.x, y + point.y, z + point.z);
            if (!material.isAir() && !material.isLogOrLeaves()) {
                return false;
            }
            if (!material.isAir()) continue;
            blocksToSpawn.add(point);
        }
        IBiomeConfig biomeConfig = null;
        int lastX = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (ObjectCoordinate point : blocksToSpawn) {
            if (this.doReplaceBlocks) {
                if (lastX != x + point.x || lastZ != z + point.z) {
                    biomeConfig = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(x + point.x, z + point.z, true);
                    lastX = x + point.x;
                    lastZ = z + point.z;
                }
                this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material, biomeConfig.getReplaceBlocks());
                continue;
            }
            this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material);
        }
        return true;
    }

    public BO3Config getConvertedConfig(String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) throws InvalidConfigException {
        BO3Config newConfig = new BO3Config(new FileSettingsReaderBO4(this.getName(), ObjectType.BO3.getObjectFilePathFromName(this.getName(), this.getFile().getParentFile().toPath()).toFile(), logger), presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        BoundingBox box = BoundingBox.newEmptyBox();
        newConfig.extractBlocks(Arrays.asList(this.getBlockFunctions(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)));
        newConfig.addBlockCheckFromBO2(this.spawnOnBlockType);
        for (BlockFunction<?> res : newConfig.getBlockFunctions(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker)) {
            if (!(res instanceof BO3BlockFunction)) continue;
            BO3BlockFunction block = (BO3BlockFunction)res;
            box.expandToFit(block.x, block.y, block.z);
        }
        newConfig.setBoundingBox(box);
        newConfig.rotateBlocksAndChecks(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        newConfig.getSettingsFromBO2(this);
        return newConfig;
    }

    @Override
    public BlockFunction<?>[] getBlockFunctions(String presetFolderName, Path otgRootFolder, ILogger logger, ICustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        ObjectCoordinate[] data = this.data[0];
        BO3BlockFunction[] blockFunctions = new BO3BlockFunction[data.length];
        int i = 0;
        for (ObjectCoordinate point : data) {
            BO3BlockFunction block = new BO3BlockFunction();
            block.material = point.material;
            block.nbt = null;
            block.nbtName = "";
            block.x = point.x;
            block.y = (short)point.y;
            block.z = point.z;
            blockFunctions[i++] = block;
        }
        return blockFunctions;
    }

    @Override
    public boolean spawnForced(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z, boolean allowReplaceBlocks) {
        ObjectCoordinate[] data = this.data[rotation.getRotationId()];
        ReplaceBlockMatrix replaceBlocks = null;
        int lastX = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (ObjectCoordinate point : data) {
            LocalMaterialData worldMaterial;
            if (this.doReplaceBlocks && (lastX != x + point.x || lastZ != z + point.z)) {
                replaceBlocks = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(x + point.x, z + point.z, true).getReplaceBlocks();
                lastX = x + point.x;
                lastZ = z + point.z;
            }
            if ((worldMaterial = worldGenRegion.getMaterial(x + point.x, y + point.y, z + point.z)) == null) continue;
            if (worldMaterial.isAir()) {
                if (this.doReplaceBlocks) {
                    this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material, replaceBlocks);
                    continue;
                }
                this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material);
                continue;
            }
            if (!this.dig) continue;
            if (allowReplaceBlocks && this.doReplaceBlocks) {
                this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material, replaceBlocks);
                continue;
            }
            this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material);
        }
        return true;
    }

    private boolean canSpawnAt(IWorldGenRegion worldGenRegion, Rotation rotation, int x, int y, int z) {
        ObjectCoordinate[] objData;
        int checkLight;
        LocalMaterialData checkBlock;
        if (y < 0 || y >= 256) {
            return false;
        }
        if (y < this.spawnElevationMin || y > this.spawnElevationMax) {
            return false;
        }
        if (!this.spawnOnBlockType.contains(worldGenRegion.getMaterial(x, y - 1, z))) {
            return false;
        }
        LocalMaterialData worldMaterial = worldGenRegion.getMaterial(x, y - 5, z);
        if (this.needsFoundation && worldMaterial == null || worldMaterial.isAir()) {
            return false;
        }
        LocalMaterialData localMaterialData = checkBlock = !this.spawnWater || !this.spawnLava ? worldGenRegion.getMaterial(x, y + 2, z) : null;
        if (checkBlock == null) {
            return false;
        }
        if (!this.spawnWater && checkBlock.isMaterial(LocalMaterials.WATER)) {
            return false;
        }
        if (!this.spawnLava && checkBlock.isMaterial(LocalMaterials.LAVA)) {
            return false;
        }
        int n = checkLight = !this.spawnSunlight || !this.spawnDarkness ? worldGenRegion.getLightLevel(x, y + 2, z) : 0;
        if (checkLight == -1) {
            return false;
        }
        if (!this.spawnSunlight && checkLight > 8) {
            return false;
        }
        if (!this.spawnDarkness && checkLight < 9) {
            return false;
        }
        HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
        for (ObjectCoordinate point : objData = this.data[rotation.getRotationId()]) {
            if (y + point.y < 0 || y + point.y >= 256) {
                return false;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x + point.x, z + point.z);
            if (loadedChunks.contains(chunkCoord)) continue;
            if (!worldGenRegion.getDecorationArea().isInAreaBeingDecorated(x + point.x, z + point.z)) {
                return false;
            }
            loadedChunks.add(chunkCoord);
        }
        if (!this.dig && (int)Math.floor(this.collisionPercentage) < 100) {
            int faultCounter = 0;
            int maxBlocksOutsideSourceBlock = (int)Math.ceil((double)objData.length * (this.collisionPercentage / 100.0));
            for (ObjectCoordinate point : objData) {
                LocalMaterialData material = worldGenRegion.getMaterial(x + point.x, y + point.y, z + point.z);
                if (material != null && !this.collisionBlockType.contains(material) || material != null && ++faultCounter <= maxBlocksOutsideSourceBlock) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean spawnAsTree(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, int x, int z, int minY, int maxY) {
        return this.spawn(worldGenRegion, random, x, z, minY == -1 ? this.spawnElevationMin : minY, maxY == -1 ? this.spawnElevationMax : maxY);
    }

    private boolean spawn(IWorldGenRegion worldGenRegion, Random random, int x, int z, int minY, int maxY) {
        Rotation rotation;
        int y;
        if (this.spawnAboveGround) {
            y = worldGenRegion.getBlockAboveSolidHeight(x, z);
        } else if (this.spawnUnderGround) {
            int solidHeight = worldGenRegion.getBlockAboveSolidHeight(x, z);
            if (solidHeight < 1 || solidHeight <= minY) {
                return false;
            }
            if (solidHeight > maxY) {
                solidHeight = maxY;
            }
            y = random.nextInt(solidHeight - minY) + minY;
        } else {
            y = worldGenRegion.getHighestBlockAboveYAt(x, z);
        }
        if (y < 0) {
            return false;
        }
        Rotation rotation2 = rotation = this.randomRotation ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        if (!this.canSpawnAt(worldGenRegion, rotation, x, y, z)) {
            return false;
        }
        ObjectCoordinate[] data = this.data[rotation.getRotationId()];
        ReplaceBlockMatrix replaceBlocks = null;
        int lastX = Integer.MIN_VALUE;
        int lastZ = Integer.MIN_VALUE;
        for (ObjectCoordinate point : data) {
            LocalMaterialData worldMaterial = worldGenRegion.getMaterial(x + point.x, y + point.y, z + point.z);
            if (worldMaterial == null) continue;
            if (this.doReplaceBlocks && (lastX != x + point.x || lastZ != z + point.z)) {
                replaceBlocks = worldGenRegion.getBiomeConfigForDecoration(x + point.x, z + point.z).getReplaceBlocks();
                lastX = x + point.x;
                lastZ = z + point.z;
            }
            if (worldMaterial.isAir()) {
                if (this.doReplaceBlocks) {
                    this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material, replaceBlocks);
                    continue;
                }
                this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material);
                continue;
            }
            if (!this.dig) continue;
            if (this.doReplaceBlocks) {
                this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material, replaceBlocks);
                continue;
            }
            this.setBlock(worldGenRegion, x + point.x, y + point.y, z + point.z, point.material);
        }
        return true;
    }

    @Override
    public boolean process(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random rand) {
        if (this.branch) {
            return false;
        }
        int randomRoll = rand.nextInt(100);
        boolean objectSpawned = false;
        for (int ObjectRarity = this.rarity; randomRoll < ObjectRarity; ObjectRarity -= 100) {
            int x = worldGenRegion.getDecorationArea().getChunkBeingDecorated().getBlockX() + rand.nextInt(16);
            int z = worldGenRegion.getDecorationArea().getChunkBeingDecorated().getBlockZ() + rand.nextInt(16);
            objectSpawned = this.spawn(worldGenRegion, rand, x, z, this.spawnElevationMin, this.spawnElevationMax);
        }
        return objectSpawned;
    }

    @Override
    protected void writeConfigSettings(SettingsWriterBO4 writer, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) throws IOException {
    }

    @Override
    protected void readConfigSettings(String presetFolderName, Path otgRootFolder, ILogger logger, ICustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        this.spawnOnBlockType = this.readSettings(BO2Settings.SPAWN_ON_BLOCK_TYPE, logger, materialReader, manager);
        this.collisionBlockType = this.readSettings(BO2Settings.COLLISION_BLOCK_TYPE, logger, materialReader, manager);
        this.spawnSunlight = this.readSettings(BO2Settings.SPAWN_SUNLIGHT, logger, materialReader, manager);
        this.spawnDarkness = this.readSettings(BO2Settings.SPAWN_DARKNESS, logger, materialReader, manager);
        this.spawnWater = this.readSettings(BO2Settings.SPAWN_WATER, logger, materialReader, manager);
        this.spawnLava = this.readSettings(BO2Settings.SPAWN_LAVA, logger, materialReader, manager);
        this.spawnAboveGround = this.readSettings(BO2Settings.SPAWN_ABOVE_GROUND, logger, materialReader, manager);
        this.spawnUnderGround = this.readSettings(BO2Settings.SPAWN_UNDER_GROUND, logger, materialReader, manager);
        this.randomRotation = this.readSettings(BO2Settings.RANDON_ROTATION, logger, materialReader, manager);
        this.dig = this.readSettings(BO2Settings.DIG, logger, materialReader, manager);
        this.tree = this.readSettings(BO2Settings.TREE, logger, materialReader, manager);
        this.branch = this.readSettings(BO2Settings.BRANCH, logger, materialReader, manager);
        this.needsFoundation = this.readSettings(BO2Settings.NEEDS_FOUNDATION, logger, materialReader, manager);
        this.doReplaceBlocks = this.readSettings(BO2Settings.DO_REPLACE_BLOCKS, logger, materialReader, manager);
        this.rarity = this.readSettings(BO2Settings.RARITY, logger, materialReader, manager);
        this.collisionPercentage = this.readSettings(BO2Settings.COLLISION_PERCENTAGE, logger, materialReader, manager);
        this.spawnElevationMin = this.readSettings(BO2Settings.SPAWN_ELEVATION_MIN, logger, materialReader, manager);
        this.spawnElevationMax = this.readSettings(BO2Settings.SPAWN_ELEVATION_MAX, logger, materialReader, manager);
        this.readCoordinates(materialReader);
    }

    @Override
    protected void correctSettings() {
    }

    @Override
    protected void renameOldSettings() {
    }

    private void readCoordinates(IMaterialReader materialReader) {
        ArrayList<ObjectCoordinate> coordinates = new ArrayList<ObjectCoordinate>();
        for (Map.Entry<String, String> line : this.reader.getRawSettings()) {
            ObjectCoordinate buffer = ObjectCoordinate.getCoordinateFromString(line.getKey(), line.getValue(), materialReader);
            if (buffer == null) continue;
            coordinates.add(buffer);
        }
        this.data[0] = new ObjectCoordinate[coordinates.size()];
        this.data[1] = new ObjectCoordinate[coordinates.size()];
        this.data[2] = new ObjectCoordinate[coordinates.size()];
        this.data[3] = new ObjectCoordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            ObjectCoordinate coordinate;
            this.data[0][i] = coordinate = (ObjectCoordinate)coordinates.get(i);
            this.data[1][i] = coordinate = coordinate.rotate();
            this.data[2][i] = coordinate = coordinate.rotate();
            this.data[3][i] = coordinate = coordinate.rotate();
        }
    }

    private void setBlock(IWorldGenRegion worldGenRegion, int x, int y, int z, LocalMaterialData material) {
        worldGenRegion.setBlock(x, y, z, material);
    }

    private void setBlock(IWorldGenRegion worldGenRegion, int x, int y, int z, LocalMaterialData material, ReplaceBlockMatrix replacedBlocks) {
        worldGenRegion.setBlock(x, y, z, material, replacedBlocks);
    }

    @Override
    public boolean onEnable(String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        if (!this.isEnabled) {
            this.isEnabled = true;
            this.enable(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        }
        return true;
    }

    private void enable(String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        this.readConfigSettings(presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        this.correctSettings();
    }

    @Override
    public boolean loadChecks(IModLoadedChecker modLoadedChecker) {
        return true;
    }
}

