/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo3;

import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo3.BO3Config;
import com.pg85.otg.customobject.bo3.ObjectExtrusionHelper;
import com.pg85.otg.customobject.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.customobject.bo3.bo3function.BO3EntityFunction;
import com.pg85.otg.customobject.bo3.checks.BO3Check;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.FileSettingsReaderBO4;
import com.pg85.otg.customobject.config.io.FileSettingsWriterBO4;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.Branch;
import com.pg85.otg.customobject.structures.CustomStructure;
import com.pg85.otg.customobject.structures.CustomStructureCache;
import com.pg85.otg.customobject.structures.CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobject.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.customobject.util.BO3Enums;
import com.pg85.otg.customobject.util.BoundingBox;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.LocalMaterialData;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class BO3
implements StructuredCustomObject {
    private BO3Config settings;
    private final String name;
    private final File file;
    private boolean isInvalidConfig;

    public BO3(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public BO3(String name, File file, BO3Config settings) {
        this.name = name;
        this.file = file;
        this.settings = settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ObjectType getType() {
        return ObjectType.BO3;
    }

    @Override
    public BO3Config getConfig() {
        return this.settings;
    }

    @Override
    public boolean onEnable(String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        if (this.isInvalidConfig) {
            return false;
        }
        if (this.settings != null) {
            return true;
        }
        try {
            this.settings = new BO3Config(new FileSettingsReaderBO4(this.name, this.file, logger), presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
            if (this.settings.settingsMode != SettingsEnums.ConfigMode.WriteDisable) {
                FileSettingsWriterBO4.writeToFile(this.settings, this.settings.settingsMode, logger, materialReader, manager);
            }
        }
        catch (InvalidConfigException ex) {
            this.isInvalidConfig = true;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.settings.tree;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.settings.rotateRandomly;
    }

    @Override
    public boolean loadChecks(IModLoadedChecker modLoadedChecker) {
        return this.settings == null ? false : this.settings.parseModChecks(modLoadedChecker);
    }

    @Override
    public boolean spawnFromSapling(IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z) {
        BO3BlockFunction[] blocks = this.settings.getBlocks(rotation.getRotationId());
        ArrayList<BO3BlockFunction> blocksToSpawn = new ArrayList<BO3BlockFunction>();
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        for (BO3BlockFunction block : blocks) {
            LocalMaterialData localMaterial = worldGenRegion.getMaterial(x + block.x, y + block.y, z + block.z);
            if (!(block.y < 0 || localMaterial.isAir() || localMaterial.isLogOrLeaves() || localMaterial.isSapling())) {
                return false;
            }
            if (localMaterial.isAir()) {
                chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
                blocksToSpawn.add(block);
            }
            oeh.addBlock(block);
        }
        ReplaceBlockMatrix replaceBlocks = null;
        int lastX = Integer.MIN_VALUE;
        int lastZ = Integer.MIN_VALUE;
        for (BO3BlockFunction block : blocksToSpawn) {
            if (this.doReplaceBlocks()) {
                if (lastX != x + block.x || lastZ != z + block.z) {
                    replaceBlocks = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(x + block.x, z + block.z, true).getReplaceBlocks();
                    lastX = x + block.x;
                    lastZ = z + z + block.z;
                }
                block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z, replaceBlocks);
                continue;
            }
            block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z);
        }
        oeh.extrude(worldGenRegion, random, x, y, z, this.doReplaceBlocks(), true);
        this.handleBO3Functions(null, null, worldGenRegion, random, rotation, x, y, z, chunks);
        return true;
    }

    public int getXOffset(Rotation rotation) {
        return -(this.settings.boundingBoxes[rotation.ordinal()].getMinX() + (int)Math.floor((float)this.settings.boundingBoxes[rotation.ordinal()].getWidth() / 2.0f));
    }

    public int getZOffset(Rotation rotation) {
        return -(this.settings.boundingBoxes[rotation.ordinal()].getMinZ() + (int)Math.floor((float)this.settings.boundingBoxes[rotation.ordinal()].getDepth() / 2.0f));
    }

    @Override
    public boolean spawnForced(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z, boolean allowReplaceBlocks) {
        BO3BlockFunction[] blocks = this.settings.getBlocks(rotation.getRotationId());
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        ReplaceBlockMatrix replaceBlocks = null;
        int lastX = Integer.MIN_VALUE;
        int lastZ = Integer.MIN_VALUE;
        for (BO3BlockFunction block : blocks) {
            if (allowReplaceBlocks && this.doReplaceBlocks()) {
                if (lastX != x + block.x || lastZ != z + block.z) {
                    replaceBlocks = worldGenRegion.getCachedBiomeProvider().getBiomeConfig(x + block.x, z + block.z, true).getReplaceBlocks();
                    lastX = x + block.x;
                    lastZ = z + block.z;
                }
                block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z, replaceBlocks);
            } else {
                block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z);
            }
            oeh.addBlock(block);
            chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
        }
        oeh.extrude(worldGenRegion, random, x, y, z, this.doReplaceBlocks(), true);
        this.handleBO3Functions(null, structureCache, worldGenRegion, random, rotation, x, y, z, chunks);
        return true;
    }

    @Override
    public boolean process(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random) {
        boolean atLeastOneObjectHasSpawned = false;
        int chunkMiddleX = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterX();
        int chunkMiddleZ = worldGenRegion.getDecorationArea().getChunkBeingDecoratedCenterZ();
        int spawned = 0;
        for (int i = 0; i < this.settings.frequency; ++i) {
            int z;
            int x;
            if (this.settings.rarity > random.nextDouble() * 100.0 && this.spawn(structureCache, worldGenRegion, random, x = chunkMiddleX + random.nextInt(16), z = chunkMiddleZ + random.nextInt(16), this.settings.minHeight, this.settings.maxHeight)) {
                ++spawned;
                atLeastOneObjectHasSpawned = true;
            }
            if (this.settings.maxSpawn > 0 && spawned == this.settings.maxSpawn) break;
        }
        return atLeastOneObjectHasSpawned;
    }

    @Override
    public boolean spawnAsTree(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, int x, int z, int minY, int maxY) {
        if (minY == -1) {
            minY = this.getConfig().minHeight;
        }
        if (maxY == -1) {
            maxY = this.getConfig().maxHeight;
        }
        return this.spawn(structureCache, worldGenRegion, random, x, z, minY, maxY);
    }

    private boolean spawn(CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, int x, int z, int minY, int maxY) {
        Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        int offsetY = 0;
        int baseY = 0;
        if (this.settings.getSpawnHeight() == BO3Enums.SpawnHeightEnum.randomY) {
            int n = baseY = minY == maxY ? minY : RandomHelper.numberInRange(random, minY, maxY);
        }
        if (this.settings.getSpawnHeight() == BO3Enums.SpawnHeightEnum.highestBlock) {
            baseY = worldGenRegion.getHighestBlockAboveYAt(x, z);
        }
        if (this.settings.getSpawnHeight() == BO3Enums.SpawnHeightEnum.highestSolidBlock) {
            baseY = worldGenRegion.getBlockAboveSolidHeight(x, z);
        }
        offsetY = baseY + this.getOffsetAndVariance(random, this.settings.getSpawnHeightOffset(), this.settings.spawnHeightVariance);
        return this.trySpawnAt(null, structureCache, worldGenRegion, random, rotation, x, offsetY, z, minY, maxY, baseY);
    }

    public boolean trySpawnAt(CustomStructure structure, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z, int minY, int maxY, int baseY) {
        BO3Check[] checks;
        if (y < 0 || y >= 256) {
            return false;
        }
        if (y < minY || y > maxY) {
            return false;
        }
        for (BO3Check bO3Check : checks = this.settings.bo3Checks[rotation.getRotationId()]) {
            if (!bO3Check.preventsSpawn(worldGenRegion, x + bO3Check.x, baseY + bO3Check.y, z + bO3Check.z)) continue;
            return false;
        }
        BO3BlockFunction[] blocks = this.settings.getBlocks(rotation.getRotationId());
        HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
        for (BO3BlockFunction block : blocks) {
            if (y + block.y < 0 || y + block.y >= 256) {
                return false;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z);
            if (loadedChunks.contains(chunkCoord)) continue;
            if (!worldGenRegion.getDecorationArea().isInAreaBeingDecorated(x + block.x, z + block.z)) {
                return false;
            }
            loadedChunks.add(chunkCoord);
        }
        ArrayList<BO3BlockFunction> arrayList = new ArrayList<BO3BlockFunction>();
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        int blocksOutsideSourceBlock = 0;
        int maxBlocksOutsideSourceBlock = (int)Math.ceil((double)blocks.length * ((double)this.settings.maxPercentageOutsideSourceBlock / 100.0));
        for (BO3BlockFunction block : blocks) {
            if ((this.settings.maxPercentageOutsideSourceBlock < 100 && blocksOutsideSourceBlock <= maxBlocksOutsideSourceBlock || this.settings.outsideSourceBlock == BO3Enums.OutsideSourceBlock.dontPlace) && !this.settings.sourceBlocks.contains(worldGenRegion.getMaterial(x + block.x, y + block.y, z + block.z))) {
                if (++blocksOutsideSourceBlock > maxBlocksOutsideSourceBlock) {
                    return false;
                }
                if (this.settings.outsideSourceBlock == BO3Enums.OutsideSourceBlock.placeAnyway) {
                    chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
                    arrayList.add(block);
                }
            } else {
                chunks.add(ChunkCoordinate.fromBlockCoords(x + block.x, z + block.z));
                arrayList.add(block);
            }
            if (!(block instanceof BO3BlockFunction)) continue;
            oeh.addBlock(block);
        }
        ReplaceBlockMatrix replaceBlocks = null;
        int lastX = Integer.MIN_VALUE;
        int lastZ = Integer.MIN_VALUE;
        for (BO3BlockFunction block : arrayList) {
            if (this.doReplaceBlocks()) {
                if (lastX != x + block.x || lastZ != z + block.z) {
                    replaceBlocks = worldGenRegion.getBiomeConfigForDecoration(x + block.x, z + block.z).getReplaceBlocks();
                    lastX = x + block.x;
                    lastZ = z + z + block.z;
                }
                block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z, replaceBlocks);
                continue;
            }
            block.spawn(worldGenRegion, random, x + block.x, y + block.y, z + block.z);
        }
        oeh.extrude(worldGenRegion, random, x, y, z, this.doReplaceBlocks(), false);
        this.handleBO3Functions(structure, structureCache, worldGenRegion, random, rotation, x, y, z, chunks);
        return true;
    }

    private void handleBO3Functions(CustomStructure structure, CustomStructureCache structureCache, IWorldGenRegion worldGenRegion, Random random, Rotation rotation, int x, int y, int z, HashSet<ChunkCoordinate> chunks) {
        HashSet chunksCustomObject = new HashSet();
        if (structure != null && structureCache != null) {
            for (ChunkCoordinate structureCoord : chunks) {
                structureCache.addBo3ToStructureCache(structureCoord, structure, true);
            }
        } else if (structureCache != null) {
            BO3CustomStructure placeHolderStructure = new BO3CustomStructure(new BO3CustomStructureCoordinate(worldGenRegion.getPresetFolderName(), this, this.getName(), Rotation.NORTH, x, 0, z));
            for (ChunkCoordinate structureCoord : chunksCustomObject) {
                structureCache.addBo3ToStructureCache(structureCoord, placeHolderStructure, false);
            }
        }
        BO3EntityFunction[] entityDataInObject = this.settings.entityFunctions[rotation.getRotationId()];
        for (BO3EntityFunction entity : entityDataInObject) {
            BO3EntityFunction newEntityData = new BO3EntityFunction();
            newEntityData.y = y + entity.y;
            newEntityData.x = x + entity.x;
            newEntityData.z = z + entity.z;
            newEntityData.name = entity.name;
            newEntityData.resourceLocation = entity.resourceLocation;
            newEntityData.groupSize = entity.groupSize;
            newEntityData.nameTagOrNBTFileName = entity.nameTagOrNBTFileName;
            newEntityData.originalNameTagOrNBTFileName = entity.originalNameTagOrNBTFileName;
            newEntityData.namedBinaryTag = entity.namedBinaryTag;
            newEntityData.rotation = entity.rotation;
            worldGenRegion.spawnEntity(newEntityData);
        }
    }

    public Branch[] getBranches(Rotation rotation) {
        return this.settings.branches[rotation.getRotationId()];
    }

    public BO3Enums.SpawnHeightEnum getStructurePartSpawnHeight() {
        return this.settings.getSpawnHeight();
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return this.settings.boundingBoxes[rotation.getRotationId()];
    }

    public int getMaxBranchDepth() {
        return this.settings.maxBranchDepth;
    }

    private int getOffsetAndVariance(Random random, int offset, int variance) {
        if (variance == 0) {
            return offset;
        }
        variance = variance < 0 ? -random.nextInt(MathHelper.abs(variance) + 1) : random.nextInt(variance + 1);
        return MathHelper.clamp(offset + variance, 0, 255);
    }

    public CustomStructureCoordinate makeCustomStructureCoordinate(String presetFolderName, boolean useOldBO3StructureRarity, Random random, int chunkX, int chunkZ) {
        if (!useOldBO3StructureRarity || this.settings.rarity > random.nextDouble() * 100.0) {
            Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
            int height = RandomHelper.numberInRange(random, this.settings.minHeight, this.settings.maxHeight);
            return new BO3CustomStructureCoordinate(presetFolderName, this, this.getName(), rotation, chunkX * 16 + 8 + random.nextInt(16), (short)height, chunkZ * 16 + 7 + random.nextInt(16));
        }
        return null;
    }

    @Override
    public boolean doReplaceBlocks() {
        return this.settings.doReplaceBlocks;
    }
}

