/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo3;

import com.pg85.otg.customobject.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.customobject.util.BO3Enums;
import com.pg85.otg.interfaces.IBiomeConfig;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.ArrayList;
import java.util.Random;

class ObjectExtrusionHelper {
    private int blockExtrusionY;
    private BO3Enums.ExtrudeMode extrudeMode;
    private MaterialSet extrudeThroughBlocks;
    private ArrayList<BO3BlockFunction> blocksToExtrude = new ArrayList();

    ObjectExtrusionHelper(BO3Enums.ExtrudeMode extrudeMode, MaterialSet extrudeThroughBlocks) {
        this.extrudeMode = extrudeMode;
        this.extrudeThroughBlocks = extrudeThroughBlocks;
        this.blockExtrusionY = extrudeMode.getStartingHeight();
    }

    void addBlock(BO3BlockFunction block) {
        if (this.extrudeMode != BO3Enums.ExtrudeMode.None) {
            if (this.extrudeMode == BO3Enums.ExtrudeMode.BottomDown && block.y < this.blockExtrusionY) {
                this.blocksToExtrude.clear();
                this.blockExtrusionY = block.y;
            } else if (this.extrudeMode == BO3Enums.ExtrudeMode.TopUp && block.y > this.blockExtrusionY) {
                this.blocksToExtrude.clear();
                this.blockExtrusionY = block.y;
            }
            if (block.y == this.blockExtrusionY) {
                this.blocksToExtrude.add(block);
            }
        }
    }

    void extrude(IWorldGenRegion worldGenRegion, Random random, int x, int y, int z, boolean replaceBlock, boolean forceSpawn) {
        for (BO3BlockFunction block : this.blocksToExtrude) {
            int yi;
            IBiomeConfig biomeConfig;
            IBiomeConfig iBiomeConfig = biomeConfig = forceSpawn ? worldGenRegion.getCachedBiomeProvider().getBiomeConfig(x + block.x, z + block.z, true) : worldGenRegion.getBiomeConfigForDecoration(x + block.x, z + block.z);
            if (this.extrudeMode == BO3Enums.ExtrudeMode.BottomDown) {
                for (yi = y + block.y - 1; yi > this.extrudeMode.getEndingHeight() && this.extrudeThroughBlocks.contains(worldGenRegion.getMaterial(x + block.x, yi, z + block.z)); --yi) {
                    if (replaceBlock) {
                        worldGenRegion.setBlock(x + block.x, yi, z + block.z, block.material, block.nbt, biomeConfig.getReplaceBlocks());
                        continue;
                    }
                    worldGenRegion.setBlock(x + block.x, yi, z + block.z, block.material, block.nbt);
                }
                continue;
            }
            if (this.extrudeMode != BO3Enums.ExtrudeMode.TopUp) continue;
            for (yi = y + block.y + 1; yi < this.extrudeMode.getEndingHeight() && this.extrudeThroughBlocks.contains(worldGenRegion.getMaterial(x + block.x, yi, z + block.z)); ++yi) {
                if (replaceBlock) {
                    worldGenRegion.setBlock(x + block.x, yi, z + block.z, block.material, block.nbt, biomeConfig.getReplaceBlocks());
                    continue;
                }
                worldGenRegion.setBlock(x + block.x, yi, z + block.z, block.material, block.nbt);
            }
        }
    }
}

