/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo3.bo3function;

import com.pg85.otg.customobject.bo3.BO3Config;
import com.pg85.otg.customobject.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.minecraft.BlockNames;
import com.pg85.otg.util.nbt.NBTHelper;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.util.List;
import java.util.Random;

public class BO3RandomBlockFunction
extends BO3BlockFunction {
    public LocalMaterialData[] blocks;
    public byte[] blockChances;
    public String[] metaDataNames;
    public NamedBinaryTag[] metaDataTags;
    public byte blockCount = 0;

    public BO3RandomBlockFunction() {
    }

    public BO3RandomBlockFunction(BO3Config holder) {
        super(holder);
    }

    @Override
    public BO3RandomBlockFunction rotate() {
        BO3RandomBlockFunction rotatedBlock = new BO3RandomBlockFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.blockCount = this.blockCount;
        rotatedBlock.blocks = new LocalMaterialData[this.blockCount];
        for (int i = 0; i < this.blockCount; ++i) {
            rotatedBlock.blocks[i] = this.blocks[i].rotate();
        }
        rotatedBlock.blockChances = this.blockChances;
        rotatedBlock.metaDataTags = this.metaDataTags;
        rotatedBlock.metaDataNames = this.metaDataNames;
        return rotatedBlock;
    }

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = (short)this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        int i = 3;
        int size = args.size();
        while (i < size) {
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.readInt(args.get(i), 1, 100);
            }
            ++i;
            this.blockCount = (byte)(this.blockCount + 1);
        }
        this.blocks = new LocalMaterialData[this.blockCount];
        this.blockChances = new byte[this.blockCount];
        this.metaDataNames = new String[this.blockCount];
        this.metaDataTags = new NamedBinaryTag[this.blockCount];
        i = 3;
        this.blockCount = 0;
        while (i < size) {
            this.blocks[this.blockCount] = materialReader.readMaterial(args.get(i));
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                NamedBinaryTag metaData = NBTHelper.loadMetadata(args.get(i), ((BO3Config)this.getHolder()).getFile(), logger);
                if (metaData != null) {
                    if (metaData.getTag("Items") != null) {
                        for (NamedBinaryTag item : (NamedBinaryTag[])metaData.getTag("Items").getValue()) {
                            if (item.getTag("id").getType() != NamedBinaryTag.Type.TAG_Short) continue;
                            short val = (Short)item.getTag("id").getValue();
                            item.removeSubTag(item.getTag("id"));
                            NamedBinaryTag[] newItemValue = new NamedBinaryTag[((NamedBinaryTag[])item.getValue()).length + 1];
                            System.arraycopy(item.getValue(), 0, newItemValue, 0, newItemValue.length - 1);
                            String strVal = "minecraft:" + BlockNames.blockNameFromLegacyBlockId(val);
                            newItemValue[newItemValue.length - 2] = new NamedBinaryTag(NamedBinaryTag.Type.TAG_String, "id", strVal);
                            newItemValue[newItemValue.length - 1] = new NamedBinaryTag(NamedBinaryTag.Type.TAG_End, "", (Object)null);
                            item.setValue(newItemValue);
                        }
                    }
                    if (metaData.getTag("SkullType") != null) {
                        byte val = (Byte)metaData.getTag("SkullType").getValue();
                        switch (val) {
                            case 1: {
                                this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:wither_skeleton_skull");
                                break;
                            }
                            case 2: {
                                this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:zombie_head");
                                break;
                            }
                            case 3: {
                                this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:player_head");
                                break;
                            }
                            case 4: {
                                this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:creeper_head");
                                break;
                            }
                            case 5: {
                                this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:dragon_head");
                                break;
                            }
                            default: {
                                this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:skeleton_skull");
                            }
                        }
                    }
                    if (metaData.getTag("Item") != null) {
                        String val;
                        if (metaData.getTag("Item").getType() == NamedBinaryTag.Type.TAG_String) {
                            val = (String)metaData.getTag("Item").getValue();
                            this.blocks[this.blockCount] = materialReader.readMaterial("minecraft:potted_" + val.split(":")[1]);
                        } else if (metaData.getTag("Item").getType() == NamedBinaryTag.Type.TAG_Int) {
                            val = materialReader.readMaterial(Integer.toString((Integer)metaData.getTag("Item").getValue())).getName();
                            this.blocks[this.blockCount] = val.split(":").length > 1 ? materialReader.readMaterial("minecraft:potted_" + val.split(":")[1]) : materialReader.readMaterial("minecraft:potted_" + val);
                        }
                    }
                    this.metaDataNames[this.blockCount] = args.get(i);
                    this.metaDataTags[this.blockCount] = metaData;
                }
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            ++i;
            this.blockCount = (byte)(this.blockCount + 1);
        }
    }

    @Override
    public String makeString() {
        String text = "RB(" + this.x + "," + this.y + "," + this.z;
        for (int i = 0; i < this.blockCount; ++i) {
            text = this.metaDataTags[i] == null ? text + "," + this.blocks[i] + "," + this.blockChances[i] : text + "," + this.blocks[i] + "," + this.metaDataNames[i] + "," + this.blockChances[i];
        }
        return text + ")";
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random random, int x, int y, int z) {
        for (int i = 0; i < this.blockCount; ++i) {
            if (random.nextInt(100) >= this.blockChances[i]) continue;
            worldGenRegion.setBlock(x, y, z, this.blocks[i], this.metaDataTags[i]);
            break;
        }
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random random, int x, int y, int z, ReplaceBlockMatrix replaceBlocks) {
        for (int i = 0; i < this.blockCount; ++i) {
            if (random.nextInt(100) >= this.blockChances[i]) continue;
            worldGenRegion.setBlock(x, y, z, this.blocks[i], this.metaDataTags[i], replaceBlocks);
            break;
        }
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }
}

