/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo3.checks;

import com.pg85.otg.customobject.bo3.BO3Config;
import com.pg85.otg.customobject.bo3.checks.BO3Check;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;

public class BlockCheck
extends BO3Check {
    MaterialSet toCheck;

    @Override
    public boolean preventsSpawn(IWorldGenRegion worldGenregion, int x, int y, int z) {
        return y > 0 && y < 256 && !this.toCheck.contains(worldGenregion.getMaterial(x, y, z));
    }

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        this.toCheck = this.readMaterials(args, 3, materialReader);
    }

    public BlockCheck() {
    }

    public BlockCheck(int x, int y, int z, MaterialSet toCheck) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.toCheck = toCheck;
    }

    @Override
    public String makeString() {
        return this.makeString("BlockCheck");
    }

    protected String makeString(String name) {
        return name + '(' + this.x + ',' + this.y + ',' + this.z + this.makeMaterials(this.toCheck) + ')';
    }

    @Override
    public BO3Check rotate() {
        BlockCheck rotatedCheck = new BlockCheck();
        rotatedCheck.x = this.z;
        rotatedCheck.y = this.y;
        rotatedCheck.z = -this.x;
        rotatedCheck.toCheck = this.toCheck.rotate();
        return rotatedCheck;
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }
}

