/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo3.checks;

import com.pg85.otg.customobject.bo3.BO3Config;
import com.pg85.otg.customobject.bo3.checks.BO3Check;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import java.util.List;

public class LightCheck
extends BO3Check {
    private int minLightLevel;
    private int maxLightLevel;

    @Override
    public boolean preventsSpawn(IWorldGenRegion worldGenRegion, int x, int y, int z) {
        int lightLevel = worldGenRegion.getLightLevel(x, y, z);
        return lightLevel < this.minLightLevel || lightLevel > this.maxLightLevel;
    }

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        this.minLightLevel = this.readInt(args.get(3), 0, 16);
        this.maxLightLevel = this.readInt(args.get(4), this.minLightLevel, 16);
    }

    @Override
    public String makeString() {
        return "LightCheck(" + this.x + ',' + this.y + ',' + this.z + ',' + this.minLightLevel + ',' + this.maxLightLevel + ')';
    }

    @Override
    public BO3Check rotate() {
        LightCheck rotatedCheck = new LightCheck();
        rotatedCheck.x = this.z;
        rotatedCheck.y = this.y;
        rotatedCheck.z = -this.x;
        rotatedCheck.minLightLevel = this.minLightLevel;
        rotatedCheck.maxLightLevel = this.maxLightLevel;
        return rotatedCheck;
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }
}

