/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo4.bo4function;

import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.nbt.NBTHelper;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;

public class BO4RandomBlockFunction
extends BO4BlockFunction {
    public LocalMaterialData[] blocks;
    public byte[] blockChances;
    public String[] metaDataNames;
    public NamedBinaryTag[] metaDataTags;
    public byte blockCount = 0;

    public BO4RandomBlockFunction() {
    }

    public BO4RandomBlockFunction(BO4Config holder) {
        super(holder);
    }

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = (short)this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        int i = 3;
        int size = args.size();
        while (i < size) {
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.readInt(args.get(i), 1, 100);
            }
            ++i;
            this.blockCount = (byte)(this.blockCount + 1);
        }
        this.blocks = new LocalMaterialData[this.blockCount];
        this.blockChances = new byte[this.blockCount];
        this.metaDataNames = new String[this.blockCount];
        this.metaDataTags = new NamedBinaryTag[this.blockCount];
        i = 3;
        this.blockCount = 0;
        while (i < size) {
            this.blocks[this.blockCount] = materialReader.readMaterial(args.get(i));
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                NamedBinaryTag metaData = NBTHelper.loadMetadata(args.get(i), ((BO4Config)this.getHolder()).getFile(), logger);
                if (metaData != null) {
                    this.metaDataNames[this.blockCount] = args.get(i);
                    this.metaDataTags[this.blockCount] = metaData;
                }
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            ++i;
            this.blockCount = (byte)(this.blockCount + 1);
        }
    }

    @Override
    public BO4RandomBlockFunction rotate(Rotation rotation) {
        BO4RandomBlockFunction rotatedBlock = new BO4RandomBlockFunction((BO4Config)this.getHolder());
        BO4CustomStructureCoordinate rotatedCoords = BO4CustomStructureCoordinate.getRotatedBO3CoordsJustified(this.x, this.y, this.z, rotation);
        rotatedBlock.x = rotatedCoords.getX();
        rotatedBlock.y = rotatedCoords.getY();
        rotatedBlock.z = rotatedCoords.getZ();
        rotatedBlock.blocks = this.blocks;
        LocalMaterialData[] rotatedBlockBlocks = new LocalMaterialData[this.blockCount];
        for (int a = 0; a < this.blockCount; ++a) {
            rotatedBlockBlocks[a] = rotatedBlock.blocks[a];
            if (rotation.getRotationId() == 3) {
                rotatedBlockBlocks[a] = rotatedBlockBlocks[a].rotate(1);
            }
            if (rotation.getRotationId() == 2) {
                rotatedBlockBlocks[a] = rotatedBlockBlocks[a].rotate(2);
            }
            if (rotation.getRotationId() != 1) continue;
            rotatedBlockBlocks[a] = rotatedBlockBlocks[a].rotate(3);
        }
        rotatedBlock.blocks = rotatedBlockBlocks;
        rotatedBlock.blockCount = this.blockCount;
        rotatedBlock.blockChances = this.blockChances;
        rotatedBlock.nbt = this.nbt;
        rotatedBlock.metaDataTags = this.metaDataTags;
        rotatedBlock.nbtName = this.nbtName;
        rotatedBlock.metaDataNames = this.metaDataNames;
        return rotatedBlock;
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random random, int x, int y, int z) {
        for (int i = 0; i < this.blockCount; ++i) {
            if (random.nextInt(100) >= this.blockChances[i]) continue;
            worldGenRegion.setBlock(x, y, z, this.blocks[i], this.metaDataTags[i]);
            break;
        }
    }

    @Override
    public void spawn(IWorldGenRegion worldGenRegion, Random random, int x, int y, int z, ReplaceBlockMatrix replaceBlocks) {
        for (int i = 0; i < this.blockCount; ++i) {
            if (random.nextInt(100) >= this.blockChances[i]) continue;
            worldGenRegion.setBlock(x, y, z, this.blocks[i], this.metaDataTags[i], replaceBlocks);
            break;
        }
    }

    @Override
    public String makeString() {
        String text = "RandomBlock(" + this.x + "," + this.y + "," + this.z;
        for (int i = 0; i < this.blockCount; ++i) {
            text = this.metaDataTags[i] == null ? text + "," + this.blocks[i] + "," + this.blockChances[i] : text + "," + this.blocks[i] + "," + this.metaDataNames[i] + "," + this.blockChances[i];
        }
        return text + ")";
    }

    @Override
    public Class<BO4Config> getHolderType() {
        return BO4Config.class;
    }

    @Override
    public void writeToStream(String[] metaDataNames, LocalMaterialData[] materials, DataOutput stream) throws IOException {
        int i;
        int j;
        boolean bFound;
        stream.writeShort(this.y);
        stream.writeByte(this.blocks.length);
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            byte blockChance = this.blockChances[i2];
            stream.writeByte(blockChance);
            bFound = false;
            if (this.blocks[i2] != null) {
                for (j = 0; j < materials.length; ++j) {
                    if (!materials[j].equals(this.blocks[i2])) continue;
                    stream.writeShort(j);
                    bFound = true;
                    break;
                }
            }
            if (bFound) continue;
            stream.writeShort(-1);
        }
        boolean metaDataFound = false;
        for (i = 0; i < this.metaDataNames.length; ++i) {
            if (this.metaDataNames[i] == null) continue;
            metaDataFound = true;
            break;
        }
        if (metaDataFound) {
            stream.writeByte(this.blocks.length);
            for (i = 0; i < this.metaDataNames.length; ++i) {
                bFound = false;
                if (this.metaDataNames[i] != null) {
                    for (j = 0; j < metaDataNames.length; ++j) {
                        if (!metaDataNames[j].equals(this.metaDataNames[i])) continue;
                        stream.writeShort(i);
                        bFound = true;
                        break;
                    }
                }
                if (bFound) continue;
                stream.writeShort(-1);
            }
        } else {
            stream.writeByte(0);
        }
    }

    public static BO4RandomBlockFunction fromStream(int x, int z, String[] metaDataNames, LocalMaterialData[] materials, BO4Config holder, ByteBuffer buffer, ILogger logger) throws IOException {
        int i;
        int blocksLength;
        BO4RandomBlockFunction rbf = new BO4RandomBlockFunction(holder);
        File file = holder.getFile();
        rbf.x = x;
        rbf.y = buffer.getShort();
        rbf.z = z;
        rbf.blockCount = blocksLength = buffer.get();
        rbf.blocks = new LocalMaterialData[blocksLength];
        rbf.blockChances = new byte[blocksLength];
        rbf.metaDataNames = new String[blocksLength];
        rbf.metaDataTags = new NamedBinaryTag[blocksLength];
        for (i = 0; i < blocksLength; ++i) {
            rbf.blockChances[i] = buffer.get();
            short materialId = buffer.getShort();
            if (materialId == -1) continue;
            rbf.blocks[i] = materials[materialId];
        }
        blocksLength = buffer.get();
        for (i = 0; i < blocksLength; ++i) {
            short metaDataNameId = buffer.getShort();
            if (metaDataNameId != -1) {
                rbf.metaDataNames[i] = metaDataNames[metaDataNameId];
            }
            if (rbf.metaDataNames[i] == null) continue;
            NamedBinaryTag metaData = NBTHelper.loadMetadata(rbf.metaDataNames[i], file, logger);
            if (metaData != null) {
                rbf.metaDataTags[i] = metaData;
                continue;
            }
            rbf.metaDataNames[i] = null;
        }
        return rbf;
    }
}

