/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bo4.bo4function;

import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bo4.bo4function.BO4BranchFunction;
import com.pg85.otg.customobject.bo4.bo4function.BO4BranchNode;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.CustomStructureCoordinate;
import com.pg85.otg.customobject.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.StreamHelper;
import com.pg85.otg.util.helpers.StringHelper;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class BO4WeightedBranchFunction
extends BO4BranchFunction {
    private double cumulativeChance = 0.0;

    public BO4WeightedBranchFunction() {
    }

    private BO4WeightedBranchFunction(BO4Config holder) {
        super(holder);
    }

    @Override
    protected double readArgs(List<String> args, boolean accumulateChances, ILogger logger) throws InvalidConfigException {
        String totalChanceOrBranchGroup;
        int i;
        double cumulativeChance = 0.0;
        this.assureSize(8, args);
        this.x = this.readInt(args.get(0), -32, 32);
        this.y = this.readInt(args.get(1), -255, 255);
        this.z = this.readInt(args.get(2), -32, 32);
        this.isRequiredBranch = this.readBoolean(args.get(3));
        for (i = 4; i < args.size() - 3; i += 4) {
            double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
            this.branchesBO4.add(new BO4BranchNode(this.readInt(args.get(i + 3), -32, 32), this.isRequiredBranch, true, Rotation.getRotation(args.get(i + 1)), branchChance, null, args.get(i), null));
        }
        if (i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
            try {
                Double.parseDouble(totalChanceOrBranchGroup);
                this.totalChanceSet = true;
                this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
                ++i;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
            this.branchGroup = args.get(i);
            for (BO4BranchNode branch : this.branchesBO4) {
                branch.branchGroup = this.branchGroup;
            }
        }
        return cumulativeChance;
    }

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.branchesBO4 = new ArrayList();
        this.cumulativeChance = this.readArgs(args, true, logger);
    }

    @Override
    public CustomStructureCoordinate toCustomObjectCoordinate(String presetFolderName, Random random, Rotation rotation, int x, int y, int z, String startBO3Name, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        int cumulativeChance = 0;
        for (BO4BranchNode branch : this.branchesBO4) {
            cumulativeChance = (int)((double)cumulativeChance + branch.getChance());
        }
        if ((double)cumulativeChance > this.totalChance) {
            this.totalChance = cumulativeChance;
        }
        double randomChance = random.nextDouble() * this.totalChance;
        for (BO4BranchNode branch : this.branchesBO4) {
            double branchRarity = branch.getChance();
            if (branchRarity > 0.0 && branchRarity >= randomChance) {
                BO4CustomStructureCoordinate rotatedCoords = BO4CustomStructureCoordinate.getRotatedCoord(this.x, this.y, this.z, rotation);
                Rotation newRotation = Rotation.getRotation((rotation.getRotationId() + branch.getRotation().getRotationId()) % 4);
                return new BO4CustomStructureCoordinate(presetFolderName, branch.getCustomObject(false, presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker), branch.customObjectName, newRotation, x + rotatedCoords.getX(), (short)(y + rotatedCoords.getY()), z + rotatedCoords.getZ(), branch.branchDepth, branch.isRequiredBranch, true, branch.branchGroup);
            }
            if (!((randomChance -= branch.getChance()) < 0.0)) continue;
            randomChance = 0.0;
        }
        return null;
    }

    @Override
    public BO4WeightedBranchFunction rotate(Rotation rotation, String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        BO4WeightedBranchFunction rotatedBranch = new BO4WeightedBranchFunction((BO4Config)this.getHolder());
        rotatedBranch.x = this.x;
        rotatedBranch.y = this.y;
        rotatedBranch.z = this.z;
        rotatedBranch.totalChance = this.totalChance;
        rotatedBranch.totalChanceSet = this.totalChanceSet;
        rotatedBranch.branchGroup = this.branchGroup;
        rotatedBranch.isRequiredBranch = this.isRequiredBranch;
        rotatedBranch.cumulativeChance = this.cumulativeChance;
        rotatedBranch.holder = this.holder;
        rotatedBranch.valid = this.valid;
        rotatedBranch.inputName = this.inputName;
        rotatedBranch.inputArgs = this.inputArgs;
        rotatedBranch.error = this.error;
        rotatedBranch.branchesBO4 = this.branchesBO4;
        int newX = rotatedBranch.x;
        int newZ = rotatedBranch.z;
        for (int i = 0; i < rotation.getRotationId(); ++i) {
            newX = rotatedBranch.z;
            newZ = -rotatedBranch.x;
            rotatedBranch.x = newX;
            rotatedBranch.y = rotatedBranch.y;
            rotatedBranch.z = newZ;
            ArrayList<BO4BranchNode> rotatedBranchBranches = new ArrayList<BO4BranchNode>();
            for (BO4BranchNode holder : rotatedBranch.branchesBO4) {
                rotatedBranchBranches.add(new BO4BranchNode(holder.branchDepth, holder.isRequiredBranch, holder.isWeightedBranch, holder.getRotation().next(), holder.getChance(), holder.getCustomObject(false, presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker), holder.customObjectName, holder.branchGroup));
            }
            rotatedBranch.branchesBO4 = rotatedBranchBranches;
        }
        return rotatedBranch;
    }

    @Override
    protected String getConfigName() {
        return "WeightedBranch";
    }

    @Override
    public Class<BO4Config> getHolderType() {
        return BO4Config.class;
    }

    @Override
    public void writeToStream(DataOutput stream) throws IOException {
        StreamHelper.writeStringToStream(stream, this.makeString());
    }

    public static BO4WeightedBranchFunction fromStream(BO4Config holder, ByteBuffer buffer, ILogger logger, IMaterialReader materialReader) throws IOException, InvalidConfigException {
        BO4WeightedBranchFunction branchFunction = new BO4WeightedBranchFunction(holder);
        String configFunctionString = StreamHelper.readStringFromBuffer(buffer);
        int bracketIndex = configFunctionString.indexOf(40);
        String parameters = configFunctionString.substring(bracketIndex + 1, configFunctionString.length() - 1);
        List<String> args = Arrays.asList(StringHelper.readCommaSeperatedString(parameters));
        branchFunction.load(args, logger, materialReader);
        return branchFunction;
    }
}

