/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bofunctions;

import com.pg85.otg.customobject.config.CustomObjectConfigFile;
import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IWorldGenRegion;
import com.pg85.otg.util.biome.ReplaceBlockMatrix;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.minecraft.BlockNames;
import com.pg85.otg.util.nbt.NBTHelper;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.util.List;
import java.util.Random;

public abstract class BlockFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public LocalMaterialData material;
    public short y;
    public NamedBinaryTag nbt;
    public String nbtName;

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = (short)this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.material = this.readMaterial(args.get(3), materialReader);
        if (this.material == null) {
            throw new InvalidConfigException("Material \"" + args.get(3) + "\" could not be read.");
        }
        if (args.size() >= 5) {
            this.nbt = NBTHelper.loadMetadata(args.get(4), ((CustomObjectConfigFile)this.getHolder()).getFile(), logger);
            if (this.nbt != null) {
                if (this.nbt.getTag("Items") != null) {
                    for (NamedBinaryTag item : (NamedBinaryTag[])this.nbt.getTag("Items").getValue()) {
                        if (item.getTag("id").getType() != NamedBinaryTag.Type.TAG_Short) continue;
                        short val = (Short)item.getTag("id").getValue();
                        item.removeSubTag(item.getTag("id"));
                        NamedBinaryTag[] newItemValue = new NamedBinaryTag[((NamedBinaryTag[])item.getValue()).length + 1];
                        System.arraycopy(item.getValue(), 0, newItemValue, 0, newItemValue.length - 1);
                        String strVal = "minecraft:" + BlockNames.blockNameFromLegacyBlockId(val);
                        newItemValue[newItemValue.length - 2] = new NamedBinaryTag(NamedBinaryTag.Type.TAG_String, "id", strVal);
                        newItemValue[newItemValue.length - 1] = new NamedBinaryTag(NamedBinaryTag.Type.TAG_End, "", (Object)null);
                        item.setValue(newItemValue);
                    }
                }
                if (this.nbt.getTag("SkullType") != null) {
                    byte val = (Byte)this.nbt.getTag("SkullType").getValue();
                    switch (val) {
                        case 1: {
                            this.material = materialReader.readMaterial("minecraft:wither_skeleton_skull");
                            break;
                        }
                        case 2: {
                            this.material = materialReader.readMaterial("minecraft:zombie_head");
                            break;
                        }
                        case 3: {
                            this.material = materialReader.readMaterial("minecraft:player_head");
                            break;
                        }
                        case 4: {
                            this.material = materialReader.readMaterial("minecraft:creeper_head");
                            break;
                        }
                        case 5: {
                            this.material = materialReader.readMaterial("minecraft:dragon_head");
                            break;
                        }
                        default: {
                            this.material = materialReader.readMaterial("minecraft:skeleton_skull");
                        }
                    }
                }
                if (this.nbt.getTag("Item") != null) {
                    String val;
                    if (this.nbt.getTag("Item").getType() == NamedBinaryTag.Type.TAG_String) {
                        val = (String)this.nbt.getTag("Item").getValue();
                        String[] vals = val.split(":");
                        this.material = materialReader.readMaterial("minecraft:potted_" + (vals.length > 1 ? vals[1] : val));
                    } else if (this.nbt.getTag("Item").getType() == NamedBinaryTag.Type.TAG_Int) {
                        val = materialReader.readMaterial(Integer.toString((Integer)this.nbt.getTag("Item").getValue())).getName();
                        this.material = val.split(":").length > 1 ? materialReader.readMaterial("minecraft:potted_" + val.split(":")[1]) : materialReader.readMaterial("minecraft:potted_" + val);
                    }
                }
                this.nbtName = args.get(4);
            }
        }
    }

    @Override
    public String makeString() {
        String start = "B(" + this.x + ',' + this.y + ',' + this.z + ',' + this.material;
        if (this.nbt != null) {
            start = start + ',' + this.nbtName;
        }
        return start + ')';
    }

    public abstract void spawn(IWorldGenRegion var1, Random var2, int var3, int var4, int var5);

    public abstract void spawn(IWorldGenRegion var1, Random var2, int var3, int var4, int var5, ReplaceBlockMatrix var6);

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BlockFunction block = (BlockFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

