/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bofunctions;

import com.pg85.otg.customobject.bofunctions.BranchNode;
import com.pg85.otg.customobject.config.CustomObjectConfigFile;
import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.customobject.structures.Branch;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class BranchFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T>
implements Branch {
    protected int y;
    protected SortedSet<BranchNode> branches;
    protected double totalChance = 100.0;
    protected boolean totalChanceSet = false;

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.branches = new TreeSet<BranchNode>();
        this.readArgs(args, false, logger);
    }

    @Override
    public String makeString() {
        StringBuilder output = new StringBuilder(this.getConfigName()).append('(').append(this.x).append(',').append(this.y).append(',').append(this.z);
        Iterator it = this.branches.iterator();
        while (it.hasNext()) {
            output.append(((BranchNode)it.next()).toBranchString());
        }
        if (this.totalChanceSet) {
            output.append(',').append(this.totalChance);
        }
        return output.append(')').toString();
    }

    protected String getConfigName() {
        return "Branch";
    }

    protected abstract double readArgs(List<String> var1, boolean var2, ILogger var3) throws InvalidConfigException;

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BranchFunction branch = (BranchFunction)other;
        return branch.x == this.x && branch.y == this.y && branch.z == this.z;
    }
}

