/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bofunctions;

import com.pg85.otg.customobject.CustomObject;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.util.bo3.Rotation;
import java.nio.file.Path;

public class BranchNode
implements Comparable<BranchNode> {
    protected Rotation rotation;
    protected double chance;
    protected StructuredCustomObject customObject;
    public String customObjectName;

    protected BranchNode() {
    }

    public BranchNode(Rotation rotation, double chance, StructuredCustomObject branch, String customObjectName) {
        this.rotation = rotation;
        this.chance = chance;
        this.customObject = branch;
        this.customObjectName = branch != null ? branch.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
    }

    public double getChance() {
        return this.chance;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public StructuredCustomObject getCustomObject(boolean lazyLoad, String presetFolderName, Path otgRootFolder, ILogger logger, CustomObjectManager customObjectManager, IMaterialReader materialReader, CustomObjectResourcesManager manager, IModLoadedChecker modLoadedChecker) {
        if (this.customObject != null || !lazyLoad) {
            return this.customObject;
        }
        CustomObject customObject = customObjectManager.getGlobalObjects().getObjectByName(this.customObjectName, presetFolderName, otgRootFolder, logger, customObjectManager, materialReader, manager, modLoadedChecker);
        if (customObject != null && !(customObject instanceof StructuredCustomObject)) {
            customObject = null;
        }
        this.customObjectName = customObject != null ? customObject.getName() : null;
        return (StructuredCustomObject)customObject;
    }

    protected String toBranchString() {
        return ',' + this.customObjectName + ',' + this.rotation.name() + ',' + this.chance;
    }

    @Override
    public int compareTo(BranchNode that) {
        return (int)(this.chance - that.chance);
    }
}

