/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.bofunctions;

import com.pg85.otg.customobject.config.CustomObjectConfigFile;
import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.IEntityFunction;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.minecraft.EntityNames;
import com.pg85.otg.util.nbt.NamedBinaryTag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public abstract class EntityFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T>
implements IEntityFunction {
    public int y;
    public String name = "";
    public int groupSize = 1;
    public String nameTagOrNBTFileName = "";
    public String originalNameTagOrNBTFileName = "";
    public String resourceLocation = "";
    public NamedBinaryTag namedBinaryTag = null;
    public int rotation = 0;
    private String metaDataTag;

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public int getGroupSize() {
        return this.groupSize;
    }

    @Override
    public String getNameTagOrNBTFileName() {
        return this.nameTagOrNBTFileName;
    }

    @Override
    public String getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public NamedBinaryTag getNBTTag() {
        return this.namedBinaryTag;
    }

    @Override
    public void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.processEntityName(args.get(3), logger);
        this.groupSize = this.readInt(args.get(4), 0, Integer.MAX_VALUE);
        if (args.size() > 5) {
            this.processNameTagOrFileName(args.get(5), logger);
        }
    }

    public void processEntityName(String name, ILogger logger) {
        if (name == null) {
            return;
        }
        if (name.contains(":")) {
            this.resourceLocation = name.toLowerCase().trim();
        } else {
            this.resourceLocation = EntityNames.toInternalName(name);
            if (!this.resourceLocation.contains(":") && logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not find entity '" + name + "', are you sure you spelled it correctly?");
            }
        }
        this.name = this.resourceLocation.split(":")[1];
    }

    public void processNameTagOrFileName(String s, ILogger logger) {
        this.originalNameTagOrNBTFileName = s;
        if (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt")) {
            this.nameTagOrNBTFileName = ((CustomObjectConfigFile)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalNameTagOrNBTFileName;
        } else if (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt")) {
            this.nameTagOrNBTFileName = ((CustomObjectConfigFile)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalNameTagOrNBTFileName;
            if (this.namedBinaryTag == null) {
                try {
                    FileInputStream stream = new FileInputStream(this.nameTagOrNBTFileName);
                    this.namedBinaryTag = NamedBinaryTag.readFrom(stream, true);
                }
                catch (FileNotFoundException e) {
                    if (logger.getLogCategoryEnabled(LogCategory.CUSTOM_OBJECTS)) {
                        logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, "Could not find file: " + this.nameTagOrNBTFileName);
                    }
                    this.nameTagOrNBTFileName = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.nameTagOrNBTFileName = this.originalNameTagOrNBTFileName;
        }
    }

    @Override
    public String makeString() {
        return "Entity(" + this.x + ',' + this.y + ',' + this.z + ',' + this.resourceLocation + ',' + this.groupSize + (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.length() > 0 ? ',' + this.originalNameTagOrNBTFileName : "") + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMetaData() {
        if (this.nameTagOrNBTFileName != null && this.nameTagOrNBTFileName.length() > 0 && this.metaDataTag == null) {
            File metaDataFile = new File(this.nameTagOrNBTFileName);
            StringBuilder stringbuilder = new StringBuilder();
            if (metaDataFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(metaDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.metaDataTag = stringbuilder.toString();
        }
        return this.metaDataTag;
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        EntityFunction block = (EntityFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.resourceLocation.equalsIgnoreCase(this.resourceLocation) && block.groupSize == this.groupSize && block.originalNameTagOrNBTFileName.equalsIgnoreCase(this.originalNameTagOrNBTFileName);
    }

    public abstract EntityFunction<T> createNewInstance();
}

