/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.config;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.SettingsReaderBO4;
import com.pg85.otg.customobject.config.io.SettingsWriterBO4;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ICustomObjectManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public abstract class CustomObjectConfigFile {
    public SettingsReaderBO4 reader;
    public SettingsEnums.ConfigMode settingsMode;

    protected CustomObjectConfigFile(SettingsReaderBO4 reader) throws IllegalArgumentException {
        this.reader = reader;
    }

    protected <T> T readSettings(Setting<T> setting, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        return this.readSettings(setting, setting.getDefaultValue(materialReader), logger, materialReader, manager);
    }

    private <T> T readSettings(Setting<T> setting, T defaultValue, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        return this.reader.getSetting(setting, defaultValue, logger, materialReader, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SettingsWriterBO4 writer, SettingsEnums.ConfigMode configMode, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) throws IOException {
        if (configMode == SettingsEnums.ConfigMode.WriteDisable) {
            throw new IOException("ConfigMode is " + (Object)((Object)SettingsEnums.ConfigMode.WriteDisable));
        }
        writer.setConfigMode(configMode);
        try {
            writer.open();
            this.writeConfigSettings(writer, logger, materialReader, manager);
        }
        finally {
            writer.close(logger);
        }
    }

    protected abstract void writeConfigSettings(SettingsWriterBO4 var1, ILogger var2, IMaterialReader var3, CustomObjectResourcesManager var4) throws IOException;

    protected abstract void readConfigSettings(String var1, Path var2, ILogger var3, ICustomObjectManager var4, IMaterialReader var5, CustomObjectResourcesManager var6, IModLoadedChecker var7) throws InvalidConfigException;

    protected abstract void correctSettings();

    protected abstract void renameOldSettings();

    public String getName() {
        return this.reader.getName();
    }

    public File getFile() {
        return this.reader.getFile();
    }

    public abstract BlockFunction<?>[] getBlockFunctions(String var1, Path var2, ILogger var3, ICustomObjectManager var4, IMaterialReader var5, CustomObjectResourcesManager var6, IModLoadedChecker var7);
}

