/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.config;

import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.ArrayList;
import java.util.List;

public abstract class CustomObjectConfigFunction<T> {
    public int x;
    public int z;
    protected T holder;
    protected String error;
    protected List<String> inputArgs;
    protected String inputName;
    protected boolean valid = true;

    public static final <T> CustomObjectConfigFunction<T> create(T holder, Class<? extends CustomObjectConfigFunction<T>> clazz, ILogger logger, IMaterialReader materialReader, Object ... args) {
        CustomObjectConfigFunction<T> configFunction;
        ArrayList<String> stringArgs = new ArrayList<String>(args.length);
        for (Object arg : args) {
            stringArgs.add("" + arg);
        }
        try {
            configFunction = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        configFunction.setHolder(holder);
        try {
            configFunction.load(stringArgs, logger, materialReader);
        }
        catch (InvalidConfigException e) {
            logger.log(LogLevel.ERROR, LogCategory.CUSTOM_OBJECTS, String.format("Invalid default config function, please report this to team OTG. Class: " + clazz.getName() + ". Error: ", e.getStackTrace()));
        }
        return configFunction;
    }

    protected final void assureSize(int size, List<String> args) throws InvalidConfigException {
        if (args.size() < size) {
            throw new InvalidConfigException("Too few arguments supplied");
        }
    }

    public final String getError() throws IllegalStateException {
        if (this.isValid()) {
            throw new IllegalStateException("Function is valid, so no error");
        }
        return this.error;
    }

    public final T getHolder() {
        return this.holder;
    }

    public abstract Class<T> getHolderType();

    final void init(T holder, List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        this.holder = holder;
        this.load(args, logger, materialReader);
    }

    final void invalidate(String name, List<String> args, String error) {
        this.valid = false;
        this.inputName = name;
        this.inputArgs = args;
        this.error = error;
    }

    public abstract boolean isAnalogousTo(CustomObjectConfigFunction<T> var1);

    public final boolean isValid() {
        return this.valid;
    }

    protected abstract void load(List<String> var1, ILogger var2, IMaterialReader var3) throws InvalidConfigException;

    protected final String makeMaterials(MaterialSet materials) {
        return "," + materials.toString();
    }

    public abstract String makeString();

    protected final double readDouble(String string, double minValue, double maxValue) throws InvalidConfigException {
        return StringHelper.readDouble(string, minValue, maxValue);
    }

    protected final int readInt(String string, int minValue, int maxValue) throws InvalidConfigException {
        return StringHelper.readInt(string, minValue, maxValue);
    }

    protected final boolean readBoolean(String string) {
        return Boolean.parseBoolean(string);
    }

    protected final LocalMaterialData readMaterial(String string, IMaterialReader materialReader) throws InvalidConfigException {
        return materialReader.readMaterial(string);
    }

    protected final MaterialSet readMaterials(List<String> strings, int start, IMaterialReader materialReader) throws InvalidConfigException {
        MaterialSet materials = new MaterialSet();
        for (int i = start; i < strings.size(); ++i) {
            materials.parseAndAdd(strings.get(i), materialReader);
        }
        return materials;
    }

    public final void setHolder(T holder) {
        this.holder = holder;
    }

    @Deprecated
    public final void setValid(boolean valid) {
        if (!valid) {
            throw new UnsupportedOperationException("Use the invalidate method");
        }
        if (valid && !this.isValid()) {
            throw new UnsupportedOperationException("Revalidating objects is no longer supported");
        }
    }

    public final String write() {
        if (!this.valid) {
            return "## INVALID " + this.inputName.toUpperCase() + " - " + this.error + " ##" + System.getProperty("line.separator") + this.inputName + "(" + StringHelper.join(this.inputArgs, ",") + ")";
        }
        return this.makeString();
    }
}

