/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.config;

import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.List;

public final class CustomObjectErroredFunction<T>
extends CustomObjectConfigFunction<T> {
    private final Class<T> holder;
    private final String name;
    private final List<String> args;

    CustomObjectErroredFunction(String name, T holder, List<String> args, String error) {
        Class<?> holderClass = holder.getClass();
        this.holder = holderClass;
        this.name = name;
        this.args = args;
        this.invalidate(name, args, error);
    }

    @Override
    public Class<T> getHolderType() {
        return this.holder;
    }

    @Override
    protected void load(List<String> args, ILogger logger, IMaterialReader materialReader) throws InvalidConfigException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String makeString() {
        return this.name + "(" + StringHelper.join(this.args, ",") + ")";
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        return this == other;
    }
}

