/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.config;

import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.customobject.config.CustomObjectErroredFunction;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ICustomObjectResourcesManager;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomObjectResourcesManager
implements ICustomObjectResourcesManager {
    private Map<String, ArrayList<Class<? extends CustomObjectConfigFunction<?>>>> configFunctions = new HashMap();

    public void registerConfigFunction(String name, Class<? extends CustomObjectConfigFunction<?>> value) {
        ArrayList<Class<CustomObjectConfigFunction<Object>>> list = this.configFunctions.get(name.toLowerCase());
        if (list == null) {
            list = new ArrayList();
            this.configFunctions.put(name.toLowerCase(), list);
        }
        list.add(value);
    }

    public <T> CustomObjectConfigFunction<T> getConfigFunction(String name, T holder, List<String> args, ILogger logger, IMaterialReader materialReader) {
        ArrayList<Class<CustomObjectConfigFunction<?>>> clazzes;
        if (name.toLowerCase().trim().equals("block") && args.size() > 5) {
            name = "RandomBlock";
        }
        if ((clazzes = this.configFunctions.get(name.toLowerCase())) == null) {
            return new CustomObjectErroredFunction<T>(name, holder, args, "Resource type " + name + " not found");
        }
        CustomObjectConfigFunction<?> configFunction = null;
        for (Class<CustomObjectConfigFunction<?>> clazz : clazzes) {
            try {
                configFunction = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Reflection error while loading the resources: ", e);
            }
            boolean matchingTypes = holder.getClass().isAssignableFrom(configFunction.getHolderType());
            if (!matchingTypes) continue;
            try {
                configFunction.init(holder, args, logger, materialReader);
                break;
            }
            catch (InvalidConfigException e) {
                configFunction.invalidate(name, args, e.getMessage());
                break;
            }
        }
        if (configFunction == null) {
            return new CustomObjectErroredFunction<T>(name, holder, args, "Resource " + name + " cannot be placed in this config file");
        }
        return configFunction;
    }
}

