/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.config.io;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.SettingsReaderBO4;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSettingsReaderBO4
implements SettingsReaderBO4 {
    private final List<StringOnLine> configFunctions;
    private SettingsReaderBO4 fallback;
    private final File file;
    private final String name;
    private final Map<String, StringOnLine> settingsCache;

    private static final <T, C extends CustomObjectConfigFunction<T>> List<C> mergeListsCustomObject(Collection<? extends C> childList, Collection<? extends C> parentList) {
        ArrayList<C> returnList = new ArrayList<C>(childList);
        for (CustomObjectConfigFunction parentFunction : parentList) {
            if (FileSettingsReaderBO4.hasAnalogousFunction(parentFunction, childList)) continue;
            returnList.add(parentFunction);
        }
        return returnList;
    }

    private static final <T, C extends CustomObjectConfigFunction<T>> boolean hasAnalogousFunction(C function, Collection<? extends C> list) {
        for (CustomObjectConfigFunction toCheck : list) {
            if (!function.isAnalogousTo(toCheck)) continue;
            return true;
        }
        return false;
    }

    public FileSettingsReaderBO4(String name, File file, ILogger logger) {
        this.name = name;
        this.file = file;
        this.settingsCache = new HashMap<String, StringOnLine>();
        this.configFunctions = new ArrayList<StringOnLine>();
        this.readSettings(logger);
    }

    @Override
    public void flushCache() {
        this.settingsCache.clear();
        this.configFunctions.clear();
    }

    @Override
    public <T> void addConfigFunction(CustomObjectConfigFunction<T> function) {
        this.configFunctions.add(new StringOnLine(function.write(), -1));
    }

    @Override
    public <T> List<CustomObjectConfigFunction<T>> getConfigFunctions(T holder, boolean useFallback, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        ArrayList<CustomObjectConfigFunction<T>> result = new ArrayList<CustomObjectConfigFunction<T>>(this.configFunctions.size());
        for (StringOnLine configFunctionLine : this.configFunctions) {
            String parameters;
            List<String> args;
            int bracketIndex;
            String configFunctionString = configFunctionLine.string;
            String functionName = configFunctionString.substring(0, bracketIndex = configFunctionString.indexOf(40));
            CustomObjectConfigFunction<T> function = manager.getConfigFunction(functionName, holder, args = Arrays.asList(StringHelper.readCommaSeperatedString(parameters = configFunctionString.substring(bracketIndex + 1, configFunctionString.length() - 1))), logger, materialReader);
            if (function == null) {
                function = manager.getConfigFunction(functionName, holder, args, logger, materialReader);
            }
            result.add(function);
            if (function.isValid() || !logger.getLogCategoryEnabled(LogCategory.CONFIGS)) continue;
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Invalid resource {0} in {1} on line {2}: {3}", functionName, this.name, configFunctionLine.line, function.getError()));
        }
        if (useFallback && this.fallback != null) {
            return FileSettingsReaderBO4.mergeListsCustomObject(result, this.fallback.getConfigFunctions(holder, true, logger, materialReader, manager));
        }
        return result;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<Map.Entry<String, String>> getRawSettings() {
        ArrayList<Map.Entry<String, String>> lines = new ArrayList<Map.Entry<String, String>>(this.settingsCache.size());
        for (Map.Entry<String, StringOnLine> rawSetting : this.settingsCache.entrySet()) {
            lines.add(new Line(rawSetting.getKey(), rawSetting.getValue().string));
        }
        return lines;
    }

    @Override
    public <S> S getSetting(Setting<S> setting, S defaultValue, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        block4: {
            StringOnLine stringWithLineNumber = this.settingsCache.get(setting.getName().toLowerCase());
            if (stringWithLineNumber != null) {
                String stringValue = stringWithLineNumber.string;
                try {
                    return setting.read(stringValue, materialReader);
                }
                catch (InvalidConfigException e) {
                    if (!logger.getLogCategoryEnabled(LogCategory.CONFIGS)) break block4;
                    logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("The value \"{0}\" is not valid for the setting {1} in {2} on line {3}: {4}", stringValue, setting, this.name, stringWithLineNumber.line, e.getMessage()));
                }
            }
        }
        if (this.fallback != null) {
            return this.fallback.getSetting(setting, defaultValue, logger, materialReader, manager);
        }
        return defaultValue;
    }

    @Override
    public boolean hasSetting(Setting<?> setting) {
        if (this.settingsCache.containsKey(setting.getName().toLowerCase())) {
            return true;
        }
        if (this.fallback != null) {
            return this.fallback.hasSetting(setting);
        }
        return false;
    }

    @Override
    public boolean isNewConfig() {
        return !this.file.exists();
    }

    @Override
    public <S> void putSetting(Setting<S> setting, S value) {
        this.settingsCache.put(setting.getName().toLowerCase(), new StringOnLine(setting.write(value), -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettings(ILogger logger) {
        BufferedReader settingsReader = null;
        if (!this.file.exists()) {
            return;
        }
        try {
            String thisLine;
            settingsReader = new BufferedReader(new FileReader(this.file));
            int lineNumber = 0;
            while ((thisLine = settingsReader.readLine()) != null) {
                String[] splitSettings;
                ++lineNumber;
                if (thisLine.trim().isEmpty() || thisLine.startsWith("#") || thisLine.startsWith("<")) continue;
                if (thisLine.contains(":") || thisLine.toLowerCase().contains("(")) {
                    if (thisLine.contains("(") && (!thisLine.contains(":") || thisLine.indexOf(40) < thisLine.indexOf(58))) {
                        this.configFunctions.add(new StringOnLine(thisLine.trim(), lineNumber));
                        continue;
                    }
                    splitSettings = thisLine.split(":", 2);
                    this.settingsCache.put(splitSettings[0].trim().toLowerCase(), new StringOnLine(splitSettings[1].trim(), lineNumber));
                    continue;
                }
                if (!thisLine.contains("=")) continue;
                splitSettings = thisLine.split("=", 2);
                this.settingsCache.put(splitSettings[0].trim().toLowerCase(), new StringOnLine(splitSettings[1].trim(), lineNumber));
            }
        }
        catch (IOException e) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, String.format("Exception when reading file: ", e.getStackTrace()));
        }
        finally {
            if (settingsReader != null) {
                try {
                    settingsReader.close();
                }
                catch (IOException localIOException2) {
                    logger.log(LogLevel.ERROR, LogCategory.CONFIGS, String.format("Exception when closing file: ", localIOException2.getStackTrace()));
                }
            }
        }
    }

    @Override
    public void renameOldSetting(String oldValue, Setting<?> newValue) {
        if (this.settingsCache.containsKey(oldValue.toLowerCase())) {
            this.settingsCache.put(newValue.getName().toLowerCase(), this.settingsCache.get(oldValue.toLowerCase()));
        }
    }

    @Override
    public void setFallbackReader(SettingsReaderBO4 reader) {
        this.fallback = reader;
    }

    private static final class Line
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        private Line(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class StringOnLine {
        private final String string;
        private final int line;

        private StringOnLine(String string, int line) {
            this.string = string;
            this.line = line;
        }
    }
}

