/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.config.io;

import com.pg85.otg.config.settingType.Setting;
import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.bofunctions.BranchFunction;
import com.pg85.otg.customobject.config.CustomObjectConfigFile;
import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.SettingsWriterBO4;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class FileSettingsWriterBO4
implements SettingsWriterBO4 {
    private final File file;
    private boolean writeComments;
    private BufferedWriter writer;

    private FileSettingsWriterBO4(File file) {
        this.file = file;
    }

    public static void writeToFile(CustomObjectConfigFile config, SettingsEnums.ConfigMode configMode, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        FileSettingsWriterBO4.writeToFile(config, config.getFile(), configMode, logger, materialReader, manager);
    }

    public static void writeToFile(CustomObjectConfigFile config, File file, SettingsEnums.ConfigMode configMode, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        if (configMode == SettingsEnums.ConfigMode.WriteDisable) {
            return;
        }
        try {
            FileSettingsWriterBO4 writer = new FileSettingsWriterBO4(file);
            config.write(writer, configMode, logger, materialReader, manager);
        }
        catch (IOException e) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, String.format("Failed to write to file " + file + ", error: ", e.getStackTrace()));
        }
    }

    public static void writeToFileWithData(BO4Config config, List<BlockFunction<?>> blocksList, List<BranchFunction<?>> branchesList, ILogger logger, IMaterialReader materialReader, CustomObjectResourcesManager manager) {
        FileSettingsWriterBO4 writer = new FileSettingsWriterBO4(config.getFile());
        try {
            config.writeWithData(writer, blocksList == null ? new ArrayList() : blocksList, branchesList == null ? new ArrayList() : branchesList, logger, materialReader, manager);
        }
        catch (IOException e) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, String.format("Failed to write BO4 config " + config.getName() + ", error: ", e.getStackTrace()));
        }
    }

    @Override
    public void bigTitle(String title) throws IOException {
        this.checkState();
        this.writer.newLine();
        this.writer.write("#######################################################################");
        this.writer.newLine();
        this.writer.write("# +-----------------------------------------------------------------+ #");
        this.writer.newLine();
        StringBuilder builder = new StringBuilder(title);
        builder.insert(0, ' ');
        builder.append(' ');
        boolean flag = true;
        while (builder.length() < 65) {
            if (flag) {
                builder.insert(0, ' ');
            } else {
                builder.append(' ');
            }
            flag = !flag;
        }
        this.writer.write("# |" + builder.toString() + "| #");
        this.writer.newLine();
        this.writer.write("# +-----------------------------------------------------------------+ #");
        this.writer.newLine();
        this.writer.write("#######################################################################");
        this.writer.newLine();
        this.writer.newLine();
    }

    private void checkState() throws IllegalStateException {
        if (this.writer == null) {
            throw new IllegalStateException("Not started writing yet");
        }
    }

    @Override
    public void close(ILogger logger) {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            logger.log(LogLevel.ERROR, LogCategory.CONFIGS, MessageFormat.format("Failed to close file {0} ({1})", this.file.getAbsolutePath(), e.getMessage()));
        }
        this.writer = null;
    }

    @Override
    public void comment(String comment) throws IOException {
        this.checkState();
        if (!this.writeComments) {
            return;
        }
        if (comment.length() > 0) {
            this.writer.write("# " + comment);
        }
        this.writer.newLine();
    }

    @Override
    public void function(CustomObjectConfigFunction<?> function) throws IOException {
        this.checkState();
        this.writer.write(function.write());
        this.writer.newLine();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void open() throws IOException {
        this.file.getParentFile().mkdirs();
        this.writer = new BufferedWriter(new FileWriter(this.file));
    }

    @Override
    public void setConfigMode(SettingsEnums.ConfigMode configMode) {
        if (configMode == SettingsEnums.ConfigMode.WriteAll) {
            this.writeComments = true;
        } else if (configMode == SettingsEnums.ConfigMode.WriteWithoutComments) {
            this.writeComments = false;
        } else {
            throw new IllegalArgumentException("Invalid config mode: " + (Object)((Object)configMode));
        }
    }

    public <T> void setting(Setting<T> setting, T value) throws IOException {
        this.checkState();
        this.writer.write(setting.getName() + ": " + setting.write(value));
        this.writer.newLine();
        this.writer.newLine();
    }

    @Override
    public void smallTitle(String title) throws IOException {
        this.checkState();
        int titleLength = title.length();
        StringBuilder rowBuilder = new StringBuilder(titleLength + 4);
        for (int i = 0; i < titleLength + 4; ++i) {
            rowBuilder.append('#');
        }
        this.writer.write(rowBuilder.toString());
        this.writer.newLine();
        this.writer.write("# " + title + " #");
        this.writer.newLine();
        this.writer.write(rowBuilder.toString());
        this.writer.newLine();
        this.writer.newLine();
    }
}

