/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobject.creator;

import com.pg85.otg.constants.SettingsEnums;
import com.pg85.otg.customobject.CustomObjectManager;
import com.pg85.otg.customobject.bo3.BO3;
import com.pg85.otg.customobject.bo3.BO3Config;
import com.pg85.otg.customobject.bo3.bo3function.BO3BranchFunction;
import com.pg85.otg.customobject.bo4.BO4;
import com.pg85.otg.customobject.bo4.BO4Config;
import com.pg85.otg.customobject.bo4.bo4function.BO4BranchFunction;
import com.pg85.otg.customobject.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobject.bofunctions.BlockFunction;
import com.pg85.otg.customobject.bofunctions.BranchFunction;
import com.pg85.otg.customobject.config.CustomObjectConfigFile;
import com.pg85.otg.customobject.config.CustomObjectConfigFunction;
import com.pg85.otg.customobject.config.CustomObjectResourcesManager;
import com.pg85.otg.customobject.config.io.FileSettingsReaderBO4;
import com.pg85.otg.customobject.config.io.FileSettingsWriterBO4;
import com.pg85.otg.customobject.creator.Extractor;
import com.pg85.otg.customobject.creator.ObjectType;
import com.pg85.otg.customobject.structures.StructuredCustomObject;
import com.pg85.otg.customobject.util.BoundingBox;
import com.pg85.otg.customobject.util.Corner;
import com.pg85.otg.exceptions.InvalidConfigException;
import com.pg85.otg.interfaces.ILogger;
import com.pg85.otg.interfaces.IMaterialReader;
import com.pg85.otg.interfaces.IModLoadedChecker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.gen.LocalWorldGenRegion;
import com.pg85.otg.util.logging.LogCategory;
import com.pg85.otg.util.logging.LogLevel;
import com.pg85.otg.util.materials.LocalMaterialData;
import com.pg85.otg.util.nbt.LocalNBTHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObjectCreator {
    public static StructuredCustomObject create(ObjectType type, Corner min, Corner max, Corner center, LocalMaterialData centerBlock, String objectName, boolean includeAir, boolean isStructure, boolean leaveIllegalLeaves, Path objectPath, LocalWorldGenRegion localWorld, LocalNBTHelper nbtHelper, List<BlockFunction<?>> extraBlocks, CustomObjectConfigFile template, String presetFolderName, Path rootPath, ILogger logger, CustomObjectManager boManager, IMaterialReader mr, CustomObjectResourcesManager manager, IModLoadedChecker mlc, List<LocalMaterialData> excludes) {
        if (isStructure) {
            return ObjectCreator.createStructure(type, min, max, center, objectName, includeAir, leaveIllegalLeaves, objectPath, localWorld, nbtHelper, template, presetFolderName, rootPath, logger, boManager, mr, manager, mlc, excludes);
        }
        return ObjectCreator.createObject(type, min, max, center, centerBlock, objectName, includeAir, leaveIllegalLeaves, objectPath, localWorld, nbtHelper, extraBlocks, template, presetFolderName, rootPath, logger, boManager, mr, manager, mlc, excludes);
    }

    public static StructuredCustomObject create(ObjectType type, Corner min, Corner max, Corner center, LocalMaterialData centerBlock, String objectName, boolean includeAir, boolean isStructure, boolean leaveIllegalLeaves, Path objectPath, LocalWorldGenRegion localWorld, LocalNBTHelper nbtHelper, List<BlockFunction<?>> extraBlocks, CustomObjectConfigFile template, String presetFolderName, Path rootPath, ILogger logger, CustomObjectManager boManager, IMaterialReader mr, CustomObjectResourcesManager manager, IModLoadedChecker mlc) {
        return ObjectCreator.create(type, min, max, center, centerBlock, objectName, includeAir, isStructure, leaveIllegalLeaves, objectPath, localWorld, nbtHelper, extraBlocks, template, presetFolderName, rootPath, logger, boManager, mr, manager, mlc, new ArrayList<LocalMaterialData>());
    }

    public static StructuredCustomObject createObject(ObjectType type, Corner min, Corner max, Corner center, LocalMaterialData centerBlock, String objectName, boolean includeAir, boolean leaveIllegalLeaves, Path exportPath, LocalWorldGenRegion localWorld, LocalNBTHelper nbtHelper, List<BlockFunction<?>> extraBlocks, CustomObjectConfigFile template, String presetFolderName, Path rootPath, ILogger logger, CustomObjectManager boManager, IMaterialReader mr, CustomObjectResourcesManager manager, IModLoadedChecker mlc) {
        return ObjectCreator.createObject(type, min, max, center, centerBlock, objectName, includeAir, leaveIllegalLeaves, exportPath, localWorld, nbtHelper, extraBlocks, template, presetFolderName, rootPath, logger, boManager, mr, manager, mlc, new ArrayList<LocalMaterialData>());
    }

    public static StructuredCustomObject createObject(ObjectType type, Corner min, Corner max, Corner center, LocalMaterialData centerBlock, String objectName, boolean includeAir, boolean leaveIllegalLeaves, Path exportPath, LocalWorldGenRegion localWorld, LocalNBTHelper nbtHelper, List<BlockFunction<?>> extraBlocks, CustomObjectConfigFile template, String presetFolderName, Path rootPath, ILogger logger, CustomObjectManager boManager, IMaterialReader mr, CustomObjectResourcesManager manager, IModLoadedChecker mlc, List<LocalMaterialData> excludes) {
        Path destinationPath;
        File exportFolder = exportPath.toFile();
        if (centerBlock != null) {
            block2: for (int x = min.x; x <= max.x; ++x) {
                for (int z = min.z; z <= max.z; ++z) {
                    for (int y = min.y; y <= max.y; ++y) {
                        LocalMaterialData data = localWorld.getMaterial(x, y, z);
                        if (data == null || !data.isMaterial(centerBlock)) continue;
                        center = new Corner(x, y, z);
                        break block2;
                    }
                }
            }
        }
        List<BlockFunction<?>> blocks = Extractor.getBlockFunctions(type, min, max, center, localWorld, nbtHelper, includeAir, leaveIllegalLeaves, objectName, exportFolder, excludes);
        if (extraBlocks != null) {
            blocks.addAll(extraBlocks);
        }
        if ((destinationPath = type.getObjectFilePathFromName(objectName, exportPath)).toFile().exists()) {
            Path backupPath = destinationPath.resolveSibling(objectName + "." + type.getType() + ".backup");
            try {
                if (backupPath.toFile().exists()) {
                    Files.delete(backupPath);
                }
                Files.move(destinationPath, backupPath, new CopyOption[0]);
            }
            catch (IOException e) {
                logger.log(LogLevel.ERROR, LogCategory.MAIN, "Failed to rename old file " + destinationPath.getFileName());
                logger.printStackTrace(LogLevel.ERROR, LogCategory.MAIN, e);
            }
        }
        CustomObjectConfigFile config = ObjectCreator.makeNewConfig(type, template, objectName, destinationPath, max, min, center, blocks, null, presetFolderName, logger, rootPath, boManager, mr, manager, mlc);
        return ObjectCreator.writeToFile(type, objectName, exportPath, logger, mr, manager, config);
    }

    private static StructuredCustomObject writeToFile(ObjectType type, String objectName, Path exportPath, ILogger logger, IMaterialReader mr, CustomObjectResourcesManager manager, CustomObjectConfigFile config) {
        switch (type) {
            case BO3: {
                FileSettingsWriterBO4.writeToFile(config, config.getFile(), config.settingsMode, logger, mr, manager);
                return new BO3(objectName, type.getObjectFilePathFromName(objectName, exportPath).toFile(), (BO3Config)config);
            }
            case BO4: {
                return new BO4(objectName, type.getObjectFilePathFromName(objectName, exportPath).toFile(), (BO4Config)config);
            }
        }
        return null;
    }

    public static StructuredCustomObject createStructure(ObjectType type, Corner min, Corner max, Corner center, String objectName, boolean includeAir, boolean leaveIllegalLeaves, Path objectPath, LocalWorldGenRegion localWorld, LocalNBTHelper nbtHelper, CustomObjectConfigFile template, String presetFolderName, Path rootPath, ILogger logger, CustomObjectManager boManager, IMaterialReader mr, CustomObjectResourcesManager manager, IModLoadedChecker mlc, List<LocalMaterialData> excludes) {
        File branchFolder = new File(objectPath.toFile(), objectName);
        branchFolder.mkdirs();
        int chunksOnXAxis = Math.abs(max.x - min.x) / 16;
        int chunksOnZAxis = Math.abs(max.z - min.z) / 16;
        if ((max.x - min.x) % 16 > 0) {
            ++chunksOnXAxis;
        }
        if ((max.z - min.z) % 16 > 0) {
            ++chunksOnZAxis;
        }
        List[][] branchGrid = new ArrayList[chunksOnXAxis][chunksOnZAxis];
        boolean[][] exists = new boolean[chunksOnXAxis][chunksOnZAxis];
        for (int branchX = 0; branchX < chunksOnXAxis; ++branchX) {
            for (int branchZ = 0; branchZ < chunksOnZAxis; ++branchZ) {
                Corner branchMin = new Corner(min.x + 16 * branchX, min.y, min.z + 16 * branchZ);
                Corner branchMax = new Corner(branchX == chunksOnXAxis - 1 ? max.x : branchMin.x + 15, max.y, branchZ == chunksOnZAxis - 1 ? max.z : branchMin.z + 15);
                String branchName = objectName + "_C" + branchX + "_R" + branchZ;
                branchGrid[branchX][branchZ] = Extractor.getBlockFunctions(type, branchMin, branchMax, branchMin, localWorld, nbtHelper, includeAir, leaveIllegalLeaves, branchName, branchFolder, excludes);
                exists[branchX][branchZ] = !branchGrid[branchX][branchZ].isEmpty();
            }
        }
        boolean[][] processed = new boolean[chunksOnXAxis][chunksOnZAxis];
        ArrayList<ChunkCoordinate> heads = new ArrayList<ChunkCoordinate>();
        for (int x = 0; x < chunksOnXAxis; ++x) {
            for (int z = 0; z < chunksOnZAxis; ++z) {
                if (!exists[x][z]) continue;
                if (!processed[x][z]) {
                    processed[x][z] = true;
                    heads.add(ChunkCoordinate.fromChunkCoords(x, z));
                }
                ArrayList branches = new ArrayList();
                if (x < exists.length - 1 && exists[x + 1][z] && !processed[x + 1][z]) {
                    processed[x + 1][z] = true;
                    ObjectCreator.addBranch(type, branches, objectName, 16, 0, 0, x + 1, z, logger, mr);
                }
                if (z < exists[0].length - 1 && exists[x][z + 1] && !processed[x][z + 1]) {
                    processed[x][z + 1] = true;
                    ObjectCreator.addBranch(type, branches, objectName, 0, 0, 16, x, z + 1, logger, mr);
                }
                if (x > 0 && exists[x - 1][z] && !processed[x - 1][z]) {
                    processed[x - 1][z] = true;
                    ObjectCreator.addBranch(type, branches, objectName, -16, 0, 0, x - 1, z, logger, mr);
                }
                if (z > 0 && exists[x][z - 1] && !processed[x][z - 1]) {
                    processed[x][z - 1] = true;
                    ObjectCreator.addBranch(type, branches, objectName, 0, 0, -16, x, z - 1, logger, mr);
                }
                String branchName = objectName + "_C" + x + "_R" + z;
                Path branchPath = type.getObjectFilePathFromName(branchName, branchFolder.toPath());
                CustomObjectConfigFile branchTemplate = null;
                try {
                    branchTemplate = type == ObjectType.BO4 ? new BO4Config(new FileSettingsReaderBO4(branchName, branchPath.toFile(), logger), true, presetFolderName, rootPath, logger, boManager, mr, manager, mlc) : template;
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                    return null;
                }
                Corner localmin = new Corner(min.x + 16 * x, min.y, min.z + 16 * z);
                Corner localmax = new Corner(x == chunksOnXAxis - 1 ? max.x : min.x + 16 * x + 15, max.y, z == chunksOnZAxis - 1 ? max.z : min.z + 16 * z + 15);
                CustomObjectConfigFile branchConfig = ObjectCreator.makeNewConfig(type, branchTemplate, branchName, branchPath, localmin, localmax, localmin, branchGrid[x][z], branches, presetFolderName, logger, rootPath, boManager, mr, manager, mlc);
                if (type == ObjectType.BO4) continue;
                FileSettingsWriterBO4.writeToFile(branchConfig, branchConfig.getFile(), branchConfig.settingsMode, logger, mr, manager);
            }
        }
        ArrayList branches = new ArrayList();
        for (ChunkCoordinate coord : heads) {
            ObjectCreator.addBranch(type, branches, objectName, coord.getChunkX() * 16, 0, coord.getChunkZ() * 16, coord.getChunkX(), coord.getChunkZ(), logger, mr);
        }
        logger.log(LogLevel.INFO, LogCategory.MAIN, "Creating structure " + objectName + " with " + branches.size() + " direct branches");
        CustomObjectConfigFile config = ObjectCreator.makeNewConfig(type, template, objectName, type.getObjectFilePathFromName(objectName, objectPath), min, max, center, null, branches, presetFolderName, logger, rootPath, boManager, mr, manager, mlc);
        return ObjectCreator.writeToFile(type, objectName, objectPath, logger, mr, manager, config);
    }

    private static void addBranch(ObjectType type, List<BranchFunction<?>> branches, String objectName, int x, int y, int z, int chunkX, int chunkZ, ILogger logger, IMaterialReader mr) {
        switch (type) {
            case BO3: {
                branches.add((BO3BranchFunction)CustomObjectConfigFunction.create(null, BO3BranchFunction.class, logger, mr, x, y, z, objectName + "_C" + chunkX + "_R" + chunkZ, "NORTH", 100));
                break;
            }
            case BO4: {
                branches.add((BO4BranchFunction)CustomObjectConfigFunction.create(null, BO4BranchFunction.class, logger, mr, x, y, z, true, objectName + "_C" + chunkX + "_R" + chunkZ, "NORTH", 100, 0));
                break;
            }
            default: {
                throw new RuntimeException("Tried adding branch to BO2");
            }
        }
    }

    private static CustomObjectConfigFile makeNewConfig(ObjectType type, CustomObjectConfigFile template, String objectName, Path objectFilePath, Corner max, Corner min, Corner center, List<BlockFunction<?>> blocks, List<BranchFunction<?>> branches, String presetFolderName, ILogger logger, Path rootPath, CustomObjectManager boManager, IMaterialReader mr, CustomObjectResourcesManager manager, IModLoadedChecker mlc) {
        FileSettingsReaderBO4 reader = new FileSettingsReaderBO4(objectName, objectFilePath.toFile(), logger);
        if (blocks == null) {
            blocks = new ArrayList();
        }
        switch (type) {
            case BO3: {
                BO3Config config = ((BO3Config)template).cloneConfigValues(reader);
                if (branches != null) {
                    config.setBranches(branches);
                }
                if (config.settingsMode == SettingsEnums.ConfigMode.WriteDisable) {
                    config.settingsMode = SettingsEnums.ConfigMode.WriteWithoutComments;
                }
                BoundingBox box = BoundingBox.newEmptyBox();
                box.expandToFit(min.x - center.x, min.y - center.y, min.z - center.z);
                box.expandToFit(max.x - center.x, max.y - center.y, max.z - center.z);
                config.setBoundingBox(box);
                config.extractBlocks(blocks);
                config.rotateBlocksAndChecks(presetFolderName, rootPath, logger, boManager, mr, manager, mlc);
                return config;
            }
            case BO4: {
                BlockFunction<?>[] blocksListOriginal;
                BO4Config config = (BO4Config)template;
                if (config.settingsMode == SettingsEnums.ConfigMode.WriteDisable) {
                    config.settingsMode = SettingsEnums.ConfigMode.WriteWithoutComments;
                }
                config.reader = reader;
                if (branches == null && config.getbranches() != null) {
                    branches = Arrays.asList(config.getbranches());
                }
                ArrayList mergedBlocks = new ArrayList(blocks);
                for (BlockFunction<?> block : blocksListOriginal = config.getBlockFunctions(presetFolderName, rootPath, logger, boManager, mr, manager, mlc)) {
                    if (block instanceof BO4RandomBlockFunction || block.material == null || !block.material.isAir() || blocks.stream().anyMatch(a -> a.x == block.x && a.y == block.y && a.z == block.z)) continue;
                    mergedBlocks.add(block);
                }
                FileSettingsWriterBO4.writeToFileWithData(config, mergedBlocks, branches, logger, mr, manager);
                BO4 object = (BO4)boManager.getObjectLoaders().get(type.getType().toLowerCase()).loadFromFile(objectName, objectFilePath.toFile(), logger);
                if (object == null) {
                    throw new RuntimeException("Could not load BO4 " + objectName + " at " + objectFilePath);
                }
                if (!object.onEnable(presetFolderName, rootPath, logger, boManager, mr, manager, mlc)) {
                    throw new RuntimeException("Could not enable BO4 " + objectName);
                }
                return object.getConfig();
            }
        }
        throw new RuntimeException("Tried to create BO2 config");
    }
}

